/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.domain.impl.externallink;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.people.domain.model.TenantId;
import de.justsoftware.people.domain.model.externallink.ExternalLinkBO;
import de.justsoftware.people.domain.model.externallink.ExternalLinkId;
import de.justsoftware.people.domain.model.profile.ProfileId;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.type.JdbcType;

@Mapper
@ParametersAreNonnullByDefault
public interface ExternalLinkMapper {
    @Insert(value={"INSERT INTO external_link(id, uri, creator_id, tenant_id, description) ", "VALUES (#{id}, #{uri}, #{creatorId}, #{tenantId}, #{description})"})
    public void createExternalLink(@Param(value="id") ExternalLinkId var1, @Param(value="creatorId") ProfileId var2, @Param(value="tenantId") TenantId var3, @Param(value="uri") String var4, @Param(value="description") String var5);

    @ConstructorArgs(value={@Arg(javaType=ExternalLinkId.class, column="id", id=true), @Arg(javaType=String.class, column="uri", jdbcType=JdbcType.VARCHAR), @Arg(javaType=TenantId.class, column="tenant_id"), @Arg(javaType=ProfileId.class, column="creator_id"), @Arg(javaType=String.class, column="description", jdbcType=JdbcType.VARCHAR)})
    @Select(value={"<script>", "SELECT id, uri, tenant_id, creator_id, description ", "FROM external_link", "WHERE tenant_id = #{tenantId}", "</script>"})
    @ResultType(value=ExternalLinkBO.class)
    @Nonnull
    public List<ExternalLinkBO> getAllExternalLinks(@Param(value="tenantId") TenantId var1);

    @Delete(value={"<script>DELETE FROM external_link WHERE tenant_id = #{tenantId} AND id IN (<foreach collection='linkIds' item='i' separator=','>#{i}</foreach>)</script>"})
    public void deleteLinksById(@Param(value="tenantId") TenantId var1, @Param(value="linkIds") ImmutableSet<ExternalLinkId> var2);
}

