/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.domain.impl;

import de.justsoftware.people.domain.JdbcConnectionConfiguration;
import de.justsoftware.people.domain.impl.JdbcConnectionConfigurationImpl;
import de.justsoftware.people.domain.impl.PeoplePersistenceScanMarker;
import de.justsoftware.toolbox.mybatis.DAOSupport;
import de.justsoftware.toolbox.mybatis.SupportedJdbcDriver;
import de.justsoftware.toolbox.mybatis.result.DAOSupportImpl;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@MapperScan(basePackageClasses={PeoplePersistenceScanMarker.class}, sqlSessionFactoryRef="sqlSessionFactory")
@ParametersAreNonnullByDefault
public class PeoplePersistenceConfiguration {
    @Bean
    @Nonnull
    public JdbcConnectionConfiguration jdbcConnectionConfiguration(@Value(value="${spring.datasource.url}") String jdbcUrl, @Value(value="${spring.datasource.username}") String jdbcUser, @Value(value="${spring.datasource.password}") String jdbcPassword) {
        return new JdbcConnectionConfigurationImpl(jdbcUrl, jdbcUser, jdbcPassword);
    }

    @Bean
    @Nonnull
    public DAOSupport daoSupport(JdbcConnectionConfiguration jdbcConnectionConfiguration) {
        SupportedJdbcDriver driver = jdbcConnectionConfiguration.driver();
        return new DAOSupportImpl(() -> driver);
    }
}

