/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.domain.impl;

import de.justsoftware.people.domain.JdbcConnectionConfiguration;
import de.justsoftware.people.domain.impl.JustPeopleSqlSessionFactoryBean;
import de.justsoftware.toolbox.mybatis.SupportedJdbcDriver;
import de.justsoftware.toolbox.mybatis.type.AbstractDriverSpecificTypeHandler;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.boot.autoconfigure.SpringBootVFS;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service(value="sqlSessionFactory")
class JustPeopleSqlSessionFactoryBean
extends SqlSessionFactoryBean {
    static final String SQL_SESSION_FACTORY = "sqlSessionFactory";
    private final JdbcConnectionConfiguration _jdbcConnectionConfiguration;
    private final int _batchSize;

    @Autowired
    public JustPeopleSqlSessionFactoryBean(DataSource dataSource, JdbcConnectionConfiguration jdbcConnectionConfiguration, @Value(value="${just.people.jdbc.batchsize:100}") int batchSize) {
        this._jdbcConnectionConfiguration = jdbcConnectionConfiguration;
        this._batchSize = batchSize;
        this.setDataSource(dataSource);
        this.setTypeHandlersPackage("de.justsoftware.people.domain.impl.typehandler,de.justsoftware.toolbox.mybatis.type.common");
        this.setTransactionFactory((TransactionFactory)new SpringManagedTransactionFactory());
        this.setSqlSessionFactoryBuilder((SqlSessionFactoryBuilder)new SqlSessionFactoryBuilderExtension(this));
        this.setVfs(SpringBootVFS.class);
    }

    protected SqlSessionFactory buildSqlSessionFactory() throws Exception {
        AbstractDriverSpecificTypeHandler.setJdbcDriver((SupportedJdbcDriver)this._jdbcConnectionConfiguration.driver());
        SqlSessionFactory sqlSessionFactory = super.buildSqlSessionFactory();
        AbstractDriverSpecificTypeHandler.setJdbcDriver(null);
        return sqlSessionFactory;
    }
}

