/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.controller;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import de.justsoftware.people.application.SearchApplicationService;
import de.justsoftware.people.application.UserGroupApplicationService;
import de.justsoftware.people.application.model.PermissionDetails;
import de.justsoftware.people.application.model.ProfileSearchModel;
import de.justsoftware.people.application.model.ProfileSearchResult;
import de.justsoftware.people.application.model.UserGroup;
import de.justsoftware.people.application.model.UserGroupDetails;
import de.justsoftware.people.application.utils.PagedResults;
import de.justsoftware.people.authorization.AuthorizationContext;
import de.justsoftware.people.business.profile.model.Profile;
import de.justsoftware.people.business.search.model.SearchableField;
import de.justsoftware.people.controller.UserGroupController;
import de.justsoftware.people.controller.model.PagedResultModel;
import de.justsoftware.people.domain.model.PagedResult;
import de.justsoftware.people.domain.model.usergroup.UserGroupId;
import de.justsoftware.people.domain.model.usergroup.UserGroupRole;
import de.justsoftware.people.exceptions.NotFoundException;
import de.justsoftware.permission.client.model.Role;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(value={"/api/usergroups"})
public class UserGroupController {
    private final UserGroupApplicationService _userGroupApplicationService;
    private final SearchApplicationService _searchApplicationService;

    public UserGroupController(UserGroupApplicationService userGroupApplicationService, SearchApplicationService searchApplicationService) {
        this._userGroupApplicationService = userGroupApplicationService;
        this._searchApplicationService = searchApplicationService;
    }

    @Nonnull
    @PostMapping
    public UserGroupDetails createGroup(AuthorizationContext authCtx, @RequestBody UserGroupNameModel userGroupNameModel) {
        UserGroupId groupId = this._userGroupApplicationService.createUserGroup(authCtx, userGroupNameModel._name, authCtx.getTenantId());
        return (UserGroupDetails)this._userGroupApplicationService.getUserGroupDetails(authCtx, groupId).orElseThrow(this.userGroupNotFound(groupId));
    }

    @Nonnull
    @GetMapping(value={"/{groupId}"})
    public UserGroupDetails getGroup(AuthorizationContext authCtx, @PathVariable UserGroupId groupId) {
        return (UserGroupDetails)this._userGroupApplicationService.getUserGroupDetails(authCtx, groupId).orElseThrow(this.userGroupNotFound(groupId));
    }

    @CheckForNull
    @GetMapping(value={"/allUsers"})
    public UserGroup getAllTenantUsersGroup(@RequestParam(value="mayInteract", required=false, defaultValue="false") Boolean mayInteract, AuthorizationContext authCtx) {
        return this._userGroupApplicationService.getAllTenantUsersGroup(authCtx, authCtx.getTenantId(), mayInteract).orElse(null);
    }

    @PutMapping(value={"/{groupId}"})
    public void updateUserGroup(AuthorizationContext authCtx, @PathVariable UserGroupId groupId, @RequestBody UserGroupNameModel userGroupNameModel) {
        this._userGroupApplicationService.renameUserGroup(authCtx, groupId, userGroupNameModel._name);
    }

    @DeleteMapping(value={"/{groupId}"})
    public void deleteUserGroup(AuthorizationContext authCtx, @PathVariable UserGroupId groupId) {
        this._userGroupApplicationService.deleteUserGroup(authCtx, groupId);
    }

    @Nonnull
    @GetMapping
    public PagedResult<UserGroup> getAllGroups(@Nullable @RequestParam(value="query", required=false) String query, @RequestParam(value="offset") int offset, @RequestParam(value="limit") int limit, AuthorizationContext authCtx) {
        return this._userGroupApplicationService.getUserGroups(authCtx, authCtx.getTenantId(), Strings.nullToEmpty((String)query), offset, limit);
    }

    @PutMapping(value={"/{groupId}/members"})
    public void updateGroupMembers(AuthorizationContext authCtx, @PathVariable UserGroupId groupId, @RequestBody GroupEditMembersModel groupEditMembersModel) {
        this._userGroupApplicationService.updateMembers(authCtx, groupId, groupEditMembersModel._add, groupEditMembersModel._remove);
    }

    @Nonnull
    @GetMapping(value={"/{groupId}/members"})
    public PagedResult<Profile> getUserGroupMembers(AuthorizationContext authCtx, @Nullable @RequestParam(value="query", required=false) String query, @RequestParam(value="offset") int offset, @RequestParam(value="limit") int limit, @PathVariable UserGroupId groupId) {
        return PagedResults.map((PagedResult)this._searchApplicationService.allProfiles(authCtx, null, Strings.nullToEmpty((String)query), (List)ImmutableList.of(), null, null, groupId, offset, limit), ProfileSearchResult::getProfile);
    }

    @Nonnull
    @PostMapping(value={"/{groupId}/members"})
    public PagedResultModel<Profile> filterUserGroupMembers(AuthorizationContext authCtx, @RequestParam(value="offset", defaultValue="0") int offset, @RequestParam(value="limit", defaultValue="50") int limit, @PathVariable UserGroupId groupId, @RequestBody ProfileSearchModel profileSearchModel) {
        PagedResult result = this._searchApplicationService.allProfiles(authCtx, null, profileSearchModel.getSearchString(), (List)profileSearchModel.getSearchFilter(), profileSearchModel.getFacetFilter(), null, groupId, offset, limit);
        ImmutableListMultimap facets = (ImmutableListMultimap)result.getFacets().entries().stream().collect(ImmutableListMultimap.toImmutableListMultimap(e -> ((SearchableField)e.getKey()).getId(), e -> (String)e.getValue()));
        return new PagedResultModel(result.getOffset(), result.getTotalCount(), (ImmutableList)result.getRows().stream().map(ProfileSearchResult::getProfile).collect(ImmutableList.toImmutableList()), (ImmutableMultimap)facets);
    }

    @Nonnull
    @GetMapping(value={"/{groupId}/permissions"})
    public PermissionDetails getUserGroupPermissions(AuthorizationContext authCtx, @PathVariable UserGroupId groupId) {
        return this._userGroupApplicationService.getUserGroupPermissions(authCtx, groupId);
    }

    @Nonnull
    @PutMapping(value={"/{groupId}/permissions"})
    public PermissionDetails updateUserGroupPermissions(AuthorizationContext authCtx, @PathVariable UserGroupId groupId, @RequestBody Map<Role, UserGroupRole> userGroupRoles) {
        this._userGroupApplicationService.setUserGroupPermissions(authCtx, groupId, userGroupRoles);
        return this._userGroupApplicationService.getUserGroupPermissions(authCtx, groupId);
    }

    @Nonnull
    private Supplier<NotFoundException> userGroupNotFound(UserGroupId groupId) {
        return () -> new NotFoundException("Could not find user group " + groupId, groupId.toString());
    }
}

