/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.controller;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import de.justsoftware.people.application.SearchApplicationService;
import de.justsoftware.people.application.model.ProfileCsvInputStream;
import de.justsoftware.people.application.model.ProfileSearchModel;
import de.justsoftware.people.application.model.ProfileSearchResult;
import de.justsoftware.people.application.model.SearchFilterModel;
import de.justsoftware.people.authorization.AuthorizationContext;
import de.justsoftware.people.business.profile.model.Profile;
import de.justsoftware.people.business.search.model.SearchableField;
import de.justsoftware.people.controller.model.PagedResultModel;
import de.justsoftware.people.controller.model.ProfileAttributeConfigModel;
import de.justsoftware.people.domain.model.PagedResult;
import de.justsoftware.people.domain.model.profile.ProfileId;
import de.justsoftware.people.domain.model.usergroup.UserGroupId;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(value={"api/profiles"})
public class ProfileController {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("uuuuMMdd_HHmmss");
    private final SearchApplicationService _searchApplicationService;

    public ProfileController(SearchApplicationService searchApplicationService) {
        this._searchApplicationService = searchApplicationService;
    }

    @Nonnull
    @GetMapping
    public PagedResult<ProfileSearchResult> getProfiles(AuthorizationContext authCtx, @Nullable @RequestParam(value="query", required=false) String query, @Nullable @RequestParam(value="contextGroupId", required=false) UserGroupId contextGroupId, @RequestParam(value="offset", defaultValue="0") int offset, @RequestParam(value="limit", defaultValue="50") int limit) {
        return this._searchApplicationService.allProfiles(authCtx, authCtx.getTenantId(), Strings.nullToEmpty((String)query), (List)ImmutableList.of(), null, contextGroupId, null, offset, limit);
    }

    @Nonnull
    @PostMapping
    public PagedResultModel<ProfileSearchResult> searchProfiles(AuthorizationContext authCtx, @RequestParam(value="offset", defaultValue="0") int offset, @RequestParam(value="limit", defaultValue="50") int limit, @Nullable @RequestParam(value="contextGroupId", required=false) UserGroupId contextGroupId, @Nullable @RequestBody(required=false) ProfileSearchModel requestSearchModel) {
        ProfileSearchModel profileSearchModel = Optional.ofNullable(requestSearchModel).orElse(ProfileSearchModel.EMPTY);
        PagedResult result = this._searchApplicationService.allProfiles(authCtx, authCtx.getTenantId(), profileSearchModel.getSearchString(), (List)profileSearchModel.getSearchFilter(), profileSearchModel.getFacetFilter(), contextGroupId, null, offset, limit);
        ImmutableListMultimap facets = (ImmutableListMultimap)result.getFacets().entries().stream().collect(ImmutableListMultimap.toImmutableListMultimap(e -> ((SearchableField)e.getKey()).getId(), e -> (String)e.getValue()));
        return new PagedResultModel(result.getOffset(), result.getTotalCount(), result.getRows(), (ImmutableMultimap)facets);
    }

    @GetMapping(value={"/export"})
    public void exportProfiles(AuthorizationContext authCtx, @RequestParam(value="locale") String locale, @Nullable @RequestParam(value="groupId", required=false) UserGroupId groupId, @Nullable @RequestParam(value="query", required=false) String query, @Nullable @RequestParam(value="searchFilters", required=false) List<SearchFilterModel> searchFilters, HttpServletResponse response) throws IOException {
        LocalDateTime now = LocalDateTime.now();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + DATE_TIME_FORMATTER.format(now) + "_people_export.csv\"");
        response.setHeader("Content-Type", "text/csv");
        response.setHeader("Content-Transfer-Encoding", "binary");
        try (BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            int len;
            ProfileCsvInputStream pagedResultInputStream = this._searchApplicationService.exportProfiles(authCtx, authCtx.getTenantId(), query == null ? "" : query, (List)(searchFilters == null ? ImmutableList.of() : searchFilters), groupId, locale);
            int bufferLength = 1024;
            byte[] buf = new byte[1024];
            while ((len = pagedResultInputStream.read(buf)) > 0) {
                bos.write(buf, 0, len);
                bos.flush();
            }
        }
        response.flushBuffer();
    }

    @Nonnull
    @GetMapping(value={"/searchConfig"})
    public ImmutableList<ProfileAttributeConfigModel> getSearchConfiguration(AuthorizationContext authCtx) {
        return (ImmutableList)this._searchApplicationService.getSearchConfiguration(authCtx, authCtx.getTenantId()).stream().map(c -> new ProfileAttributeConfigModel(c.getName(), c.isVisibleOnBadge(), c.isSearchable(), c.isFacetable(), c.isClickable(), (String)c.getSearchFieldId().map(SearchableField::getId).orElse(null), c.isSearchInFacetsSupported(), c.isTranslated())).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    @GetMapping(value={"/{profileId}"})
    public Profile getProfile(AuthorizationContext authCtx, @PathVariable ProfileId profileId) {
        return this._searchApplicationService.getProfile(authCtx, profileId);
    }
}

