/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import de.justsoftware.people.application.model.SearchFilterModel;
import de.justsoftware.people.config.PeopleRestConfig;
import de.justsoftware.people.domain.model.AbstractId;
import de.justsoftware.people.domain.model.TenantId;
import de.justsoftware.people.domain.model.profile.ProfileId;
import de.justsoftware.people.domain.model.usergroup.UserGroupId;
import java.beans.PropertyEditor;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.InitBinder;

@Configuration
@ControllerAdvice
@ParametersAreNonnullByDefault
public class PeopleRestConfig {
    @Bean
    @Primary
    @Nonnull
    public MappingJackson2HttpMessageConverter jackson2HttpMessageConverter() {
        return new MappingJackson2HttpMessageConverter(new Jackson2ObjectMapperBuilder().modules(new Module[]{this.mappingModule(), new GuavaModule()}).serializationInclusion(JsonInclude.Include.NON_NULL).build());
    }

    @Nonnull
    private Module mappingModule() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(UserGroupId.class, (JsonSerializer)new FuncJsonSerializer(AbstractId::toString));
        module.addSerializer(ProfileId.class, (JsonSerializer)new FuncJsonSerializer(AbstractId::toString));
        module.addSerializer(TenantId.class, (JsonSerializer)new FuncJsonSerializer(AbstractId::toString));
        return module;
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(TenantId.class, (PropertyEditor)new FuncPropertyEditor(AbstractId::toString, TenantId::parse));
        binder.registerCustomEditor(UserGroupId.class, (PropertyEditor)new FuncPropertyEditor(AbstractId::toString, UserGroupId::parse));
        binder.registerCustomEditor(ProfileId.class, (PropertyEditor)new FuncPropertyEditor(AbstractId::toString, ProfileId::parse));
        binder.registerCustomEditor(SearchFilterModel.class, (PropertyEditor)new FuncPropertyEditor(SearchFilterModel::toString, SearchFilterModel::parse));
    }
}

