/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.config;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.people.application.exception.NotInSameTenantException;
import de.justsoftware.people.authorization.AuthorizationException;
import de.justsoftware.people.config.PeopleExceptionHandler;
import de.justsoftware.people.config.UnsupportedFeatureException;
import de.justsoftware.people.controller.ErrorCode;
import de.justsoftware.people.exceptions.NotFoundException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.NestedRuntimeException;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@ControllerAdvice
@ParametersAreNonnullByDefault
public class PeopleExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PeopleExceptionHandler.class);
    private static final String MESSAGE_PARAM = "message";

    @Nonnull
    private static ResponseEntity<ErrorModel> handle(ErrorModel error, LogLevel logLevel, Throwable e) {
        logLevel.log(e, error.getUuid());
        return new ResponseEntity((Object)error, error.getErrorCode().getHttpStatus());
    }

    @Nonnull
    private static ResponseEntity<ErrorModel> handle(ErrorCode errorCode, LogLevel logLevel, Throwable e) {
        return PeopleExceptionHandler.handle((ErrorCode)errorCode, (Map)ImmutableMap.of(), (LogLevel)logLevel, (Throwable)e);
    }

    @Nonnull
    private static ResponseEntity<ErrorModel> handle(ErrorCode errorCode, Map<String, ?> messageParams, LogLevel logLevel, Throwable e) {
        return PeopleExceptionHandler.handle((ErrorModel)new ErrorModel(errorCode, messageParams), (LogLevel)logLevel, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler
    public ResponseEntity<ErrorModel> handleAuthorizationException(AuthorizationException e) {
        return PeopleExceptionHandler.handle((ErrorCode)ErrorCode.PERMISSION_DENIED, (LogLevel)LogLevel.DEBUG, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler
    public ResponseEntity<ErrorModel> handleNotFoundException(NotFoundException e) {
        return PeopleExceptionHandler.handle((ErrorCode)ErrorCode.NOT_FOUND, (Map)ImmutableMap.of((Object)"requestedId", (Object)e.getRequestedId()), (LogLevel)LogLevel.DEBUG, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler
    public ResponseEntity<ErrorModel> handleUnsupportedFeatureException(UnsupportedFeatureException e) {
        return PeopleExceptionHandler.handle((ErrorCode)ErrorCode.BAD_REQUEST, (Map)ImmutableMap.of((Object)"message", (Object)e.getMessage()), (LogLevel)LogLevel.DEBUG, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler
    public ResponseEntity<ErrorModel> handleRuntimeException(Exception e) {
        return PeopleExceptionHandler.handle((ErrorCode)ErrorCode.UNKNOWN, (LogLevel)LogLevel.ERROR, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler
    public ResponseEntity<ErrorModel> handleIllegalArgumentException(IllegalArgumentException e) {
        return PeopleExceptionHandler.handle((ErrorCode)ErrorCode.BAD_REQUEST, (Map)ImmutableMap.of((Object)"message", (Object)e.getMessage()), (LogLevel)LogLevel.DEBUG, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler
    public ResponseEntity<ErrorModel> handleDataAccessException(NestedRuntimeException e) {
        return PeopleExceptionHandler.handle((ErrorCode)ErrorCode.UNKNOWN, (LogLevel)LogLevel.ERROR, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler
    public ResponseEntity<ErrorModel> handleHttpMessageConversionException(HttpMessageConversionException e) {
        return PeopleExceptionHandler.handle((ErrorCode)ErrorCode.BAD_REQUEST, (Map)ImmutableMap.of((Object)"message", (Object)"Failed to read input params"), (LogLevel)LogLevel.DEBUG, (Throwable)e);
    }

    @Nonnull
    @ExceptionHandler
    public ResponseEntity<ErrorModel> handleNotInSameTenantException(NotInSameTenantException e) {
        return PeopleExceptionHandler.handle((ErrorCode)ErrorCode.PERMISSION_DENIED, (LogLevel)LogLevel.DEBUG, (Throwable)e);
    }
}

