/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import de.justsoftware.people.authorization.AuthorizationContext;
import de.justsoftware.people.authorization.AuthorizationContextProvider;
import de.justsoftware.people.domain.model.TenantId;
import de.justsoftware.people.domain.model.profile.ProfileId;
import de.justsoftware.people.exceptions.UnauthorizedException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public class AuthorizationContextResolver
implements HandlerMethodArgumentResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizationContextResolver.class);
    private static final String DEFAULT_ERROR_MESSAGE = "An error occurred authorizing your request.";
    private static final ImmutableSet<Class<?>> SUPPORTED = ImmutableSet.of(AuthorizationContext.class);
    private final AuthorizationContextProvider _authorizationContextProvider;
    private final String _toroBaseUrl;
    private final ObjectMapper _objectMapper;
    private final RestTemplate _restTemplate;

    public AuthorizationContextResolver(AuthorizationContextProvider authorizationContextProvider, String toroBaseUrl, ObjectMapper objectMapper, RestTemplate restTemplate) {
        this._authorizationContextProvider = authorizationContextProvider;
        this._toroBaseUrl = toroBaseUrl;
        this._objectMapper = objectMapper;
        this._restTemplate = restTemplate;
    }

    public AuthorizationContextResolver(AuthorizationContextProvider authorizationContextProvider, String toroBaseUrl, ObjectMapper objectMapper) {
        this(authorizationContextProvider, toroBaseUrl, objectMapper, new RestTemplate());
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return SUPPORTED.contains((Object)parameter.getParameterType());
    }

    @Nonnull
    public AuthorizationContext resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws UnauthorizedException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new UnauthorizedException("You must be logged in to perform this request");
        }
        if (authentication instanceof JwtAuthenticationToken) {
            return this._authorizationContextProvider.forProfileAndTenant(AuthorizationContextResolver.getProfileId((JwtAuthenticationToken)((JwtAuthenticationToken)authentication)), AuthorizationContextResolver.getTenantId((JwtAuthenticationToken)((JwtAuthenticationToken)authentication)));
        }
        if (authentication instanceof BearerTokenAuthentication) {
            Map currentUserInfo = this.getCurrentUserInfo((BearerTokenAuthentication)authentication);
            return this._authorizationContextProvider.forProfileAndTenant(AuthorizationContextResolver.getProfileId((Map)currentUserInfo), AuthorizationContextResolver.getTenantId((Map)currentUserInfo));
        }
        LOGGER.warn("We received an unknown type of authentication: " + authentication.getClass());
        throw new UnauthorizedException("You must be logged in to perform this request");
    }

    @Nonnull
    private Map<String, String> getCurrentUserInfo(BearerTokenAuthentication authentication) throws UnauthorizedException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Bearer " + ((OAuth2AccessToken)authentication.getToken()).getTokenValue());
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this._restTemplate.exchange(this._toroBaseUrl + "/api/v1/person/current", HttpMethod.GET, request, String.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            LOGGER.warn("Failed to retrieve person info from toro internal API: ${response.statusCode}");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        try {
            return (Map)this._objectMapper.readValue((String)response.getBody(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Failed to parse person info from toro internal API");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
    }

    @Nonnull
    private static ProfileId getProfileId(JwtAuthenticationToken authentication) throws UnauthorizedException {
        String principal = authentication.getPrincipal();
        try {
            return ProfileId.parse((String)principal);
        }
        catch (Exception ex) {
            LOGGER.warn("We received an unparsable profile ID: " + principal);
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
    }

    @Nonnull
    private static TenantId getTenantId(JwtAuthenticationToken authentication) throws UnauthorizedException {
        Object tenantId = authentication.getCustomJwtClaims().get((Object)"tenantId");
        if (tenantId == null) {
            throw new UnauthorizedException("You must be logged in a valid tenant");
        }
        try {
            return TenantId.parse((String)tenantId.toString());
        }
        catch (Exception ex) {
            LOGGER.warn("We received an unparsable tenant ID: " + tenantId);
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
    }

    @Nonnull
    private static ProfileId getProfileId(Map<String, String> currentPersonInfo) throws UnauthorizedException {
        String profileIdString = currentPersonInfo.get("id");
        if (profileIdString == null) {
            LOGGER.warn("Failed to extract profile id from internal toro API response");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        try {
            return ProfileId.parse((String)profileIdString);
        }
        catch (Exception ex) {
            LOGGER.warn("Received an unparsable profile ID from toro: " + profileIdString);
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
    }

    @Nonnull
    private static TenantId getTenantId(Map<String, String> currentPersonInfo) throws UnauthorizedException {
        String tenantIdString = currentPersonInfo.get("tenantId");
        if (tenantIdString == null) {
            LOGGER.warn("Failed to extract tenant id from internal toro API response");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        try {
            return TenantId.parse((String)tenantIdString);
        }
        catch (Exception ex) {
            LOGGER.warn("Received an unparsable tenant ID from toro: " + tenantIdString);
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
    }
}

