/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.usergroup.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Sets;
import de.justsoftware.people.authorization.NotAllowed;
import de.justsoftware.people.business.search.SearchIndexQueueService;
import de.justsoftware.people.business.search.VisibilityService;
import de.justsoftware.people.business.usergroup.UserGroupImportService;
import de.justsoftware.people.business.usergroup.UserGroupPublisher;
import de.justsoftware.people.business.usergroup.UserGroupService;
import de.justsoftware.people.business.usergroup.model.UserGroupImportModel;
import de.justsoftware.people.domain.model.TenantId;
import de.justsoftware.people.domain.model.profile.ProfileId;
import de.justsoftware.people.domain.model.usergroup.UserGroupBO;
import de.justsoftware.people.domain.model.usergroup.UserGroupId;
import de.justsoftware.people.domain.model.usergroup.UserGroupRole;
import de.justsoftware.people.domain.model.usergroup.UserGroupSearchIndexModel;
import de.justsoftware.people.domain.search.SearchIndexService;
import de.justsoftware.people.domain.transaction.TransactionSupport;
import de.justsoftware.people.domain.usergroup.UserGroupRepository;
import de.justsoftware.people.exceptions.NotFoundException;
import de.justsoftware.permission.client.kafka.WaitForOffsets;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestFailedExeception;
import de.justsoftware.toolbox.ObjectUtil;
import de.justsoftware.toolbox.function.Consumers;
import de.justsoftware.toolbox.guava.collect.Maps2;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class UserGroupServiceImpl
implements UserGroupService,
UserGroupImportService {
    private static final Consumer<WaitForOffsets> NOOP_OFFSETS_CONSUMER = Consumers.noOp();
    private static final Logger LOGGER = LoggerFactory.getLogger(UserGroupServiceImpl.class);
    private static final String TENANT_USER_GROUP_NAME = " ";
    private final UserGroupRepository _userGroupRepository;
    private final UserGroupPublisher _userGroupPublisher;
    private final SearchIndexService _searchIndexService;
    private final SearchIndexQueueService _searchIndexQueueService;
    private final VisibilityService _visibilityService;
    private final TransactionSupport _transactionSupport;

    UserGroupServiceImpl(UserGroupRepository userGroupRepository, UserGroupPublisher userGroupPublisher, SearchIndexService searchIndexService, SearchIndexQueueService searchIndexQueueService, VisibilityService visibilityService, TransactionSupport transactionSupport) {
        this._userGroupRepository = userGroupRepository;
        this._userGroupPublisher = userGroupPublisher;
        this._searchIndexService = searchIndexService;
        this._searchIndexQueueService = searchIndexQueueService;
        this._visibilityService = visibilityService;
        this._transactionSupport = transactionSupport;
    }

    public Optional<UserGroupBO> findUserGroup(UserGroupId userGroupId) {
        return Optional.ofNullable(this._userGroupRepository.getUserGroup(userGroupId));
    }

    public UserGroupBO getUserGroup(UserGroupId userGroupId) {
        return (UserGroupBO)this.findUserGroup(userGroupId).orElseThrow(() -> new NotFoundException("Could not find user group " + userGroupId, userGroupId.toString()));
    }

    public UserGroupId createUserGroup(String name, ProfileId creator, TenantId tenantId) {
        UserGroupId userGroupId = this._userGroupRepository.createUserGroup(name, creator, tenantId);
        UserGroupBO userGroup = (UserGroupBO)ObjectUtil.checkNotNull((Object)this._userGroupRepository.getUserGroup(userGroupId));
        this.publishUserGroup(userGroupId, this.getDefaultPermissions(userGroup));
        return userGroupId;
    }

    public UserGroupId createOrGetAllTenantUsersGroup(TenantId tenantId) {
        UserGroupId allTenantUsersGroupId = this._userGroupRepository.getAllTenantUsersGroupId(tenantId);
        if (allTenantUsersGroupId != null) {
            return allTenantUsersGroupId;
        }
        UserGroupId userGroupId = this._userGroupRepository.createTenantUserGroup(TENANT_USER_GROUP_NAME, tenantId);
        if (userGroupId == null) {
            throw new IllegalStateException("Failed to create or determine tenant user group.");
        }
        this.publishUserGroup(userGroupId, ImmutableMap.of((Object)userGroupId.asPermissionRole(), (Object)UserGroupRole.READER));
        return userGroupId;
    }

    public UserGroupId getAllTenantUsersGroup(TenantId tenantId) {
        UserGroupId allTenantUsersGroupId = this._userGroupRepository.getAllTenantUsersGroupId(tenantId);
        if (allTenantUsersGroupId == null) {
            throw new IllegalStateException("No all tenant users group available for tenant " + tenantId);
        }
        return allTenantUsersGroupId;
    }

    public void deleteAllTenantUsersGroup(TenantId tenantId) {
        UserGroupId tenantUserGroup = this._userGroupRepository.getAllTenantUsersGroupId(tenantId);
        if (tenantUserGroup == null) {
            LOGGER.debug("There is no user group for Tenant {}.", (Object)tenantId);
            return;
        }
        this.deleteUserGroup(tenantUserGroup);
    }

    public void migrateAllUsersRole() {
        ImmutableSet tenantIdsFromRole = this._userGroupRepository.getTenantIdsFromRole();
        tenantIdsFromRole.forEach(tenantId -> {
            UserGroupId allTenantUserGroup = this.createOrGetAllTenantUsersGroup(tenantId);
            this._userGroupRepository.migrateTenantRole(tenantId.asPermissionRole(), allTenantUserGroup.asPermissionRole());
        });
        this._userGroupPublisher.publishAllUserGroups().waitForOffsets();
        this.reindexAllGroups();
    }

    public void importUserGroup(UserGroupImportModel userGroupImportModel) {
        UserGroupId userGroupId = userGroupImportModel.getUserGroupId();
        ImmutableMap defaultPermissions = ImmutableMap.of((Object)Role.userGroupRole((UUID)((UUID)userGroupId.getId())), (Object)UserGroupRole.READER);
        UserGroupBO userGroup = this._userGroupRepository.getUserGroup(userGroupId);
        if (userGroup == null) {
            this._userGroupRepository.createImportedUserGroup(userGroupId, userGroupImportModel.getName(), userGroupImportModel.getTenantId());
            if (!userGroupImportModel.getName().equals("notYetImported")) {
                this.publishUserGroup(userGroupId, defaultPermissions);
            }
        } else if (userGroup.getName().equals("notYetImported")) {
            this._userGroupRepository.updateUserGroup(userGroupImportModel.getUserGroupId(), userGroupImportModel.getName(), userGroupImportModel.getTenantId());
            this.publishUserGroup(userGroupId, defaultPermissions);
        } else {
            this.renameUserGroup(userGroupId, userGroupImportModel.getName());
        }
    }

    private void publishUserGroup(UserGroupId userGroupId, ImmutableMap<Role, UserGroupRole> permissions) {
        UserGroupBO userGroup = (UserGroupBO)ObjectUtil.checkNotNull((Object)this._userGroupRepository.getUserGroup(userGroupId));
        Stream.Builder offsetConsumer = Stream.builder();
        this._userGroupPublisher.publishUserGroup(userGroup, offsetConsumer);
        UserGroupId groupId = userGroup.getId();
        ImmutableMap oldUserGroupRoles = this._userGroupRepository.getUserGroupRoles(ImmutableSet.of((Object)groupId)).row((Object)groupId);
        this._userGroupRepository.setUserGroupRoles(groupId, permissions);
        ImmutableMap userGroupRolesToDelete = ImmutableMap.copyOf((Map)Maps2.filterEntries((Map)oldUserGroupRoles, (role, userGroupRole) -> !permissions.containsKey(role) || !((UserGroupRole)permissions.get(role)).equals(userGroupRole)));
        this._userGroupPublisher.publishUserGroupRoles(groupId, permissions, (Map)userGroupRolesToDelete, offsetConsumer);
        new WaitForOffsets(offsetConsumer.build()).waitForOffsets();
        try {
            ImmutableSet visibilities = this._visibilityService.visibilities(userGroupId);
            this.addUserGroupToSearchIndex(userGroup, visibilities);
        }
        catch (PermissionRequestFailedExeception e) {
            LOGGER.warn("Failed to retrieve group visibilities to add group to search index, will be queued for later indexing...", (Throwable)e);
            this.addUserGroupToSearchIndex(userGroup, ImmutableSet.of());
            this._searchIndexQueueService.queueToIndexVisibilities(userGroupId);
        }
    }

    private void addUserGroupToSearchIndex(UserGroupBO userGroup, ImmutableSet<String> visibilities) {
        this._searchIndexService.createOrUpdateUserGroups((Map)ImmutableMap.of((Object)userGroup.getId(), (Object)new UserGroupSearchIndexModel(userGroup.getId(), userGroup.getName(), userGroup.getTenantId(), userGroup.isImported(), userGroup.isAllTenantUsers(), visibilities)));
        this._searchIndexService.commit(false);
    }

    @Nonnull
    private ImmutableMap<Role, UserGroupRole> getDefaultPermissions(UserGroupBO userGroup) {
        ImmutableMap.Builder userGroupRolesBuilder = ImmutableMap.builder();
        UserGroupId allTenantUsersGroupId = (UserGroupId)ObjectUtil.checkNotNull((Object)this._userGroupRepository.getAllTenantUsersGroupId(userGroup.getTenantId()));
        userGroupRolesBuilder.put((Object)Role.userGroupRole((UUID)((UUID)allTenantUsersGroupId.getId())), (Object)UserGroupRole.READER);
        ProfileId creator = userGroup.getCreator();
        if (creator != null) {
            userGroupRolesBuilder.put((Object)Role.profileRole((long)((Long)creator.getId())), (Object)UserGroupRole.MANAGER);
        }
        return userGroupRolesBuilder.build();
    }

    public void updateMembers(UserGroupId userGroupId, Set<ProfileId> membersToAdd, Set<ProfileId> membersToDelete) {
        Set currentGroupMembers = this._userGroupRepository.getMembersOfGroup(userGroupId);
        Sets.SetView newMembers = Sets.difference(membersToAdd, (Set)currentGroupMembers);
        Set filteredMembersToDelete = Sets.filter(membersToDelete, currentGroupMembers::contains);
        this._userGroupRepository.addMembersToGroup(userGroupId, (Set)newMembers);
        this._userGroupRepository.removeMembersFromGroup(userGroupId, filteredMembersToDelete);
        boolean entriesProcessed = this._userGroupPublisher.publishUserGroupMemberships(userGroupId, ImmutableSet.copyOf((Collection)newMembers), ImmutableSet.copyOf((Collection)filteredMembersToDelete));
        if (!entriesProcessed) {
            LOGGER.warn("Permission has not processed all user group changes. Aborting SOLR reindex. Potentially inconsistent state. In emergencies you can trigger a SOLR index for profiles manually.");
            return;
        }
        Sets.SetView updatedUsers = Sets.union((Set)newMembers, (Set)filteredMembersToDelete);
        ImmutableSetMultimap userGroupsForProfile = this.getUserGroupsForProfile((Set)updatedUsers);
        this._searchIndexService.updateGroupsForProfiles((Map)updatedUsers.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), arg_0 -> ((ImmutableSetMultimap)userGroupsForProfile).get(arg_0))));
        this._searchIndexQueueService.queueToIndexVisibilities((Set)updatedUsers.immutableCopy());
        this._searchIndexService.commit(true);
    }

    public void updateAllTenantUsersGroupMembers(TenantId tenantId, Set<ProfileId> membersToAdd, Set<ProfileId> membersToDelete) {
        UserGroupId allTenantUsersGroup = this.createOrGetAllTenantUsersGroup(tenantId);
        this.updateMembers(allTenantUsersGroup, membersToAdd, membersToDelete);
    }

    public Set<ProfileId> getMembersOfGroup(UserGroupId userGroupId) {
        return this._userGroupRepository.getMembersOfGroup(userGroupId);
    }

    public ImmutableSetMultimap<ProfileId, UserGroupId> getUserGroupsForProfile(Set<ProfileId> profileIds) {
        return this._userGroupRepository.getUserGroupsForProfiles(profileIds);
    }

    public void reindexAllGroups() {
        this._searchIndexService.deleteAllUserGroups();
        ImmutableMap.Builder userGroups = ImmutableMap.builder();
        this._userGroupRepository.forAllUserGroups(userGroupBO -> {
            ImmutableSet visibilities = this._visibilityService.visibilities(userGroupBO.getId());
            userGroups.put((Object)userGroupBO.getId(), (Object)new UserGroupSearchIndexModel(userGroupBO.getId(), userGroupBO.getName(), userGroupBO.getTenantId(), userGroupBO.isImported(), userGroupBO.isAllTenantUsers(), visibilities));
        });
        this._searchIndexService.createOrUpdateUserGroups((Map)userGroups.build());
        this._searchIndexService.commit(false);
    }

    public void deleteUserGroup(UserGroupId groupId) {
        Set membersOfGroup = (Set)this._transactionSupport.doInTransaction(() -> {
            Set members = this._userGroupRepository.getMembersOfGroup(groupId);
            this._userGroupRepository.removeMembersFromGroup(groupId, members);
            this.deleteUserGroupPermissionRole(Role.userGroupRole((UUID)((UUID)groupId.getId())));
            this._userGroupRepository.deleteUserGroup(groupId);
            return members;
        });
        if (membersOfGroup == null) {
            throw new IllegalStateException(String.format("Unexpected null membersOfGroup for userGroupId {}", groupId));
        }
        this._userGroupPublisher.publishUserGroupDeleted(groupId, ImmutableSet.copyOf((Collection)membersOfGroup));
        ImmutableSetMultimap userGroupsForProfile = this.getUserGroupsForProfile(membersOfGroup);
        this._searchIndexService.updateGroupsForProfiles((Map)membersOfGroup.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), arg_0 -> ((ImmutableSetMultimap)userGroupsForProfile).get(arg_0))));
        this._searchIndexService.deleteUserGroups((Set)ImmutableSet.of((Object)groupId));
        this._searchIndexQueueService.queueToIndexVisibilities(membersOfGroup);
        this._searchIndexService.commit(true);
    }

    public void deleteUserGroupPermissionRole(Role role) {
        ImmutableSet userGroupIds = this._userGroupRepository.getUserGroupIdsWithPermissionRole(role);
        if (userGroupIds.isEmpty()) {
            return;
        }
        ImmutableTable userGroupRoles = this.getUserGroupRoles(userGroupIds);
        for (UserGroupId userGroupId : userGroupIds) {
            ImmutableMap newRoles = (ImmutableMap)userGroupRoles.row((Object)userGroupId).entrySet().stream().filter(entry -> !role.equals(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            this.setUserGroupRoles(userGroupId, (Map)newRoles);
        }
    }

    public void renameUserGroup(UserGroupId groupId, String name) {
        UserGroupBO currentGroup = this.getUserGroup(groupId);
        if (currentGroup.isAllTenantUsers()) {
            throw new NotAllowed(String.format("You must not rename the group with id '%s'. It is an allTenantUsers group.", groupId));
        }
        this._userGroupRepository.renameUserGroup(groupId, name);
        UserGroupBO userGroup = (UserGroupBO)ObjectUtil.checkNotNull((Object)this._userGroupRepository.getUserGroup(groupId));
        this._userGroupPublisher.publishUserGroup(userGroup, NOOP_OFFSETS_CONSUMER);
        this._searchIndexService.updateGroupName(groupId, name);
        this._searchIndexService.commit(false);
    }

    public void removeProfileFromUserGroupOfTenants(ProfileId id, Set<TenantId> tenantIds) {
        ImmutableSet userGroupIdsToRemove = this._userGroupRepository.checkUserGroupsForProfile(id, tenantIds);
        userGroupIdsToRemove.forEach(userGroupId -> this.updateMembers(userGroupId, (Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)id)));
    }

    public ImmutableTable<UserGroupId, Role, UserGroupRole> getUserGroupRoles(ImmutableSet<UserGroupId> userGroupIds) {
        return this._userGroupRepository.getUserGroupRoles(userGroupIds);
    }

    public void setUserGroupRoles(UserGroupId groupId, Map<Role, UserGroupRole> userGroupRoles) {
        Stream.Builder offsetConsumer = Stream.builder();
        ImmutableMap oldUserGroupRoles = this._userGroupRepository.getUserGroupRoles(ImmutableSet.of((Object)groupId)).row((Object)groupId);
        this._userGroupRepository.setUserGroupRoles(groupId, userGroupRoles);
        ImmutableMap userGroupRolesToDelete = ImmutableMap.copyOf((Map)Maps2.filterEntries((Map)oldUserGroupRoles, (role, userGroupRole) -> !userGroupRoles.containsKey(role) || !((UserGroupRole)userGroupRoles.get(role)).equals(userGroupRole)));
        this._userGroupPublisher.publishUserGroupRoles(groupId, userGroupRoles, (Map)userGroupRolesToDelete, offsetConsumer);
        new WaitForOffsets(offsetConsumer.build()).waitForOffsets();
        this._searchIndexQueueService.queueToIndexVisibilities(groupId);
        ImmutableSet membersOfGroup = ImmutableSet.copyOf((Collection)this._userGroupRepository.getMembersOfGroup(groupId));
        this._searchIndexQueueService.queueToIndexVisibilities((Set)membersOfGroup);
        this._userGroupPublisher.requestGlobalSearchProfileVisibilityUpdate(membersOfGroup);
    }

    public ImmutableMap<UserGroupId, UserGroupBO> getUserGroups(Set<UserGroupId> userGroupIds) {
        return this._userGroupRepository.getUserGroups(userGroupIds);
    }

    public boolean isAvailable() {
        return this._searchIndexService.isAvailable();
    }
}

