/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.usergroup.impl;

import de.justsoftware.people.business.AbstractProcessorServiceImpl;
import de.justsoftware.people.business.usergroup.UserGroupImportService;
import de.justsoftware.people.business.usergroup.UserGroupService;
import de.justsoftware.people.business.usergroup.impl.UserGroupImportKafkaStreamsSupplier;
import de.justsoftware.people.business.usergroup.impl.UserGroupMemberProcessor;
import de.justsoftware.people.business.usergroup.impl.UserGroupProcessor;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
@Profile(value={"!test"})
public class UserGroupProcessorServiceImpl
extends AbstractProcessorServiceImpl {
    private final UserGroupService _userGroupService;

    @Autowired
    UserGroupProcessorServiceImpl(@Value(value="${kafka.bootstrapServers}") String kafkaBootstrapServers, @Value(value="${kafka.streams.stateDir}") String kafkaStreamsStateDir, UserGroupService userGroupService, UserGroupImportService userGroupImportService, @Value(value="${just.people.userGroupMemberProcessor.maxBatchSize}") int maxBatchSze, @Value(value="${just.people.userGroupMemberProcessor.commitIntervalMs}") int commitIntervalMs) {
        super((Supplier)new UserGroupImportKafkaStreamsSupplier(kafkaBootstrapServers, kafkaStreamsStateDir, new UserGroupProcessor(userGroupService, userGroupImportService), new UserGroupMemberProcessor(userGroupImportService, userGroupService, maxBatchSze, commitIntervalMs)));
        this._userGroupService = userGroupService;
    }

    public boolean preConditionsMet() {
        return this._userGroupService.isAvailable();
    }
}

