/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.usergroup;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import de.justsoftware.people.domain.model.TenantId;
import de.justsoftware.people.domain.model.profile.ProfileId;
import de.justsoftware.people.domain.model.usergroup.UserGroupBO;
import de.justsoftware.people.domain.model.usergroup.UserGroupId;
import de.justsoftware.people.domain.model.usergroup.UserGroupRole;
import de.justsoftware.permission.client.model.Role;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface UserGroupService {
    @Nonnull
    public Optional<UserGroupBO> findUserGroup(UserGroupId var1);

    @Nonnull
    public UserGroupBO getUserGroup(UserGroupId var1);

    @Nonnull
    public UserGroupId createUserGroup(String var1, ProfileId var2, TenantId var3);

    public void updateMembers(UserGroupId var1, Set<ProfileId> var2, Set<ProfileId> var3);

    public void updateAllTenantUsersGroupMembers(TenantId var1, Set<ProfileId> var2, Set<ProfileId> var3);

    @Nonnull
    public Set<ProfileId> getMembersOfGroup(UserGroupId var1);

    @Nonnull
    public ImmutableSetMultimap<ProfileId, UserGroupId> getUserGroupsForProfile(Set<ProfileId> var1);

    public void reindexAllGroups();

    public void deleteUserGroup(UserGroupId var1);

    public void renameUserGroup(UserGroupId var1, String var2);

    public void removeProfileFromUserGroupOfTenants(ProfileId var1, Set<TenantId> var2);

    public void deleteUserGroupPermissionRole(Role var1);

    @Nonnull
    public ImmutableTable<UserGroupId, Role, UserGroupRole> getUserGroupRoles(ImmutableSet<UserGroupId> var1);

    public void setUserGroupRoles(UserGroupId var1, Map<Role, UserGroupRole> var2);

    @Nonnull
    public ImmutableMap<UserGroupId, UserGroupBO> getUserGroups(Set<UserGroupId> var1);

    public boolean isAvailable();

    @Nonnull
    public UserGroupId createOrGetAllTenantUsersGroup(TenantId var1);

    @Nonnull
    public UserGroupId getAllTenantUsersGroup(TenantId var1);

    public void deleteAllTenantUsersGroup(TenantId var1);

    public void migrateAllUsersRole();
}

