/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.search.model;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import de.justsoftware.people.business.search.model.SearchableField;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SearchFilter {
    private final SearchableField _searchableField;
    private final ImmutableList<String> _values;

    public SearchFilter(SearchableField searchableField, ImmutableList<String> values) {
        this._searchableField = searchableField;
        this._values = (ImmutableList)values.stream().filter(value -> !Strings.isNullOrEmpty((String)value)).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((!this._values.isEmpty() ? 1 : 0) != 0, (Object)"Search filter must contain at least one non-empty filter value");
    }

    @Nonnull
    public SearchableField getSearchableField() {
        return this._searchableField;
    }

    @Nonnull
    public ImmutableList<String> getValues() {
        return this._values;
    }
}

