/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.search.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.people.business.search.VisibilityService;
import de.justsoftware.people.domain.model.AbstractId;
import de.justsoftware.people.domain.model.profile.ProfileId;
import de.justsoftware.people.domain.model.usergroup.UserGroupId;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class VisibilityServiceImpl
implements VisibilityService {
    private final PermissionRequestConnector _permissionRequestConnector;

    @Autowired
    public VisibilityServiceImpl(PermissionRequestConnector permissionRequestConnector) {
        this._permissionRequestConnector = permissionRequestConnector;
    }

    public ImmutableSet<String> visibilities(UserGroupId userGroupId) {
        ImmutableSet visibilities = this._permissionRequestConnector.visibility(userGroupId.asString());
        return this.getVisibilitiesAsStrings(visibilities);
    }

    public Map<ProfileId, Collection<String>> visibilitiesForProfiles(ImmutableSet<ProfileId> profileIds) {
        return this.visibilities(profileIds);
    }

    public Map<UserGroupId, Collection<String>> visibilitiesForGroups(ImmutableSet<UserGroupId> groupIds) {
        return this.visibilities(groupIds);
    }

    @Nonnull
    private <ID extends AbstractId<?>> Map<ID, Collection<String>> visibilities(ImmutableSet<ID> profileOrGroupIds) {
        ImmutableSet idsAsString = (ImmutableSet)profileOrGroupIds.stream().map(AbstractId::asString).collect(ImmutableSet.toImmutableSet());
        ImmutableSetMultimap visibility = this._permissionRequestConnector.visibility((Iterable)idsAsString);
        Map<AbstractId, Collection> visibilitesPerId = profileOrGroupIds.stream().collect(Collectors.toMap(id -> id, id -> this.getVisibilitiesAsStrings(visibility.get((Object)id.asString()))));
        return visibilitesPerId;
    }

    @Nonnull
    private ImmutableSet<String> getVisibilitiesAsStrings(ImmutableSet<Role> visibilities) {
        return ImmutableSet.copyOf((Collection)visibilities.stream().map(Role::asString).collect(Collectors.toSet()));
    }
}

