/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.profile.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.people.business.profile.model.ProfileAttributeConfig;
import de.justsoftware.people.business.search.model.SearchableField;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProfileAttributeConfig {
    private final AttributeType _type;
    private final String _name;
    private final boolean _visibleOnBadge;
    private final boolean _searchable;
    private final boolean _facetable;
    private final boolean _clickable;
    private final boolean _phoneNumber;
    private final Optional<SearchableField> _searchFieldId;
    private final ImmutableSetMultimap<String, String> _translatedValues;

    public ProfileAttributeConfig(AttributeType type, String name, boolean visibleOnBadge, boolean searchable, boolean facetable, boolean clickable, boolean phoneNumber, @Nullable SearchableField searchFieldId, ImmutableSetMultimap<String, String> translatedValues) {
        this._type = type;
        this._name = name;
        this._visibleOnBadge = visibleOnBadge;
        this._searchable = searchable;
        this._facetable = facetable;
        this._clickable = clickable;
        this._phoneNumber = phoneNumber;
        this._searchFieldId = Optional.ofNullable(searchFieldId);
        this._translatedValues = translatedValues;
    }

    @Nonnull
    public static ProfileAttributeConfig createForStaticAttribute(String name, boolean visibleOnBadge, @Nullable SearchableField searchFieldId) {
        return new ProfileAttributeConfig(AttributeType.TEXT, name, visibleOnBadge, true, true, false, false, searchFieldId, ImmutableSetMultimap.of());
    }

    @Nonnull
    public AttributeType getType() {
        return this._type;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    public boolean isVisibleOnBadge() {
        return this._visibleOnBadge;
    }

    public boolean isSearchable() {
        return this._searchable;
    }

    public boolean isPhoneNumber() {
        return this._phoneNumber;
    }

    public boolean isFacetable() {
        return this._facetable;
    }

    public boolean isClickable() {
        return this._clickable;
    }

    @Nonnull
    public Optional<SearchableField> getSearchFieldId() {
        return this._searchFieldId;
    }

    public boolean isSearchInFacetsSupported() {
        return this.isSearchable() && !this.isTranslated();
    }

    public boolean isTranslated() {
        return this._type == AttributeType.SELECT || this._type == AttributeType.TREE_SELECT;
    }

    @Nonnull
    public ImmutableSetMultimap<String, String> getTranslatedValues() {
        return this._translatedValues;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this._type).add("name", (Object)this._name).add("visibleOnBadge", this._visibleOnBadge).add("searchable", this._searchable).add("facetable", this._facetable).add("clickable", this._clickable).add("phoneNumber", this._phoneNumber).add("searchFieldId", (Object)this._searchFieldId).add("translatedValues", (Object)this._translatedValues).toString();
    }
}

