/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.profile.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.justsoftware.people.application.utils.JustCsvUtils;
import de.justsoftware.people.business.externallink.model.ValidExternalLink;
import de.justsoftware.people.business.profile.model.ProfileAttributeConfig;
import de.justsoftware.people.business.search.model.StaticSearchableField;
import de.justsoftware.people.domain.model.profile.ProfileId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Profile {
    private final ProfileId _id;
    private final String _firstName;
    private final String _lastName;
    private final String _title;
    private final String _additionalTitle;
    private final String _profileHash;
    private final String _imageUrl;
    private final boolean _blocked;
    private final boolean _active;
    private final Map<String, Collection<String>> _fields;
    private final ImmutableList<ValidExternalLink> _externalLinks;

    @JsonCreator
    public Profile(@JsonProperty(value="id") ProfileId id, @JsonProperty(value="firstName") String firstName, @JsonProperty(value="lastName") String lastName, @JsonProperty(value="title") String title, @JsonProperty(value="additionalTitle") String additionalTitle, @JsonProperty(value="profileHash") String profileHash, @JsonProperty(value="imageUrl") String imageUrl, @JsonProperty(value="blocked") boolean blocked, @JsonProperty(value="active") boolean active, @JsonProperty(value="fields") Map<String, Collection<String>> fields, @JsonProperty(value="externalLinks") ImmutableList<ValidExternalLink> externalLinks) {
        this._id = id;
        this._firstName = firstName;
        this._lastName = lastName;
        this._profileHash = profileHash;
        this._title = title;
        this._additionalTitle = additionalTitle;
        this._imageUrl = imageUrl;
        this._blocked = blocked;
        this._active = active;
        this._fields = fields;
        this._externalLinks = externalLinks;
    }

    @Nonnull
    public ProfileId getId() {
        return this._id;
    }

    @Nonnull
    public String getFirstName() {
        return this._firstName;
    }

    @Nonnull
    public String getLastName() {
        return this._lastName;
    }

    @Nonnull
    public String getTitle() {
        return this._title;
    }

    @Nonnull
    public String getAdditionalTitle() {
        return this._additionalTitle;
    }

    @Nonnull
    public String getProfileHash() {
        return this._profileHash;
    }

    @Nonnull
    public String getImageUrl() {
        return this._imageUrl;
    }

    public boolean isBlocked() {
        return this._blocked;
    }

    public boolean isActive() {
        return this._active;
    }

    @Nonnull
    public Map<String, Collection<String>> getFields() {
        return this._fields;
    }

    @Nonnull
    public ImmutableList<ValidExternalLink> getExternalLinks() {
        return this._externalLinks;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("firstName", (Object)this._firstName).add("lastName", (Object)this._lastName).add("title", (Object)this._title).add("additionalTitle", (Object)this._additionalTitle).add("profileHash", (Object)this._profileHash).add("imageUrl", (Object)this._imageUrl).add("blocked", this._blocked).add("active", this._active).add("externalLinks", (Object)this._externalLinks).toString();
    }

    @Nonnull
    public String toCsvString(ImmutableList<ProfileAttributeConfig> attributeConfigs) {
        ArrayList result = new ArrayList();
        attributeConfigs.stream().map(ProfileAttributeConfig::getName).forEach(attributeName -> {
            if (attributeName.equals(StaticSearchableField.FIRSTNAME.getAttributeName())) {
                result.add(JustCsvUtils.csvEscape((String)this._firstName));
                return;
            }
            if (attributeName.equals(StaticSearchableField.LASTNAME.getAttributeName())) {
                result.add(JustCsvUtils.csvEscape((String)this._lastName));
                return;
            }
            if (attributeName.equals(StaticSearchableField.TITLE.getAttributeName())) {
                result.add(JustCsvUtils.csvEscape((String)this._title));
                return;
            }
            if (attributeName.equals(StaticSearchableField.ADDITIONAL_TITLE.getAttributeName())) {
                result.add(JustCsvUtils.csvEscape((String)this._additionalTitle));
                return;
            }
            Collection field = (Collection)this._fields.get(attributeName);
            String fieldValue = field != null && field.size() > 0 ? String.join((CharSequence)", ", field) : "";
            result.add(JustCsvUtils.csvEscape((String)fieldValue));
        });
        return String.join((CharSequence)";", result);
    }
}

