/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.profile.impl;

import com.google.common.collect.ImmutableList;
import de.justsoftware.people.business.externallink.ExternalLinkService;
import de.justsoftware.people.business.externallink.model.ExternalLinkConfig;
import de.justsoftware.people.business.externallink.model.ValidExternalLink;
import de.justsoftware.people.business.profile.ProfileService;
import de.justsoftware.people.business.profile.model.Profile;
import de.justsoftware.people.domain.model.profile.ProfileSearchReadModel;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ProfileServiceImpl
implements ProfileService {
    private final ExternalLinkService _externalLinkService;

    public ProfileServiceImpl(ExternalLinkService externalLinkService) {
        this._externalLinkService = externalLinkService;
    }

    public Profile getProfile(ProfileSearchReadModel profileSearchReadModel) {
        return this.createProfile(profileSearchReadModel, ImmutableList.of());
    }

    public Profile getProfile(ProfileSearchReadModel profileSearchReadModel, ImmutableList<ExternalLinkConfig> configuredLinks) {
        Map fields = profileSearchReadModel.getFields();
        if (fields.isEmpty()) {
            return this.createProfile(profileSearchReadModel, ImmutableList.of());
        }
        ImmutableList links = this._externalLinkService.getLinkFromConfigAndData(configuredLinks, fields);
        return this.createProfile(profileSearchReadModel, links);
    }

    @Nonnull
    private Profile createProfile(ProfileSearchReadModel readModel, ImmutableList<ValidExternalLink> links) {
        return new Profile(readModel.getId(), readModel.getFirstName(), readModel.getLastName(), readModel.getTitle(), readModel.getAdditionalTitle(), readModel.getProfileHash(), readModel.getImageUrl(), readModel.isBlocked(), readModel.isActive(), readModel.getFields(), links);
    }
}

