/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.profile.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.people.business.profile.model.ProfileKafkaModel;
import de.justsoftware.people.business.search.VisibilityService;
import de.justsoftware.people.business.usergroup.UserGroupService;
import de.justsoftware.people.domain.model.profile.DynamicProfileFields;
import de.justsoftware.people.domain.model.profile.ProfileId;
import de.justsoftware.people.domain.model.profile.ProfileSearchIndexModel;
import de.justsoftware.people.domain.model.profile.StaticProfileFields;
import de.justsoftware.people.domain.search.SearchIndexService;
import de.justsoftware.permission.client.model.Role;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.PunctuationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
class ProfileProcessor
extends AbstractProcessor<ProfileId, ProfileKafkaModel> {
    private final Logger _log = LoggerFactory.getLogger(this.getClass());
    private final SearchIndexService _searchIndexService;
    private final UserGroupService _userGroupService;
    private final VisibilityService _visibilityService;
    private final Map<ProfileId, ProfileKafkaModel> _toStore = new HashMap();
    private final Set<ProfileId> _toDelete = new HashSet();
    private final int _maxBatchSize;
    private final long _commitIntervalMs;

    ProfileProcessor(SearchIndexService searchIndexService, UserGroupService userGroupService, VisibilityService visibilityService, int maxBatchSize, int commitIntervalMs) {
        this._searchIndexService = searchIndexService;
        this._userGroupService = userGroupService;
        this._visibilityService = visibilityService;
        this._maxBatchSize = maxBatchSize;
        this._commitIntervalMs = commitIntervalMs;
    }

    public void init(ProcessorContext context) {
        super.init(context);
        context.schedule(Duration.ofMillis(this._commitIntervalMs), PunctuationType.WALL_CLOCK_TIME, timestamp -> this.flush());
    }

    private void flush() {
        if (this._toStore.isEmpty() && this._toDelete.isEmpty()) {
            return;
        }
        this._log.info("Flushing persons to Solr: add {},  deleteProfiles {}", (Object)this._toStore.size(), (Object)this._toDelete.size());
        this._toStore.forEach((profileId, kafkaModel) -> this._userGroupService.removeProfileFromUserGroupOfTenants(profileId, (Set)kafkaModel.getTenantIds()));
        this.removeDeletedProfilesFromUserGroups();
        ImmutableSetMultimap userGroupsForProfiles = this._userGroupService.getUserGroupsForProfile(this._toStore.keySet());
        ImmutableSetMultimap visibilities = this.loadVisibilities();
        ImmutableList storeToSolr = (ImmutableList)this._toStore.values().stream().map(profile -> new ProfileSearchIndexModel(new StaticProfileFields(Objects.requireNonNull(profile).getId(), profile.getFirstName(), profile.getLastName(), profile.getTitle(), profile.getAdditionalTitle(), profile.getProfileHash(), profile.getImageUrl(), profile.isBlocked(), profile.isActive()), new DynamicProfileFields(profile.getFields()), userGroupsForProfiles.get((Object)profile.getId()), profile.getTenantIds(), visibilities.get((Object)profile.getId()))).collect(ImmutableList.toImmutableList());
        this._searchIndexService.createOrUpdateProfiles((ImmutableCollection)storeToSolr);
        this._searchIndexService.deleteProfiles(this._toDelete);
        this._searchIndexService.commit(false);
        this.updateAllTenantUsersGroups();
        this.context().commit();
        this._toStore.clear();
        this._toDelete.clear();
        this._log.info("Flush finished");
    }

    @Nonnull
    private ImmutableSetMultimap<ProfileId, String> loadVisibilities() {
        Map visibilities = this._visibilityService.visibilitiesForProfiles(ImmutableSet.copyOf(this._toStore.keySet()));
        ImmutableSetMultimap.Builder visibilitiesMultimap = ImmutableSetMultimap.builder();
        visibilities.forEach((profileId, profileVisibilities) -> visibilitiesMultimap.putAll(profileId, (Iterable)profileVisibilities));
        return visibilitiesMultimap.build();
    }

    private void updateAllTenantUsersGroups() {
        ImmutableSetMultimap profilesToAdd = ((ImmutableSetMultimap)this._toStore.values().stream().collect(ImmutableSetMultimap.flatteningToImmutableSetMultimap(ProfileKafkaModel::getId, pkm -> pkm.getTenantIds().stream()))).inverse();
        profilesToAdd.keySet().forEach(tenantId -> this._userGroupService.updateAllTenantUsersGroupMembers(tenantId, (Set)profilesToAdd.get(tenantId), (Set)ImmutableSet.of()));
    }

    private void removeDeletedProfilesFromUserGroups() {
        ImmutableSetMultimap profilesToDelete = this._userGroupService.getUserGroupsForProfile(this._toDelete).inverse();
        profilesToDelete.keys().forEach(groupId -> this._userGroupService.updateMembers(groupId, (Set)ImmutableSet.of(), (Set)profilesToDelete.get(groupId)));
        this._toDelete.forEach(profileId -> this._userGroupService.deleteUserGroupPermissionRole(Role.profileRole((long)((Long)profileId.getId()))));
    }

    public void close() {
        try {
            this.flush();
            super.close();
        }
        catch (RuntimeException e) {
            this._log.error("Error when closing the kafka stream context", (Throwable)e);
        }
    }

    public void process(ProfileId profileId, ProfileKafkaModel profile) {
        if (profile.isDeleted()) {
            this._toDelete.add(profileId);
            this._toStore.remove(profileId);
        } else {
            this._toStore.put(profileId, profile);
            this._toDelete.remove(profileId);
        }
        if (this._toStore.size() + this._toDelete.size() >= this._maxBatchSize) {
            this.flush();
        }
    }
}

