/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.profile;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.people.business.search.model.StaticSearchableField;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@ParametersAreNonnullByDefault
@Service
public class ProfileAttributeTranslationService {
    private static final String DEFAULT_LOCALE = "en";
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileAttributeTranslationService.class);
    private static final ImmutableMap<String, String> CUSTOM_TRANSLATIONS_DE = ImmutableMap.of((Object)StaticSearchableField.FIRSTNAME.getAttributeName(), (Object)"Vorname", (Object)StaticSearchableField.LASTNAME.getAttributeName(), (Object)"Nachname", (Object)StaticSearchableField.TITLE.getAttributeName(), (Object)"Titel", (Object)StaticSearchableField.ADDITIONAL_TITLE.getAttributeName(), (Object)"Nachtitel");
    private static final ImmutableMap<String, String> CUSTOM_TRANSLATIONS_EN = ImmutableMap.of((Object)StaticSearchableField.FIRSTNAME.getAttributeName(), (Object)"Firstname", (Object)StaticSearchableField.LASTNAME.getAttributeName(), (Object)"Lastname", (Object)StaticSearchableField.TITLE.getAttributeName(), (Object)"Title", (Object)StaticSearchableField.ADDITIONAL_TITLE.getAttributeName(), (Object)"Additional title");
    private static final ImmutableMap<String, ImmutableMap<String, String>> CUSTOM_TRANSLATIONS = new ImmutableMap.Builder().put((Object)"de", (Object)CUSTOM_TRANSLATIONS_DE).put((Object)"en", (Object)CUSTOM_TRANSLATIONS_EN).build();
    private final RestOperations _restTemplate;
    private final String _translationUrl;
    private final ObjectMapper _objectMapper;

    @Autowired
    public ProfileAttributeTranslationService(@Value(value="${just.people.toro.profile.attributes.translation.url}") String translationUrl) {
        this((RestOperations)new RestTemplate(), translationUrl, new ObjectMapper());
    }

    @VisibleForTesting
    ProfileAttributeTranslationService(RestOperations restTemplate, String translationUrl, ObjectMapper objectMapper) {
        this._restTemplate = restTemplate;
        this._translationUrl = translationUrl;
        this._objectMapper = objectMapper;
    }

    @Nonnull
    public ImmutableMap<String, String> getTranslatedAttributes(String locale) {
        String localeOrFallback = locale.equalsIgnoreCase("de") ? locale.toLowerCase(Locale.ROOT) : DEFAULT_LOCALE;
        String queryParameters = "?addDefaultWording=true&mergeNamespace=true&ns=profile-custom profile-attributes-default&lng=" + localeOrFallback;
        JsonNode response = (JsonNode)this._restTemplate.getForObject(this._translationUrl + queryParameters, JsonNode.class, new Object[0]);
        if (response == null) {
            LOGGER.warn("Call to {} returned null for language {}", (Object)this._translationUrl, (Object)localeOrFallback);
            return ImmutableMap.of();
        }
        JsonNode localizedNode = response.get(localeOrFallback);
        if (localizedNode == null) {
            LOGGER.warn("Response from {} has no child node '{}'", (Object)this._translationUrl, (Object)localeOrFallback);
            return ImmutableMap.of();
        }
        JsonNode profileCustomNode = localizedNode.get("profile-custom");
        if (profileCustomNode == null) {
            LOGGER.warn("Response from {} has no child node 'profile-custom'", (Object)this._translationUrl);
            return ImmutableMap.of();
        }
        JsonNode profileAttributesNode = profileCustomNode.get("profileAttribute");
        if (profileAttributesNode == null) {
            LOGGER.warn("Response from {} has no child node 'profileAttribute'", (Object)this._translationUrl);
            return ImmutableMap.of();
        }
        Map result = (Map)this._objectMapper.convertValue((Object)profileAttributesNode, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Optional.ofNullable((ImmutableMap)CUSTOM_TRANSLATIONS.get((Object)localeOrFallback)).ifPresent(result::putAll);
        return ImmutableMap.copyOf((Map)result);
    }
}

