/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.externallink.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.people.business.externallink.ExternalLinkParser;
import de.justsoftware.people.business.externallink.ExternalLinkService;
import de.justsoftware.people.business.externallink.model.ExternalLinkConfig;
import de.justsoftware.people.business.externallink.model.LinkConfigCreateModel;
import de.justsoftware.people.business.externallink.model.ValidExternalLink;
import de.justsoftware.people.domain.externallink.ExternalLinkRepository;
import de.justsoftware.people.domain.model.TenantId;
import de.justsoftware.people.domain.model.externallink.ExternalLinkId;
import de.justsoftware.people.domain.model.externallink.ValidLinkInsertModel;
import de.justsoftware.people.domain.model.profile.ProfileId;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class ExternalLinkServiceImpl
implements ExternalLinkService {
    private final ExternalLinkRepository _linkRepository;
    private final ExternalLinkParser _linkParser;

    @Autowired
    public ExternalLinkServiceImpl(ExternalLinkRepository repository, ExternalLinkParser linkParser) {
        this._linkRepository = repository;
        this._linkParser = linkParser;
    }

    public ExternalLinkId createExternalLink(TenantId tenantId, LinkConfigCreateModel createModel, ProfileId creator) {
        ValidLinkInsertModel insertModel = this._linkParser.parseAndValidateCreateModel(createModel);
        return this._linkRepository.createExternalLink(insertModel, tenantId, creator);
    }

    @Nonnull
    public ImmutableList<ExternalLinkConfig> getConfiguredLinks(TenantId tenantId) {
        ImmutableList storedLinkConfigs = this._linkRepository.getAllExternalLinks(tenantId);
        return (ImmutableList)storedLinkConfigs.stream().map(linkBO -> new ExternalLinkConfig(linkBO.getId(), linkBO.getUri(), linkBO.getDescription())).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public ImmutableList<ValidExternalLink> getLinkFromConfigAndData(List<ExternalLinkConfig> linkConfigs, Map<String, Collection<String>> dataFields) {
        ImmutableMap singleValueFields = ExternalLinkServiceImpl.getSingleValueFields(dataFields);
        return (ImmutableList)linkConfigs.stream().map(config -> this._linkParser.linkFromConfig(config, singleValueFields)).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private static ImmutableMap<String, String> getSingleValueFields(Map<String, Collection<String>> dataFields) {
        return (ImmutableMap)dataFields.entrySet().stream().filter(kvp -> ((Collection)kvp.getValue()).size() == 1).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, kvp -> (String)ImmutableList.copyOf((Collection)((Collection)kvp.getValue())).get(0)));
    }

    public void deleteExternalLinks(TenantId tenantId, ImmutableSet<ExternalLinkId> linkIds) {
        this._linkRepository.deleteLinksById(tenantId, linkIds);
    }
}

