/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.externallink.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.people.business.externallink.ExternalLinkParser;
import de.justsoftware.people.business.externallink.model.ExternalLinkConfig;
import de.justsoftware.people.business.externallink.model.LinkConfigCreateModel;
import de.justsoftware.people.business.externallink.model.ValidExternalLink;
import de.justsoftware.people.business.profile.AttributeNameValidator;
import de.justsoftware.people.domain.model.externallink.ValidLinkInsertModel;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ExternalLinkParserImpl
implements ExternalLinkParser {
    private static final String TOKEN_START = "{";
    private static final String TOKEN_END = "}";
    private final Pattern _tokenMatchPattern = Pattern.compile("(?<=\\{)(\\w+)(?=})");
    private final AttributeNameValidator _attributeNameValidator;

    @Autowired
    public ExternalLinkParserImpl(AttributeNameValidator attributeNameValidator) {
        this._attributeNameValidator = attributeNameValidator;
    }

    public ValidLinkInsertModel parseAndValidateCreateModel(LinkConfigCreateModel createModel) {
        String uri = createModel.getUri();
        if (StringUtils.isBlank((CharSequence)uri)) {
            throw new IllegalArgumentException("A uri can not be blank.");
        }
        if (this.hasDanglingDelimiters(uri)) {
            throw new IllegalArgumentException("The URI '" + uri + "' contains dangling placeholder delimiters.");
        }
        ImmutableList placeholderAttributes = this.getPlaceholderAttributes(uri);
        if (!this._attributeNameValidator.attributeNamesAreValid(placeholderAttributes)) {
            throw new IllegalArgumentException("The parsed list of placeholders '[" + StringUtils.join((Iterable)placeholderAttributes, (char)',') + "]' contained invalid entries.");
        }
        return new ValidLinkInsertModel(uri, createModel.getDescription());
    }

    public Optional<ValidExternalLink> linkFromConfig(ExternalLinkConfig linkConfig, ImmutableMap<String, String> insertValues) {
        StringSubstitutor substitutor = new StringSubstitutor(insertValues, TOKEN_START, TOKEN_END);
        String uri = substitutor.replace(linkConfig.getPlaceholderUri());
        ImmutableList unfilledPlaceholders = this.getPlaceholderAttributes(uri);
        if (!unfilledPlaceholders.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ValidExternalLink(uri, linkConfig.getDescription()));
    }

    @Nonnull
    public ImmutableList<String> getPlaceholders(ExternalLinkConfig linkConfig) {
        return this.getPlaceholderAttributes(linkConfig.getPlaceholderUri());
    }

    @Nonnull
    private ImmutableList<String> getPlaceholderAttributes(String input) {
        Matcher tokenMatcher = this._tokenMatchPattern.matcher(input);
        ImmutableList.Builder resultBuilder = new ImmutableList.Builder();
        while (tokenMatcher.find()) {
            resultBuilder.add((Object)tokenMatcher.group());
        }
        return resultBuilder.build();
    }

    private boolean hasDanglingDelimiters(String input) {
        long endDelimitersCount;
        long startDelimitersCount = input.chars().filter(c -> c == TOKEN_START.charAt(0)).count();
        return startDelimitersCount != (endDelimitersCount = input.chars().filter(c -> c == TOKEN_END.charAt(0)).count());
    }
}

