/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.authorization.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.people.authorization.AuthorizationContext;
import de.justsoftware.people.authorization.AuthorizationException;
import de.justsoftware.people.authorization.NotAllowed;
import de.justsoftware.people.authorization.NotFound;
import de.justsoftware.people.authorization.models.StaticAction;
import de.justsoftware.people.domain.model.AbstractId;
import de.justsoftware.people.domain.model.TenantId;
import de.justsoftware.people.domain.model.profile.ProfileId;
import de.justsoftware.permission.client.model.AuthorizationResult;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class AuthorizationContextImpl
implements AuthorizationContext {
    private final ProfileId _profileId;
    private final TenantId _tenantId;
    private final PermissionRequestConnector _permissionRequestConnector;

    AuthorizationContextImpl(ProfileId profileId, TenantId tenantId, PermissionRequestConnector permissionRequestConnector) {
        this._profileId = profileId;
        this._tenantId = tenantId;
        this._permissionRequestConnector = permissionRequestConnector;
    }

    public ProfileId getProfileId() {
        return this._profileId;
    }

    public TenantId getTenantId() {
        return this._tenantId;
    }

    public ImmutableMap<Role, AuthorizationResult> has(Set<Role> toCheck) {
        return this._permissionRequestConnector.hasRoles(toCheck, (Iterable)ImmutableSet.of((Object)this._profileId.asPermissionRole()));
    }

    public AuthorizationResult has(Role toCheck) {
        AuthorizationResult result = (AuthorizationResult)this.has((Set)ImmutableSet.of((Object)toCheck)).get((Object)toCheck);
        if (result == null) {
            return AuthorizationResult.NOT_ALLOWED;
        }
        return result;
    }

    public boolean may(Role toCheck) {
        return this.has(toCheck) == AuthorizationResult.OK;
    }

    public boolean mayAll(Set<Role> toCheck) {
        return this.has(toCheck).values().stream().allMatch(arg_0 -> AuthorizationResult.OK.equals(arg_0));
    }

    public void check(Set<Role> toCheck) throws AuthorizationException {
        ImmutableMap result = this.has(toCheck);
        ImmutableSet notFound = (ImmutableSet)toCheck.stream().filter(role -> AuthorizationResult.NOT_FOUND.equals(result.getOrDefault(role, (Object)AuthorizationResult.NOT_FOUND))).collect(ImmutableSet.toImmutableSet());
        if (!notFound.isEmpty()) {
            throw new NotFound(notFound);
        }
        ImmutableSet notAllowed = (ImmutableSet)toCheck.stream().filter(role -> AuthorizationResult.NOT_ALLOWED.equals(result.get(role))).collect(ImmutableSet.toImmutableSet());
        if (!notAllowed.isEmpty()) {
            throw new NotAllowed(notAllowed);
        }
    }

    public void check(Role toCheck) throws AuthorizationException {
        this.check((Set)ImmutableSet.of((Object)toCheck));
    }

    public void check(StaticAction action, AbstractId<?> id) throws AuthorizationException {
        this.check(Role.itemRole((String)action.getName(), (String)id.asString()));
    }

    public ImmutableSet<Role> filterRoles(Iterable<Role> rolesToCheck) {
        return this._permissionRequestConnector.filterRoles(rolesToCheck, (Iterable)ImmutableSet.of((Object)this._profileId.asPermissionRole()));
    }

    public void check(Set<Role> userRoles, Role roleToCheck) {
        userRoles.forEach(userRole -> {
            ImmutableMap results = this._permissionRequestConnector.hasRoles((Iterable)ImmutableSet.of((Object)roleToCheck), (Iterable)ImmutableSet.of((Object)userRole));
            results.values().forEach(authorizationResult -> {
                if (authorizationResult.equals((Object)AuthorizationResult.NOT_ALLOWED)) {
                    throw new NotAllowed(ImmutableSet.of((Object)roleToCheck));
                }
                if (authorizationResult.equals((Object)AuthorizationResult.NOT_FOUND)) {
                    throw new NotFound(ImmutableSet.of((Object)roleToCheck));
                }
            });
        });
    }

    public ImmutableSet<Role> searchRoles() {
        return this._permissionRequestConnector.searchRoles(this._profileId.asPermissionRole());
    }
}

