/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.application.utils;

import com.google.common.collect.ImmutableList;
import de.justsoftware.people.domain.model.PagedResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public class PagedResults {
    @Nonnull
    public static <T, R> PagedResult<R> map(PagedResult<T> pagedResult, Function<T, R> function) {
        return new PagedResult(pagedResult.getOffset(), pagedResult.getTotalCount(), (ImmutableList)pagedResult.getRows().stream().map(function).collect(ImmutableList.toImmutableList()), pagedResult.getFacets());
    }

    @Nonnull
    public static <T> ByteArrayInputStream toByteArrayInputStream(PagedResult<T> pagedResult, Function<T, String> toStringFn) {
        ImmutableList stringList = PagedResults.mapToStringList(pagedResult, toStringFn);
        byte[] byteArray = PagedResults.mapToUtf8ByteArray((ImmutableList)stringList);
        return new ByteArrayInputStream(byteArray);
    }

    @Nonnull
    private static <T> ImmutableList<String> mapToStringList(PagedResult<T> pagedResult, Function<T, String> toStringFn) {
        return (ImmutableList)pagedResult.getRows().stream().map(toStringFn).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private static byte[] mapToUtf8ByteArray(ImmutableList<String> stringList) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (String element : stringList) {
            byteArrayOutputStream.writeBytes(element.getBytes(StandardCharsets.UTF_8));
            byteArrayOutputStream.write(13);
        }
        try {
            byteArrayOutputStream.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not write data as UTF8");
        }
        return byteArrayOutputStream.toByteArray();
    }
}

