/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.application.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.justsoftware.people.application.UserGroupApplicationService;
import de.justsoftware.people.application.exception.NotInSameTenantException;
import de.justsoftware.people.application.model.Action;
import de.justsoftware.people.application.model.PermissionDetails;
import de.justsoftware.people.application.model.ProfilePermissionModel;
import de.justsoftware.people.application.model.UserGroup;
import de.justsoftware.people.application.model.UserGroupDetails;
import de.justsoftware.people.application.utils.PagedResults;
import de.justsoftware.people.authorization.AuthorizationContext;
import de.justsoftware.people.authorization.models.StaticAction;
import de.justsoftware.people.business.usergroup.UserGroupService;
import de.justsoftware.people.domain.model.AbstractId;
import de.justsoftware.people.domain.model.PagedResult;
import de.justsoftware.people.domain.model.TenantId;
import de.justsoftware.people.domain.model.profile.ProfileId;
import de.justsoftware.people.domain.model.profile.ProfileSearchReadModel;
import de.justsoftware.people.domain.model.usergroup.UserGroupBO;
import de.justsoftware.people.domain.model.usergroup.UserGroupId;
import de.justsoftware.people.domain.model.usergroup.UserGroupRole;
import de.justsoftware.people.domain.search.SearchReadService;
import de.justsoftware.people.exceptions.NotFoundException;
import de.justsoftware.permission.client.model.CoreApp;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.toolbox.stream.EntryCollectors;
import de.justsoftware.toolbox.stream.EntryStream;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class UserGroupApplicationServiceImpl
implements UserGroupApplicationService {
    private final UserGroupService _userGroupService;
    private final SearchReadService _searchReadService;

    @Autowired
    public UserGroupApplicationServiceImpl(UserGroupService userGroupService, SearchReadService searchReadService) {
        this._userGroupService = userGroupService;
        this._searchReadService = searchReadService;
    }

    public Optional<UserGroupDetails> getUserGroupDetails(AuthorizationContext authCtx, UserGroupId userGroupId) {
        authCtx.check(StaticAction.READ, (AbstractId)userGroupId);
        return this._userGroupService.findUserGroup(userGroupId).map(userGroup -> new UserGroupDetails(UserGroupApplicationServiceImpl.toUserGroup((UserGroupBO)userGroup), this.getAllowedActions(authCtx, userGroupId), this.getAllowedRoles(authCtx, userGroup)));
    }

    @Nonnull
    private ImmutableSet<UserGroupRole> getAllowedRoles(AuthorizationContext authCtx, UserGroupBO userGroup) {
        if (authCtx.may(StaticAction.MANAGE.itemRole((AbstractId)userGroup.getId()))) {
            return userGroup.isAllTenantUsers() || userGroup.isImported() ? ImmutableSet.of((Object)UserGroupRole.READER) : ImmutableSet.copyOf((Object[])UserGroupRole.values());
        }
        return ImmutableSet.of();
    }

    @Nonnull
    private ImmutableSet<Action> getAllowedActions(AuthorizationContext authCtx, UserGroupId userGroupId) {
        ImmutableMap roleToActionMapping = ImmutableMap.of((Object)StaticAction.MANAGE.itemRole((AbstractId)userGroupId), (Object)Action.MANAGE, (Object)StaticAction.DELETE.itemRole((AbstractId)userGroupId), (Object)Action.DELETE, (Object)StaticAction.WRITE.itemRole((AbstractId)userGroupId), (Object)Action.WRITE);
        ImmutableSet userRoles = authCtx.filterRoles((Iterable)roleToActionMapping.keySet());
        return (ImmutableSet)userRoles.stream().map(arg_0 -> ((ImmutableMap)roleToActionMapping).get(arg_0)).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    public PagedResult<UserGroup> getUserGroups(AuthorizationContext authCtx, TenantId tenantId, String query, int offset, int limit) {
        authCtx.check(Role.read((String)tenantId.asString()));
        ImmutableSet searchRoles = authCtx.searchRoles();
        return PagedResults.map((PagedResult)this._searchReadService.allUserGroups(tenantId, query, searchRoles, offset, limit), userGroupSearchModel -> new UserGroup(userGroupSearchModel.getId(), userGroupSearchModel.getName(), userGroupSearchModel.isImported(), userGroupSearchModel.isAllTenantUsers()));
    }

    @Nonnull
    public UserGroupId createUserGroup(AuthorizationContext authCtx, String name, TenantId tenantId) {
        authCtx.check(Role.writeApp((CoreApp)CoreApp.PEOPLE, (UUID)((UUID)tenantId.getId())));
        return this._userGroupService.createUserGroup(name, authCtx.getProfileId(), tenantId);
    }

    public void updateMembers(AuthorizationContext authCtx, UserGroupId userGroupId, Set<ProfileId> membersToAdd, Set<ProfileId> membersToDelete) {
        authCtx.check(StaticAction.WRITE, (AbstractId)userGroupId);
        UserGroupBO userGroup = (UserGroupBO)this._userGroupService.findUserGroup(userGroupId).orElseThrow(() -> new NotFoundException("Could not find user group " + userGroupId, userGroupId.toString()));
        TenantId tenantId = userGroup.getTenantId();
        authCtx.check(membersToAdd.stream().map(profileId -> Role.read((String)profileId.asString())).collect(Collectors.toSet()));
        authCtx.check(membersToAdd.stream().map(ProfileId::asPermissionRole).collect(Collectors.toSet()), tenantId.asPermissionRole());
        this._userGroupService.updateMembers(userGroupId, membersToAdd, membersToDelete);
    }

    public void deleteUserGroup(AuthorizationContext authCtx, UserGroupId groupId) {
        authCtx.check(StaticAction.DELETE, (AbstractId)groupId);
        this._userGroupService.deleteUserGroup(groupId);
    }

    public void renameUserGroup(AuthorizationContext authCtx, UserGroupId groupId, String name) {
        authCtx.check(StaticAction.MANAGE, (AbstractId)groupId);
        this._userGroupService.renameUserGroup(groupId, name);
    }

    public PermissionDetails getUserGroupPermissions(AuthorizationContext authCtx, UserGroupId userGroupId) {
        authCtx.check(StaticAction.READ, (AbstractId)userGroupId);
        ImmutableMap userGroupPermissions = this._userGroupService.getUserGroupRoles(ImmutableSet.of((Object)userGroupId)).row((Object)userGroupId);
        ImmutableSet userGroupRoles = (ImmutableSet)userGroupPermissions.keySet().stream().filter(Role::isUserGroupRole).map(UserGroupId::parse).collect(ImmutableSet.toImmutableSet());
        ImmutableMap userGroups = (ImmutableMap)EntryStream.from((Map)this._userGroupService.getUserGroups((Set)userGroupRoles)).mapValue(UserGroupApplicationServiceImpl::toUserGroup).collect(EntryCollectors.toImmutableMap());
        ImmutableSet profileIds = (ImmutableSet)userGroupPermissions.keySet().stream().filter(Role::isProfileRole).map(ProfileId::parse).collect(ImmutableSet.toImmutableSet());
        ImmutableMap profiles = (ImmutableMap)this._searchReadService.getProfiles(profileIds).getRows().stream().collect(ImmutableMap.toImmutableMap(ProfileSearchReadModel::getId, ProfilePermissionModel::fromSearchReadModel));
        return new PermissionDetails(userGroupPermissions, userGroups, profiles);
    }

    public void setUserGroupPermissions(AuthorizationContext authCtx, UserGroupId groupId, Map<Role, UserGroupRole> permissions) {
        authCtx.check(StaticAction.MANAGE, (AbstractId)groupId);
        UserGroupBO userGroup = (UserGroupBO)this._userGroupService.findUserGroup(groupId).orElseThrow(() -> new NotFoundException("User group not found.", groupId.asString()));
        if (!permissions.keySet().stream().filter(Role::isTenantRole).allMatch(arg_0 -> ((Role)userGroup.getTenantId().asPermissionRole()).equals(arg_0))) {
            throw new NotInSameTenantException();
        }
        ImmutableSet userGroupIdsToCheck = (ImmutableSet)permissions.keySet().stream().filter(Role::isUserGroupRole).map(UserGroupId::parse).collect(ImmutableSet.toImmutableSet());
        this._userGroupService.getUserGroups((Set)userGroupIdsToCheck).values().forEach(userGroupToCheck -> {
            if (!userGroupToCheck.getTenantId().equals((Object)userGroup.getTenantId())) {
                throw new NotInSameTenantException();
            }
        });
        ImmutableSet allowedRoles = this.getAllowedRoles(authCtx, userGroup);
        if (!allowedRoles.containsAll(permissions.values())) {
            throw new IllegalArgumentException(String.format("One of provided roles %s is not allowed for group %s", permissions.values(), groupId));
        }
        ImmutableSet oldUserGroupRoles = (ImmutableSet)this._userGroupService.getUserGroupRoles(ImmutableSet.of((Object)groupId)).row((Object)groupId).keySet().stream().filter(Role::isUserGroupRole).map(UserGroupId::parse).collect(ImmutableSet.toImmutableSet());
        Set filteredUserGroupIds = Sets.filter((Set)userGroupIdsToCheck, userGroupId -> !oldUserGroupRoles.contains(userGroupId));
        filteredUserGroupIds.forEach(userGroupId -> authCtx.check(StaticAction.READ, (AbstractId)userGroupId));
        ImmutableSet userRoles = ImmutableSet.copyOf(permissions.keySet());
        authCtx.check((Set)userRoles, Role.read((String)userGroup.getTenantId().asString()));
        this._userGroupService.setUserGroupRoles(groupId, permissions);
    }

    public Optional<UserGroup> getAllTenantUsersGroup(AuthorizationContext authCtx, TenantId tenantId, Boolean mayInteract) {
        Set<Role> rolesToCheck;
        UserGroupId allTenantUsersGroup = this._userGroupService.getAllTenantUsersGroup(tenantId);
        Set<Role> set = rolesToCheck = mayInteract != false ? Set.of(StaticAction.USE.itemRole((AbstractId)allTenantUsersGroup), StaticAction.READ.itemRole((AbstractId)allTenantUsersGroup)) : Set.of(StaticAction.READ.itemRole((AbstractId)allTenantUsersGroup));
        if (authCtx.mayAll(rolesToCheck)) {
            return this._userGroupService.findUserGroup(allTenantUsersGroup).map(UserGroupApplicationServiceImpl::toUserGroup);
        }
        return Optional.empty();
    }

    @Nonnull
    static UserGroup toUserGroup(UserGroupBO userGroup) {
        return new UserGroup(userGroup.getId(), userGroup.getName(), userGroup.isImported(), userGroup.isAllTenantUsers());
    }
}

