/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.application.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import de.justsoftware.people.application.SearchApplicationService;
import de.justsoftware.people.application.model.FacetFilterModel;
import de.justsoftware.people.application.model.ProfileCsvInputStream;
import de.justsoftware.people.application.model.ProfileSearchResult;
import de.justsoftware.people.application.model.SearchFilterModel;
import de.justsoftware.people.application.utils.JustCsvUtils;
import de.justsoftware.people.application.utils.PagedResults;
import de.justsoftware.people.authorization.AuthorizationContext;
import de.justsoftware.people.authorization.models.StaticAction;
import de.justsoftware.people.business.externallink.ExternalLinkService;
import de.justsoftware.people.business.profile.ProfileAttributeTranslationService;
import de.justsoftware.people.business.profile.ProfileService;
import de.justsoftware.people.business.profile.model.Profile;
import de.justsoftware.people.business.profile.model.ProfileAttributeConfig;
import de.justsoftware.people.business.search.SearchService;
import de.justsoftware.people.business.search.model.FacetFilter;
import de.justsoftware.people.business.search.model.SearchFilter;
import de.justsoftware.people.business.search.model.SearchableField;
import de.justsoftware.people.business.search.model.StaticSearchableField;
import de.justsoftware.people.domain.model.AbstractId;
import de.justsoftware.people.domain.model.PagedResult;
import de.justsoftware.people.domain.model.SearchModel;
import de.justsoftware.people.domain.model.TenantId;
import de.justsoftware.people.domain.model.profile.ProfileId;
import de.justsoftware.people.domain.model.profile.ProfileSearchReadModel;
import de.justsoftware.people.domain.model.usergroup.UserGroupId;
import de.justsoftware.people.exceptions.NotFoundException;
import de.justsoftware.permission.client.model.CoreApp;
import de.justsoftware.permission.client.model.Role;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class SearchApplicationServiceImpl
implements SearchApplicationService {
    private static final int EXPORT_PAGE_LIMIT = 200;
    private final SearchService _searchService;
    private final ProfileService _profileService;
    private final ProfileAttributeTranslationService _profileAttributeTranslationService;
    private final ExternalLinkService _externalLinkService;

    @Autowired
    public SearchApplicationServiceImpl(SearchService searchService, ProfileService profileService, ExternalLinkService externalLinkService, ProfileAttributeTranslationService profileAttributeTranslationService) {
        this._searchService = searchService;
        this._profileService = profileService;
        this._externalLinkService = externalLinkService;
        this._profileAttributeTranslationService = profileAttributeTranslationService;
    }

    public PagedResult<ProfileSearchResult> allProfiles(AuthorizationContext authCtx, @Nullable TenantId tenantId, String searchString, List<SearchFilterModel> searchFilterModel, @Nullable FacetFilterModel facetFilterModel, @Nullable UserGroupId contextGroupId, @Nullable UserGroupId groupId, int offset, int limit) {
        if (groupId != null) {
            authCtx.check(StaticAction.READ, (AbstractId)groupId);
        } else if (tenantId != null) {
            authCtx.check(Role.read((String)tenantId.asString()));
        } else {
            throw new IllegalArgumentException("UserGroupId or TenantId required.");
        }
        ImmutableMap searchableFields = Maps.uniqueIndex((Iterable)this._searchService.getSearchableFields(), SearchableField::getId);
        ImmutableList searchFilter = (ImmutableList)searchFilterModel.stream().map(filter -> new SearchFilter(this.getValidSearchableField(searchableFields, filter.getId()), filter.getValues())).collect(ImmutableList.toImmutableList());
        FacetFilter facetFilter = this.getValidFacetContains(facetFilterModel, searchableFields);
        ImmutableList configuredLinks = this._externalLinkService.getConfiguredLinks(tenantId);
        return PagedResults.map((PagedResult)this._searchService.allProfiles(tenantId, searchString, searchFilter, authCtx.searchRoles(), facetFilter, groupId, offset, limit), p -> new ProfileSearchResult(this._profileService.getProfile(p, configuredLinks), p.getUserGroupIds().contains((Object)contextGroupId)));
    }

    public ProfileCsvInputStream exportProfiles(AuthorizationContext authCtx, TenantId tenantId, String searchString, List<SearchFilterModel> searchFilterModel, @Nullable UserGroupId groupId, String locale) {
        authCtx.check(Role.exportApp((CoreApp)CoreApp.PEOPLE, (UUID)((UUID)tenantId.getId())));
        ImmutableList profileAttributeConfigs = this.getAttributeConfigList();
        String translatedHeaderRow = this.getTranslatedHeaderRow(locale, profileAttributeConfigs);
        ImmutableMap searchableFields = Maps.uniqueIndex((Iterable)this._searchService.getSearchableFields(), SearchableField::getId);
        ImmutableList searchFilter = (ImmutableList)searchFilterModel.stream().map(filter -> new SearchFilter(this.getValidSearchableField(searchableFields, filter.getId()), filter.getValues())).collect(ImmutableList.toImmutableList());
        ImmutableList configuredLinks = this._externalLinkService.getConfiguredLinks(tenantId);
        return new ProfileCsvInputStream(translatedHeaderRow, offset -> PagedResults.map((PagedResult)this._searchService.allProfiles(tenantId, searchString, searchFilter, authCtx.searchRoles(), null, groupId, offset.intValue(), 200), p -> this._profileService.getProfile(p, configuredLinks)), profileAttributeConfigs, 200L);
    }

    @Nonnull
    private String getTranslatedHeaderRow(String locale, ImmutableList<ProfileAttributeConfig> profileAttributeConfigs) {
        ImmutableMap translatedAttributes = this._profileAttributeTranslationService.getTranslatedAttributes(locale);
        ArrayList result = new ArrayList();
        profileAttributeConfigs.stream().map(ProfileAttributeConfig::getName).map(attributeName -> (String)translatedAttributes.getOrDefault(attributeName, attributeName)).map(JustCsvUtils::csvEscape).forEach(result::add);
        return String.join((CharSequence)";", result);
    }

    @Nonnull
    private ImmutableList<ProfileAttributeConfig> getAttributeConfigList() {
        List attributeConfigList = this._searchService.getSearchConfiguration().stream().filter(attributeConfig -> {
            String name = attributeConfig.getName();
            return name.equals(StaticSearchableField.FIRSTNAME.getAttributeName()) || name.equals(StaticSearchableField.LASTNAME.getAttributeName()) || name.equals(StaticSearchableField.TITLE.getAttributeName()) || name.equals(StaticSearchableField.ADDITIONAL_TITLE.getAttributeName()) || attributeConfig.isVisibleOnBadge();
        }).collect(Collectors.toList());
        this.moveAttributeToFirstPosition(attributeConfigList, StaticSearchableField.ADDITIONAL_TITLE.getAttributeName());
        this.moveAttributeToFirstPosition(attributeConfigList, StaticSearchableField.LASTNAME.getAttributeName());
        this.moveAttributeToFirstPosition(attributeConfigList, StaticSearchableField.FIRSTNAME.getAttributeName());
        this.moveAttributeToFirstPosition(attributeConfigList, StaticSearchableField.TITLE.getAttributeName());
        return ImmutableList.copyOf(attributeConfigList);
    }

    private void moveAttributeToFirstPosition(List<ProfileAttributeConfig> configList, String attributeName) {
        configList.stream().filter(config -> config.getName().equals(attributeName)).findFirst().ifPresent(config -> {
            configList.remove(config);
            configList.add(0, (ProfileAttributeConfig)config);
        });
    }

    @CheckForNull
    private FacetFilter getValidFacetContains(@Nullable FacetFilterModel facetFilter, ImmutableMap<String, SearchableField> searchableFields) {
        if (facetFilter == null) {
            return null;
        }
        SearchableField facetFilterField = this.getValidSearchableField(searchableFields, facetFilter.getSearchFieldId());
        if (!this._searchService.getSearchConfiguration(facetFilterField).filter(ProfileAttributeConfig::isFacetable).filter(ProfileAttributeConfig::isSearchInFacetsSupported).isPresent()) {
            throw new IllegalArgumentException("Invalid facet filter id " + facetFilter.getSearchFieldId());
        }
        return new FacetFilter(facetFilterField, facetFilter.getValue());
    }

    @Nonnull
    private SearchableField getValidSearchableField(ImmutableMap<String, SearchableField> searchableFields, String searchFieldId) {
        return Optional.ofNullable((SearchableField)searchableFields.get((Object)searchFieldId)).orElseThrow(() -> new IllegalArgumentException("Invalid search field id: " + searchFieldId));
    }

    public PagedResult<SearchModel> allProfilesAndUserGroups(AuthorizationContext authCtx, TenantId tenantId, String searchString, int offset, int limit) {
        authCtx.check(Role.read((String)tenantId.asString()));
        ImmutableSet searchRoles = authCtx.searchRoles();
        return this._searchService.allProfilesAndUserGroups(tenantId, searchString, searchRoles, offset, limit);
    }

    public PagedResult<SearchModel> searchInNames(AuthorizationContext authCtx, TenantId tenantId, String searchString, ImmutableSet<String> types, int offset, int limit) {
        authCtx.check(Role.read((String)tenantId.asString()));
        ImmutableSet searchRoles = authCtx.searchRoles();
        return this._searchService.searchInNames(tenantId, searchString, searchRoles, types, offset, limit);
    }

    public Profile getProfile(AuthorizationContext authCtx, ProfileId profileId) {
        ProfileSearchReadModel profile = this._searchService.findProfile(profileId, authCtx.searchRoles());
        if (profile == null) {
            throw new NotFoundException("Profile not found", profileId.asString());
        }
        return this._profileService.getProfile(profile);
    }

    public ImmutableList<ProfileAttributeConfig> getSearchConfiguration(AuthorizationContext authCtx, TenantId tenantId) {
        authCtx.check(Role.read((String)tenantId.asString()));
        return this._searchService.getSearchConfiguration();
    }
}

