/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.security.oAuth;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.Duration;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.RemoteTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.oauth2.provider.token.UserAuthenticationConverter;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class RemoteTokenService
implements ResourceServerTokenServices {
    private final RemoteTokenServices _delegateTokenServices;
    private final LoadingCache<String, OAuth2Authentication> _tokenCache;

    @Autowired
    public RemoteTokenService(@Value(value="${just.notifications.oauth2.resource.client_id}") String clientId, @Value(value="${just.notifications.oauth2.resource.client_secret}") String clientSecret, @Value(value="${just.notifications.toro.internal.baseUrl}") String baseUrl, @Value(value="${just.notifications.oauth2.resource.check_token_endpoint}") String checkTokenEndpoint, @Qualifier(value="profileIdExtractingConverter") UserAuthenticationConverter userAuthenticationConverter, @Value(value="${just.notifications.oauth2.resource.accessTokenCache.maxSize: 1000}") int maxAccessTokenCacheSize) {
        DefaultAccessTokenConverter tokenConverter = new DefaultAccessTokenConverter();
        tokenConverter.setUserTokenConverter(userAuthenticationConverter);
        this._delegateTokenServices = new RemoteTokenServices();
        this._delegateTokenServices.setCheckTokenEndpointUrl(baseUrl + checkTokenEndpoint);
        this._delegateTokenServices.setClientId(clientId);
        this._delegateTokenServices.setClientSecret(clientSecret);
        this._delegateTokenServices.setAccessTokenConverter((AccessTokenConverter)tokenConverter);
        this._tokenCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(1L)).refreshAfterWrite(Duration.ofSeconds(5L)).maximumSize((long)maxAccessTokenCacheSize).recordStats().build(arg_0 -> ((RemoteTokenServices)this._delegateTokenServices).loadAuthentication(arg_0));
    }

    public OAuth2Authentication loadAuthentication(String accessToken) throws AuthenticationException, InvalidTokenException {
        return (OAuth2Authentication)this._tokenCache.get((Object)accessToken);
    }

    public OAuth2AccessToken readAccessToken(String accessToken) {
        return this._delegateTokenServices.readAccessToken(accessToken);
    }
}

