/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.persistence;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import de.justsoftware.notificationservice.persistence.model.Notification;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public interface NotificationRepository
extends JpaRepository<Notification, UUID> {
    public static final int MAX_IN_CLAUSE_PARAMS = 1000;

    @Nonnull
    default public ImmutableMap<UUID, Notification> findByIds(Set<UUID> ids) {
        if (ids.isEmpty()) {
            return ImmutableMap.of();
        }
        ArrayList notifications = new ArrayList();
        Iterators.partition(ids.iterator(), (int)1000).forEachRemaining(batchOfIds -> notifications.addAll(this.findAllById((Iterable)batchOfIds)));
        return (ImmutableMap)notifications.stream().collect(ImmutableMap.toImmutableMap(Notification::getId, (Function)Functions.identity()));
    }

    @Deprecated
    @Nonnull
    @EntityGraph(value="graph.Notification")
    public List<Notification> findAllById(Iterable<UUID> var1);
}

