/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.kafka;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.mobilepush.PushNotificationProducer;
import de.justsoftware.mobilepush.model.PushNotification;
import de.justsoftware.mobilepush.model.PushReceiver;
import de.justsoftware.notificationclient.model.Notification;
import de.justsoftware.notificationservice.business.BrowserPushService;
import de.justsoftware.notificationservice.kafka.NotificationKafkaConsumer;
import de.justsoftware.notificationservice.model.NotificationStatus;
import de.justsoftware.notificationservice.persistence.DeliveryStatusRepository;
import de.justsoftware.notificationservice.persistence.NotificationRepository;
import de.justsoftware.notificationservice.persistence.UserGroupMemberRepository;
import de.justsoftware.notificationservice.persistence.model.DeliveryStatus;
import de.justsoftware.notificationservice.persistence.model.IdType;
import de.justsoftware.notificationservice.persistence.model.ProfileId;
import de.justsoftware.notificationservice.persistence.model.UserGroupId;
import de.justsoftware.notificationservice.persistence.model.UserGroupMember;
import de.justsoftware.notificationservice.util.CollectionUtilKt;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.validation.ValidationException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u001c\u0010\u0014\u001a\u00020\u000e2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00100\u0016H\u0007J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0003J\u001e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001c2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/justsoftware/notificationservice/kafka/NotificationKafkaConsumer;", "", "pushNotificationProducer", "Lde/justsoftware/mobilepush/PushNotificationProducer;", "notificationRepository", "Lde/justsoftware/notificationservice/persistence/NotificationRepository;", "userGroupMemberRepository", "Lde/justsoftware/notificationservice/persistence/UserGroupMemberRepository;", "deliveryStatusRepository", "Lde/justsoftware/notificationservice/persistence/DeliveryStatusRepository;", "browserPushService", "Lde/justsoftware/notificationservice/business/BrowserPushService;", "(Lde/justsoftware/mobilepush/PushNotificationProducer;Lde/justsoftware/notificationservice/persistence/NotificationRepository;Lde/justsoftware/notificationservice/persistence/UserGroupMemberRepository;Lde/justsoftware/notificationservice/persistence/DeliveryStatusRepository;Lde/justsoftware/notificationservice/business/BrowserPushService;)V", "dispatchPushNotification", "", "notification", "Lde/justsoftware/notificationclient/model/Notification;", "resolvedReceivers", "", "Lde/justsoftware/notificationservice/persistence/model/ProfileId;", "listen", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "", "process", "key", "resolveReceivers", "saveDeliveryStatus", "Lde/justsoftware/notificationservice/persistence/model/Notification;", "saveNotification", "", "Companion", "notification-service"})
@SuppressFBWarnings(value={"BC_BAD_CAST_TO_ABSTRACT_COLLECTION"}, justification="Spotbugs does not support checking interaction of Kotlin collection types generated in thisclass and Java collection types used by the called methods in other classes.")
public final class NotificationKafkaConsumer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PushNotificationProducer pushNotificationProducer;
    @NotNull
    private final NotificationRepository notificationRepository;
    @NotNull
    private final UserGroupMemberRepository userGroupMemberRepository;
    @NotNull
    private final DeliveryStatusRepository deliveryStatusRepository;
    @NotNull
    private final BrowserPushService browserPushService;
    private static final Logger LOG = LoggerFactory.getLogger(NotificationKafkaConsumer.class);

    public NotificationKafkaConsumer(@NotNull PushNotificationProducer pushNotificationProducer, @NotNull NotificationRepository notificationRepository, @NotNull UserGroupMemberRepository userGroupMemberRepository, @NotNull DeliveryStatusRepository deliveryStatusRepository, @NotNull BrowserPushService browserPushService) {
        Intrinsics.checkNotNullParameter((Object)pushNotificationProducer, (String)"pushNotificationProducer");
        Intrinsics.checkNotNullParameter((Object)notificationRepository, (String)"notificationRepository");
        Intrinsics.checkNotNullParameter((Object)userGroupMemberRepository, (String)"userGroupMemberRepository");
        Intrinsics.checkNotNullParameter((Object)deliveryStatusRepository, (String)"deliveryStatusRepository");
        Intrinsics.checkNotNullParameter((Object)browserPushService, (String)"browserPushService");
        this.pushNotificationProducer = pushNotificationProducer;
        this.notificationRepository = notificationRepository;
        this.userGroupMemberRepository = userGroupMemberRepository;
        this.deliveryStatusRepository = deliveryStatusRepository;
        this.browserPushService = browserPushService;
    }

    @KafkaListener(id="notificationConsumer", containerFactory="notificationListenerContainerFactory", topics={"just.notification.dispatch"})
    public final void listen(@NotNull ConsumerRecords<String, Notification> records) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        for (ConsumerRecord record : records) {
            try {
                Object object = record.key();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"record.key()");
                String string = (String)object;
                Object object2 = record.value();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"record.value()");
                this.process(string, (Notification)object2);
            }
            catch (RuntimeException e) {
                LOG.error("Failed to process Notification record with {} = {}", record.key(), record.value());
            }
        }
    }

    @VisibleForTesting
    public final void process(@NotNull String key, @NotNull Notification notification) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        LOG.debug("Process notification with key {}: {}", (Object)key, (Object)notification);
        if (this.notificationRepository.existsById((Object)notification.getId())) {
            LOG.warn("Notification with id: {} already exists. Notification will be skipped.", (Object)notification.getId());
            return;
        }
        Set resolvedReceivers = this.resolveReceivers(notification);
        if (resolvedReceivers.isEmpty()) {
            LOG.debug("Skip notification {} as there are no receivers, e.g. an empty user group is the sole receiver", (Object)notification.getId());
            return;
        }
        boolean notificationSaved = this.saveNotification(notification, resolvedReceivers);
        if (notificationSaved) {
            if (Intrinsics.areEqual((Object)notification.isWithoutPush(), (Object)true)) {
                LOG.debug("Skip sending push for notification {}", (Object)notification.getId());
                return;
            }
            try {
                this.dispatchPushNotification(notification, resolvedReceivers);
            }
            catch (RuntimeException e) {
                LOG.error("Failed to dispatch push notification to kafka.", (Throwable)e);
            }
            try {
                this.browserPushService.pushNotificationsUpdated(resolvedReceivers);
            }
            catch (RuntimeException e) {
                LOG.error("Failed to dispatch browser push notificationUpdated to kafka.", (Throwable)e);
            }
        }
    }

    private final boolean saveNotification(Notification notification, Set<? extends ProfileId> resolvedReceivers) {
        de.justsoftware.notificationservice.persistence.model.Notification notification2;
        de.justsoftware.notificationservice.persistence.model.Notification dbNotification = new de.justsoftware.notificationservice.persistence.model.Notification(notification.getId(), notification.getTenantId(), notification.getAppId(), notification.getDefaultTitle(), notification.getDefaultText(), notification.getType(), notification.getTimestamp());
        dbNotification.setLocalizedTitle((Map)notification.getLocalizedTitle());
        dbNotification.setLocalizedText((Map)notification.getLocalizedText());
        dbNotification.setDefaultSecondaryText(notification.getDefaultSecondaryText());
        dbNotification.setLocalizedSecondaryText((Map)notification.getLocalizedSecondaryText());
        dbNotification.setMailAuthorName(notification.getMailAuthorName());
        dbNotification.setDefaultMailContainerName(notification.getDefaultMailContainerName());
        dbNotification.setLocalizedMailContainerName((Map)notification.getLocalizedMailContainerName());
        dbNotification.setDefaultMailReplacementText(notification.getDefaultMailReplacementText());
        dbNotification.setLocalizedMailReplacementText((Map)notification.getLocalizedMailReplacementText());
        dbNotification.setTargetId(notification.getTargetId());
        dbNotification.setPayload(notification.getPayload());
        try {
            notification2 = (de.justsoftware.notificationservice.persistence.model.Notification)this.notificationRepository.saveAndFlush((Object)dbNotification);
        }
        catch (ValidationException e) {
            LOG.warn("Failed to save Notification with id: " + notification.getId() + ". Notification will be skipped. Root cause is: {}", (Object)e.getMessage());
            return false;
        }
        catch (DataIntegrityViolationException e) {
            LOG.warn("Failed to save Notification with id: " + notification.getId() + ". Notification will be skipped. Root cause is: {}", (Object)e.getMessage());
            return false;
        }
        de.justsoftware.notificationservice.persistence.model.Notification notification3 = notification2;
        Intrinsics.checkNotNullExpressionValue((Object)notification3, (String)"try {\n            notifi\u2026   return false\n        }");
        de.justsoftware.notificationservice.persistence.model.Notification savedNotification = notification3;
        try {
            this.saveDeliveryStatus(savedNotification, resolvedReceivers);
        }
        catch (RuntimeException e) {
            LOG.error("Failed to save DeliveryStatus for notification " + notification.getId(), (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    private final Set<ProfileId> resolveReceivers(Notification notification) {
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        String receiver;
        Iterable $this$filterTo$iv$iv2;
        ImmutableSet immutableSet = notification.getReceivers();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"notification.receivers");
        Iterable $this$filter$iv2 = (Iterable)immutableSet;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            receiver = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)receiver, (String)(IdType.PROFILE.name() + ","), (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv2 = (List)destination$iv$iv;
        boolean $i$f$map22 = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void idString;
            receiver = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ProfileId((String)idString));
        }
        List directReceivers = (List)destination$iv$iv;
        ImmutableSet immutableSet2 = notification.getReceivers();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet2, (String)"notification.receivers");
        Iterable $i$f$map22 = (Iterable)immutableSet2;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String receiver2 = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)receiver2, (String)(IdType.USER_GROUP.name() + ","), (boolean)false, (int)2, null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void groupIdString;
            String receiver2 = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new UserGroupId((String)groupIdString).getId());
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            UUID groupId = (UUID)element$iv$iv;
            boolean bl = false;
            List list = this.userGroupMemberRepository.findAllByGroupId(groupId);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"userGroupMemberRepositor\u2026findAllByGroupId(groupId)");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void groupMember;
            UserGroupMember list$iv$iv = (UserGroupMember)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Long l = groupMember.getProfileId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"groupMember.profileId");
            collection.add(new ProfileId(((Number)l).longValue()));
        }
        List groupReceivers = (List)destination$iv$iv2;
        return CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)directReceivers, (Iterable)groupReceivers));
    }

    private final void saveDeliveryStatus(de.justsoftware.notificationservice.persistence.model.Notification notification, Set<? extends ProfileId> resolvedReceivers) {
        resolvedReceivers.forEach(arg_0 -> NotificationKafkaConsumer.saveDeliveryStatus$lambda$6(this, notification, arg_0));
        this.deliveryStatusRepository.flush();
    }

    /*
     * WARNING - void declaration
     */
    private final void dispatchPushNotification(Notification notification, Set<? extends ProfileId> resolvedReceivers) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        void $this$mapToSet$iv2;
        Iterable iterable = resolvedReceivers;
        boolean $i$f$mapToSet = false;
        void var6_6 = $this$mapToSet$iv2;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilKt.getDefaultSize((Iterable)$this$mapToSet$iv2));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void obj;
            ProfileId profileId = (ProfileId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(obj.toString());
        }
        Set receiverIds = (Set)destination$iv$iv;
        ImmutableMap immutableMap = this.deliveryStatusRepository.countByReceiverIdsAndStatus(receiverIds, NotificationStatus.OPEN);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"deliveryStatusRepository\u2026 NotificationStatus.OPEN)");
        ImmutableMap openNotificationCountsByReceivers = immutableMap;
        Set set = openNotificationCountsByReceivers.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"openNotificationCountsBy\u2026vers\n            .entries");
        $this$mapTo$iv$iv2 = set;
        boolean $i$f$mapToSet2 = false;
        void $i$f$mapTo22 = $this$mapToSet$iv;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(key, value)");
            String key = (String)entry.getKey();
            Integer value = (Integer)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            collection.add(new PushReceiver(key, value.intValue()));
        }
        Set receivers = (Set)destination$iv$iv2;
        PushNotification pushNotification = new PushNotification(notification.getId(), receivers, notification.getAppId(), notification.getTimestamp(), (Map)notification.getLocalizedTitle(), (Map)notification.getLocalizedText(), notification.getDefaultTitle(), notification.getDefaultText(), notification.getType(), notification.getTargetId());
        this.pushNotificationProducer.dispatchPushNotification(pushNotification);
    }

    private static final void saveDeliveryStatus$lambda$6(NotificationKafkaConsumer this$0, de.justsoftware.notificationservice.persistence.model.Notification $notification, ProfileId receiverId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$notification, (String)"$notification");
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        this$0.deliveryStatusRepository.save((Object)new DeliveryStatus($notification.getId(), receiverId.toString(), NotificationStatus.OPEN));
    }
}

