/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.controller;

import de.justsoftware.notificationservice.model.Configuration;
import io.swagger.v3.oas.annotations.Operation;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/configuration"})
@ParametersAreNonnullByDefault
public class ConfigurationController {
    private final int _pollInterval;

    @Autowired
    public ConfigurationController(@Value(value="${service.pollInterval:60000}") int pollInterval) {
        this._pollInterval = pollInterval;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    @ResponseBody
    @Nonnull
    @Operation(summary="Return configuration for this service")
    public Configuration getConfiguration() {
        return new Configuration(this._pollInterval);
    }
}

