/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.business;

import com.google.common.base.Charsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ZookeeperService {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperService.class);
    private static final String CACHE_EMPTY_ERROR = "Cannot read {}. Cache is empty";
    private final Map<String, NodeCache> _eventMap = new HashMap();
    private final CuratorFramework _curatorFramework;

    @Autowired
    public ZookeeperService(CuratorFramework curatorFramework) {
        this._curatorFramework = curatorFramework;
    }

    public void addListener(String path, NodeCacheListener listener) {
        NodeCache node = this.getNodeCache(path);
        node.getListenable().addListener((Object)listener);
    }

    @Nonnull
    private NodeCache getNodeCache(String path) {
        NodeCache keyCache = (NodeCache)this._eventMap.get(path);
        if (keyCache == null) {
            keyCache = new NodeCache(this._curatorFramework, path);
            try {
                keyCache.start();
                this._eventMap.put(path, keyCache);
            }
            catch (Exception e) {
                LOG.error("Could not initialize " + path + " cache", (Throwable)e);
                throw new IllegalArgumentException(e);
            }
        }
        return keyCache;
    }

    @Nonnull
    public Optional<String> getString(String path) {
        NodeCache cache = this.getNodeCache(path);
        ChildData currentData = cache.getCurrentData();
        if (currentData == null) {
            LOG.warn(CACHE_EMPTY_ERROR, (Object)path);
            return Optional.empty();
        }
        byte[] bytes = currentData.getData();
        if (bytes == null) {
            LOG.warn(CACHE_EMPTY_ERROR, (Object)path);
            return Optional.empty();
        }
        return Optional.of(new String(bytes, Charsets.UTF_8));
    }

    @Nonnull
    public Optional<Boolean> getBoolean(String path) {
        Optional stringValue = this.getString(path);
        if (!stringValue.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(Boolean.valueOf((String)stringValue.get()));
    }
}

