/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.business;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.notificationclient.model.NotificationConcern;
import de.justsoftware.notificationclient.model.NotificationType;
import de.justsoftware.notificationservice.business.BrowserPushService;
import de.justsoftware.notificationservice.controller.exception.NotificationNotFoundException;
import de.justsoftware.notificationservice.model.Notification;
import de.justsoftware.notificationservice.model.NotificationStatus;
import de.justsoftware.notificationservice.model.NotificationsCount;
import de.justsoftware.notificationservice.persistence.DeliveryStatusRepository;
import de.justsoftware.notificationservice.persistence.NotificationRepository;
import de.justsoftware.notificationservice.persistence.model.DeliveryStatus;
import de.justsoftware.notificationservice.persistence.model.ProfileId;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class NotificationService {
    private final NotificationRepository _notificationRepository;
    private final DeliveryStatusRepository _deliveryStatusRepository;
    private final BrowserPushService _browserPushService;

    @Autowired
    public NotificationService(NotificationRepository notificationRepository, DeliveryStatusRepository deliveryStatusRepository, BrowserPushService browserPushService) {
        this._notificationRepository = notificationRepository;
        this._deliveryStatusRepository = deliveryStatusRepository;
        this._browserPushService = browserPushService;
    }

    @Nonnull
    public ImmutableList<Notification> getNotifications(Locale locale, ProfileId receiverId, NotificationStatus status, NotificationConcern concern, @Nullable String app, Instant before, int maxElements) {
        Page deliveryStatus = app == null ? this._deliveryStatusRepository.findNotifications(receiverId.toString(), status, before, (Set)NotificationType.forConcern((NotificationConcern)concern), (Pageable)PageRequest.of((int)0, (int)maxElements, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"notification.timestamp"})) : this._deliveryStatusRepository.findNotificationsByApp(receiverId.toString(), status, before, (Set)NotificationType.forConcern((NotificationConcern)concern), app, (Pageable)PageRequest.of((int)0, (int)maxElements, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"notification.timestamp"}));
        ImmutableMap notifications = this._notificationRepository.findByIds((Set)deliveryStatus.get().map(DeliveryStatus::getNotificationId).collect(ImmutableSet.toImmutableSet()));
        return (ImmutableList)deliveryStatus.get().map(ds -> Notification.fromDBNotification((Locale)locale, (de.justsoftware.notificationservice.persistence.model.Notification)((de.justsoftware.notificationservice.persistence.model.Notification)notifications.get((Object)ds.getNotificationId())), (boolean)ds.isMarked())).collect(ImmutableList.toImmutableList());
    }

    public void archiveNotification(UUID notificationId, ProfileId receiverId) throws NotificationNotFoundException {
        int updated = this._deliveryStatusRepository.setArchived(receiverId.toString(), notificationId, Instant.now());
        if (updated == 0) {
            throw new NotificationNotFoundException();
        }
        this._deliveryStatusRepository.flush();
        this._browserPushService.pushNotificationsUpdated(receiverId);
    }

    @Nonnull
    @Transactional
    public ImmutableSet<UUID> archiveAllUnmarkedNotifications(ProfileId receiverId, NotificationConcern concern, @Nullable String app) {
        ImmutableSet types = NotificationType.forConcern((NotificationConcern)concern);
        List allOpenAndUnmarked = app == null ? this._deliveryStatusRepository.findAllOpenAndUnmarked(receiverId.toString(), (Set)types) : this._deliveryStatusRepository.findAllOpenAndUnmarkedByApp(receiverId.toString(), (Set)types, app);
        ImmutableSet notificationIds = (ImmutableSet)allOpenAndUnmarked.stream().map(DeliveryStatus::getNotificationId).collect(ImmutableSet.toImmutableSet());
        if (notificationIds.size() > 0) {
            this._deliveryStatusRepository.setArchived((Set)notificationIds, receiverId.toString(), Instant.now());
            this._deliveryStatusRepository.flush();
            this._browserPushService.pushNotificationsUpdated(receiverId);
        }
        return notificationIds;
    }

    @Nonnull
    @Transactional
    public NotificationsCount getNotificationsCount(ProfileId receiverId) {
        int open = this._deliveryStatusRepository.countByReceiverIdAndStatus(receiverId.toString(), NotificationStatus.OPEN);
        int archived = this._deliveryStatusRepository.countByReceiverIdAndStatus(receiverId.toString(), NotificationStatus.ARCHIVED);
        return new NotificationsCount(open, archived);
    }

    @Nonnull
    @Transactional
    public Map<String, Boolean> updated(ProfileId receiverId, Instant since) {
        boolean updated = this._deliveryStatusRepository.countUpdatesForReceiverSinceTimestamp(receiverId.toString(), since) > 0;
        return ImmutableMap.of((Object)"updated", (Object)updated);
    }

    public void markNotification(UUID notificationId, ProfileId receiverId) throws NotificationNotFoundException {
        int updated = this._deliveryStatusRepository.mark(receiverId.toString(), notificationId, Instant.now());
        if (updated == 0) {
            throw new NotificationNotFoundException();
        }
        this._browserPushService.pushNotificationsUpdated(receiverId);
    }

    public void unmarkNotification(UUID notificationId, ProfileId receiverId) throws NotificationNotFoundException {
        int updated = this._deliveryStatusRepository.unmark(receiverId.toString(), notificationId, Instant.now());
        if (updated == 0) {
            throw new NotificationNotFoundException();
        }
        this._browserPushService.pushNotificationsUpdated(receiverId);
    }

    public void moveToOpen(List<UUID> notificationIds, ProfileId receiverId) {
        this._deliveryStatusRepository.setOpen(notificationIds, receiverId.toString(), Instant.now());
        this._browserPushService.pushNotificationsUpdated(receiverId);
    }
}

