/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.business;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import de.justsoftware.notificationclient.model.NotificationMail;
import de.justsoftware.notificationclient.model.NotificationMailItem;
import de.justsoftware.notificationservice.business.ZookeeperService;
import de.justsoftware.notificationservice.model.ClusterPosition;
import de.justsoftware.notificationservice.model.NotificationStatus;
import de.justsoftware.notificationservice.persistence.DeliveryStatusRepository;
import de.justsoftware.notificationservice.persistence.NotificationRepository;
import de.justsoftware.notificationservice.persistence.model.DeliveryStatus;
import de.justsoftware.notificationservice.persistence.model.Notification;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
class NotificationMailService {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationMailService.class);
    private static final String NOTIFICATION_MAIL_CRON = "/just/notification/mailCron";
    private ScheduledFuture<?> _activeNotificationMailCron;
    private final TaskScheduler _taskScheduler;
    private final RestOperations _jucoServiceInternalRestOperations;
    private final ZookeeperService _zookeeperService;
    private final NotificationRepository _notificationRepository;
    private final DeliveryStatusRepository _deliveryStatusRepository;
    private final int _notificationMailReceiverBatchSize;
    private final ClusterPosition _clusterPosition;

    @Autowired
    NotificationMailService(TaskScheduler taskScheduler, @Qualifier(value="JUCO_SERVICE_INTERNAL_REST_OPERATIONS") RestOperations restOperations, ZookeeperService curatorFramework, NotificationRepository notificationRepository, DeliveryStatusRepository deliveryStatusRepository, @Value(value="${service.notificationMailReceiverBatchSize : 100}") int notificationMailReceiverBatchSize, @Value(value="${service.clusterPosition}") ClusterPosition clusterPosition) {
        this._taskScheduler = taskScheduler;
        this._jucoServiceInternalRestOperations = restOperations;
        this._zookeeperService = curatorFramework;
        this._notificationRepository = notificationRepository;
        this._deliveryStatusRepository = deliveryStatusRepository;
        this._notificationMailReceiverBatchSize = notificationMailReceiverBatchSize;
        this._clusterPosition = clusterPosition;
    }

    @PostConstruct
    void afterPropertiesSet() {
        if (this._clusterPosition == ClusterPosition.SLAVE) {
            return;
        }
        this._zookeeperService.addListener("/just/notification/mailCron", () -> this.startMailCron());
        this.startMailCron();
    }

    private void startMailCron() {
        String cronExpression;
        if (this._activeNotificationMailCron != null) {
            this._activeNotificationMailCron.cancel(false);
            LOG.info("Active NotificationMailCron was canceled due to a Zookeeper change.");
        }
        if ((cronExpression = this._zookeeperService.getString("/just/notification/mailCron").orElse("")).isEmpty()) {
            LOG.info("Cron expression is empty. NotificationMailCron won't be started.");
            return;
        }
        try {
            LOG.info("Starting MailCron with {}.", (Object)cronExpression);
            this._activeNotificationMailCron = this._taskScheduler.schedule(() -> this.sendUnreadNotificationMails(), (Trigger)new CronTrigger(cronExpression));
        }
        catch (IllegalArgumentException e) {
            LOG.error("An illegal argument exception was raised. Make sure the supplied cron expression is valid.", (Throwable)e);
        }
    }

    @VisibleForTesting
    void sendNotificationMails(List<NotificationMail> notificationMails) throws RestClientException {
        LOG.info(String.format("Trying to send %d notification mails.", notificationMails.size()));
        ResponseEntity response = this._jucoServiceInternalRestOperations.postForEntity("/notification/mail", notificationMails, Void.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            throw new RestClientException("Failed to send notification mails. Juco Internal REST API returned StatusCode: " + response.getStatusCode().value());
        }
        LOG.info("Successfully sent notification mails.");
    }

    @VisibleForTesting
    void sendUnreadNotificationMails() {
        List receivers = this._deliveryStatusRepository.distinctReceivers();
        Lists.partition((List)receivers, (int)this._notificationMailReceiverBatchSize).forEach(receiverBatch -> {
            List statusBatch = this._deliveryStatusRepository.getStatusWithActiveTriggerForReceivers(receiverBatch);
            Map<String, List<DeliveryStatus>> statusBatchByReceiver = statusBatch.stream().collect(Collectors.groupingBy(DeliveryStatus::getReceiverId));
            ImmutableMap countsBatch = this._deliveryStatusRepository.countByReceiverIdsAndStatus((Set)ImmutableSet.copyOf((Collection)receiverBatch), NotificationStatus.OPEN);
            ImmutableMap notifications = this._notificationRepository.findByIds((Set)statusBatch.stream().map(DeliveryStatus::getNotificationId).collect(ImmutableSet.toImmutableSet()));
            List mails = statusBatchByReceiver.entrySet().stream().map(arg_0 -> NotificationMailService.lambda$sendUnreadNotificationMails$1(notifications, (Map)countsBatch, arg_0)).collect(Collectors.toList());
            try {
                this.sendNotificationMails(mails);
            }
            catch (RestClientException e) {
                LOG.error("An error occurred while sending notification mails", (Throwable)e);
                LOG.warn(String.format("Marking %d mail(s) as sent anyways to prevent repeat spamming of the recipients", statusBatch.size()));
            }
            finally {
                this._deliveryStatusRepository.disableMailTriggers(statusBatch);
            }
        });
    }

    @CheckForNull
    private static NotificationMailItem getNotificationMailItem(Notification notification) {
        if (notification == null) {
            return null;
        }
        return new NotificationMailItem(notification.getAppId(), notification.getDefaultTitle(), notification.getDefaultText(), notification.getTimestamp(), notification.getLocalizedTitle(), notification.getLocalizedText(), notification.getDefaultSecondaryText(), notification.getLocalizedSecondaryText(), notification.getMailAuthorName(), notification.getDefaultMailContainerName(), notification.getLocalizedMailContainerName(), notification.getDefaultMailReplacementText(), notification.getLocalizedMailReplacementText());
    }

    private static /* synthetic */ NotificationMail lambda$sendUnreadNotificationMails$1(ImmutableMap notifications, Map countsBatch, Map.Entry entry) {
        String receiverId = (String)entry.getKey();
        List mailItems = ((List)entry.getValue()).stream().map(ds -> NotificationMailService.getNotificationMailItem((Notification)((Notification)notifications.get((Object)ds.getNotificationId())))).filter((Predicate<NotificationMailItem>)Predicates.notNull()).sorted(Comparator.comparing(NotificationMailItem::getTimestamp).reversed()).collect(Collectors.toList());
        int additionalMailCount = countsBatch.containsKey(receiverId) ? (Integer)countsBatch.get(receiverId) - mailItems.size() : 0;
        return new NotificationMail(receiverId, mailItems, additionalMailCount);
    }
}

