/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.task.controller;

import com.google.common.collect.ImmutableList;
import de.justsoftware.mobile.api.task.model.TaskList;
import de.justsoftware.mobile.api.task.service.TaskMapper;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.common.AuthorizedContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="MobileApiTaskController")
@RequestMapping(value={"/mobile/api/v1/task"})
@ParametersAreNonnullByDefault
@Api(tags={"Task"})
public class TaskController {
    private final TaskMapper _taskMapper;

    @Autowired
    public TaskController(TaskMapper taskMapper) {
        this._taskMapper = taskMapper;
    }

    @GetMapping(value={"/lists"})
    @ApiOperation(value="Returns all lists available for the logged in user", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ImmutableList<TaskList> getTaskLists(@AuthorizedContext AuthorizationContext authCtx) {
        return this._taskMapper.getTaskLists(authCtx);
    }
}

