/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.people.service;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.mobile.api.people.model.PeopleApiProfile;
import de.justsoftware.mobile.api.people.model.Profile;
import de.justsoftware.mobile.api.people.model.ProfileConfiguration;
import de.justsoftware.mobile.api.people.model.ProfileDetails;
import de.justsoftware.mobile.api.people.model.UpdatedProfile;
import de.justsoftware.mobile.api.people.model.UpdatedProfileDetails;
import de.justsoftware.mobile.api.people.model.UpdatedProfileSection;
import de.justsoftware.mobile.api.people.service.PeopleApiGatewayService;
import de.justsoftware.mobile.api.people.service.PeopleMapper;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.ValidatableException;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.model.NameSettings;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.profile.business.ProfileService;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.profile.model.ProfileAttributesConfiguration;
import de.justsoftware.onx.profile.model.ProfileSectionConfiguration;
import de.justsoftware.onx.profile.model.ProfileValidationException;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="MobileApiPeopleService")
@ParametersAreNonnullByDefault
public class PeopleService {
    private final PersonService _personService;
    private final ProfileService _profileService;
    private final ProfileTeaserService _profileTeaserService;
    private final PeopleApiGatewayService _peopleApiGatewayService;
    private final PeopleMapper _peopleMapper;
    private final Settings _settings;

    @Autowired
    public PeopleService(PersonService personService, ProfileService profileService, ProfileTeaserService profileTeaserService, PeopleApiGatewayService peopleApiGatewayService, PeopleMapper peopleMapper, Settings settings) {
        this._personService = personService;
        this._profileService = profileService;
        this._profileTeaserService = profileTeaserService;
        this._peopleApiGatewayService = peopleApiGatewayService;
        this._peopleMapper = peopleMapper;
        this._settings = settings;
    }

    public static boolean mayEditPersonField(String field, ImmutableSet<String> hiddenPersonFields, ImmutableList<String> readOnlyPersonFields) {
        return !hiddenPersonFields.contains((Object)field) && !readOnlyPersonFields.contains((Object)field);
    }

    @CheckForNull
    public ProfileDetails getProfileDetails(ProfileId profileId, AuthorizationContext authContext) {
        PersonId personId = profileId.asPersonId();
        DBPerson dbPerson = this._personService.getPersonById(personId);
        if (dbPerson == null) {
            return null;
        }
        PersonTeaserModel person = this._profileTeaserService.getPersonTeaserModelByDBPerson(dbPerson, (AuthorizationCheckContextWithLocale)authContext);
        if (!person.isVisible()) {
            return null;
        }
        return this._peopleMapper.toProfileDetails(person, dbPerson, authContext);
    }

    public void updateProfile(ProfileId profileId, UpdatedProfile updatedProfile, AuthorizationContext authContext) throws de.justsoftware.mobile.api.people.model.ProfileValidationException, PermissionDeniedException, IllegalArgumentException {
        authContext.check((ItemId)profileId, (Action)StaticAction.PERSON_EDIT);
        UpdatedProfileDetails updatedProfileDetails = updatedProfile.getProfileDetails();
        if (updatedProfileDetails != null) {
            this.updateProfileDetails(profileId, updatedProfileDetails, authContext);
        }
        this.updateProfileSections(profileId, updatedProfile.getProfileSections(), authContext);
    }

    @CheckForNull
    public ProfileConfiguration getProfileConfiguration(ProfileId profileId, AuthorizationContext authContext) {
        if (!authContext.may((ItemId)profileId, (Action)StaticAction.PERSON_EDIT)) {
            return null;
        }
        ProfileAttributesConfiguration config = this._profileService.getVisibleAttributesConfiguration(profileId, (AuthorizationCheckContext)authContext);
        return this._peopleMapper.toProfileConfiguration(profileId, config, authContext);
    }

    @CheckForNull
    public ProfileDetails updateImage(ProfileId profileId, MultipartFile image, AuthorizationContext authCtx) {
        try {
            this._profileService.saveProfileImage(profileId, image, (AuthorizationCheckContext)authCtx);
            return this.getProfileDetails(profileId, authCtx);
        }
        catch (IOException e) {
            throw new ServiceException("Error updating profile image.", (Throwable)e);
        }
    }

    @CheckForNull
    public ProfileDetails deleteImage(ProfileId profileId, AuthorizationContext authCtx) {
        try {
            this._profileService.deleteProfileImage(profileId, (AuthorizationCheckContext)authCtx);
            return this.getProfileDetails(profileId, authCtx);
        }
        catch (ValidatableException | IOException e) {
            throw new ServiceException("Error deleting profile image.", e);
        }
    }

    @Nonnull
    public ImmutableList<Profile> getProfiles(@Nullable String query, int offset, int limit, AuthorizationContext authContext) {
        ImmutableList<PeopleApiProfile> apiProfiles = this._peopleApiGatewayService.getProfiles(authContext.getTenantId(), query, offset, limit);
        return this._peopleMapper.toProfiles(apiProfiles);
    }

    private void updateProfileDetails(ProfileId profileId, UpdatedProfileDetails updatedProfileDetails, AuthorizationContext authContext) throws de.justsoftware.mobile.api.people.model.ProfileValidationException, PermissionDeniedException, IllegalStateException {
        PersonId personId = profileId.asPersonId();
        DBPerson originalProfile = this._personService.getPersonById(personId);
        if (originalProfile == null) {
            throw new IllegalStateException("Trying to update non-existent person with id " + personId);
        }
        this.checkPermissionsForUpdate(profileId, updatedProfileDetails, authContext);
        final String updatedFirstName = updatedProfileDetails.getFirstName();
        final String updatedLastName = updatedProfileDetails.getLastName();
        final String updatedTitle = updatedProfileDetails.getTitle();
        final String updatedAdditionalTitle = updatedProfileDetails.getAdditionalTitle();
        final String originalFirstName = Objects.requireNonNull(originalProfile.getFirstName());
        final String originalLastName = Objects.requireNonNull(originalProfile.getLastName());
        final String originalTitle = originalProfile.getTitle();
        final String originalAdditionalTitle = originalProfile.getAdditionalTitle();
        try {
            this._profileService.updateProfileNameSettings(profileId, new NameSettings(){

                public String getFirstName() {
                    return updatedFirstName != null ? updatedFirstName : originalFirstName;
                }

                public String getLastName() {
                    return updatedLastName != null ? updatedLastName : originalLastName;
                }

                public String getTitle() {
                    return updatedTitle != null ? updatedTitle : originalTitle;
                }

                public String getAdditionalTitle() {
                    return updatedAdditionalTitle != null ? updatedAdditionalTitle : originalAdditionalTitle;
                }
            }, (SearchAuthorizationCheckContext)authContext);
        }
        catch (ValidatableException e) {
            throw new de.justsoftware.mobile.api.people.model.ProfileValidationException(e);
        }
    }

    private void checkPermissionsForUpdate(ProfileId profileId, UpdatedProfileDetails updatedProfileDetails, AuthorizationContext authContext) throws PermissionDeniedException {
        authContext.check((ItemId)profileId, (Action)StaticAction.PERSON_EDIT);
        ImmutableSet hiddenPersonFields = this._settings.getHiddenPersonFields();
        ImmutableList readOnlyPersonFields = this._settings.getModificationRestrictedPersonFields();
        String updatedFirstName = updatedProfileDetails.getFirstName();
        if (!PeopleService.mayEditPersonField("person.firstname", (ImmutableSet<String>)hiddenPersonFields, (ImmutableList<String>)readOnlyPersonFields) && updatedFirstName != null) {
            throw new PermissionDeniedException();
        }
        String updatedLastName = updatedProfileDetails.getLastName();
        if (!PeopleService.mayEditPersonField("person.lastname", (ImmutableSet<String>)hiddenPersonFields, (ImmutableList<String>)readOnlyPersonFields) && updatedLastName != null) {
            throw new PermissionDeniedException();
        }
        String updatedTitle = updatedProfileDetails.getTitle();
        if (!PeopleService.mayEditPersonField("person.title", (ImmutableSet<String>)hiddenPersonFields, (ImmutableList<String>)readOnlyPersonFields) && updatedTitle != null) {
            throw new PermissionDeniedException();
        }
        String updatedAdditionalTitle = updatedProfileDetails.getAdditionalTitle();
        if (!PeopleService.mayEditPersonField("person.additionalTitle", (ImmutableSet<String>)hiddenPersonFields, (ImmutableList<String>)readOnlyPersonFields) && updatedAdditionalTitle != null) {
            throw new PermissionDeniedException();
        }
    }

    private void updateProfileSections(ProfileId profileId, ImmutableList<UpdatedProfileSection> updatedSections, AuthorizationContext authContext) throws de.justsoftware.mobile.api.people.model.ProfileValidationException, PermissionDeniedException {
        if (updatedSections.isEmpty()) {
            return;
        }
        ProfileAttributesConfiguration config = this._profileService.getVisibleAttributesConfiguration(profileId, (AuthorizationCheckContext)authContext);
        try {
            updatedSections.forEach(updatedSection -> {
                String sectionName = updatedSection.getKey();
                ProfileSectionConfiguration sectionConfig = config.getSectionByName(sectionName);
                if (sectionConfig == null) {
                    throw new IllegalArgumentException("Section " + sectionName + " does not exist.");
                }
                this._profileService.updateProfileAttributeSection(profileId, sectionName, this._peopleMapper.toProfileAttributeBlocks(updatedSection.getBlocks(), sectionConfig), (AuthorizationCheckContextWithUserId)authContext);
            });
        }
        catch (ProfileValidationException | IllegalArgumentException e) {
            throw new de.justsoftware.mobile.api.people.model.ProfileValidationException(e);
        }
    }
}

