/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.people.model;

import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.profile.model.ProfileAttributeType;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProfileAttributeConfiguration {
    private final String _key;
    private final ProfileAttributeType _type;
    private final boolean _required;
    private final ProfileAttributePermissions _allowed;
    private final boolean _multiple;
    private final Integer _maxLength;
    private final ImmutableList<String> _allowedValues;

    public ProfileAttributeConfiguration(String key, ProfileAttributeType type, boolean required, boolean mayEdit, boolean multiple, Integer maxLength, ImmutableList<String> allowedValues) {
        this._key = key;
        this._type = type;
        this._required = required;
        this._allowed = new ProfileAttributePermissions(mayEdit);
        this._multiple = multiple;
        this._maxLength = maxLength;
        this._allowedValues = allowedValues;
    }

    @Nonnull
    public String getKey() {
        return this._key;
    }

    @Nonnull
    public ProfileAttributeType getType() {
        return this._type;
    }

    public boolean isRequired() {
        return this._required;
    }

    @Nonnull
    public ProfileAttributePermissions getAllowed() {
        return this._allowed;
    }

    @CheckForNull
    public Integer getMaxLength() {
        return this._maxLength;
    }

    public boolean isMultiple() {
        return this._multiple;
    }

    @CheckForNull
    public ImmutableList<String> getAllowedValues() {
        return this._allowedValues;
    }

    public static final class ProfileAttributePermissions {
        private final boolean _edit;

        public ProfileAttributePermissions(boolean mayEdit) {
            this._edit = mayEdit;
        }

        public boolean isEdit() {
            return this._edit;
        }
    }
}

