/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.people.controller;

import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import de.justsoftware.mobile.api.common.JustMobileApiIdCustomEditors;
import de.justsoftware.mobile.api.common.utils.Responses;
import de.justsoftware.mobile.api.people.model.Profile;
import de.justsoftware.mobile.api.people.model.ProfileConfiguration;
import de.justsoftware.mobile.api.people.model.ProfileDetails;
import de.justsoftware.mobile.api.people.model.ProfileValidationException;
import de.justsoftware.mobile.api.people.model.UpdatedProfile;
import de.justsoftware.mobile.api.people.service.PeopleService;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.common.AuthorizedContext;
import de.justsoftware.onx.common.shared.model.ProfileId;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(value={"/mobile/api/v1/people"})
@Api(tags={"People"})
public class PeopleController
extends JustMobileApiIdCustomEditors {
    private final PeopleService _peopleService;

    @Autowired
    public PeopleController(PeopleService peopleService) {
        this._peopleService = peopleService;
    }

    @GetMapping
    @ApiOperation(value="Returns all profiles matching the search query.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<List<Profile>> getProfiles(@Nullable @RequestParam(value="query", required=false) String query, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="20") int limit, @AuthorizedContext AuthorizationContext authContext) {
        return Responses.okOrNotFound(this._peopleService.getProfiles(query, offset, limit, authContext));
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="Returns the profile with the given id.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<ProfileDetails> getProfile(@PathVariable(value="id") ProfileId profileId, @AuthorizedContext AuthorizationContext authContext) {
        return Responses.okOrNotFound(this._peopleService.getProfileDetails(profileId, authContext));
    }

    @PutMapping(path={"/{id}"}, headers={"content-type=application/json"}, consumes={"application/json"})
    @ApiOperation(value="Updates base data and profile attributes.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<ProfileDetails> updateProfile(@PathVariable(value="id") ProfileId profileId, @RequestBody UpdatedProfile updatedProfile, @AuthorizedContext AuthorizationContext authContext) throws ProfileValidationException, PermissionDeniedException {
        this._peopleService.updateProfile(profileId, updatedProfile, authContext);
        return this.getProfile(profileId, authContext);
    }

    @PostMapping(value={"/{id}/image"}, headers={"content-type=multipart/*"}, produces={"application/json"})
    @ApiOperation(value="Updates the user's profile image with the uploaded image.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<ProfileDetails> updateImage(@PathVariable(value="id") ProfileId profileId, @RequestPart(value="image") MultipartFile image, @AuthorizedContext AuthorizationContext authCtx) {
        return Responses.okOrNotFound(this._peopleService.updateImage(profileId, image, authCtx));
    }

    @DeleteMapping(value={"/{id}/image"}, produces={"application/json"})
    @ApiOperation(value="Deletes the user's profile image.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<ProfileDetails> deleteImage(@PathVariable(value="id") ProfileId profileId, @AuthorizedContext AuthorizationContext authCtx) {
        return Responses.okOrNotFound(this._peopleService.deleteImage(profileId, authCtx));
    }

    @GetMapping(value={"/{id}/configuration"})
    @ApiOperation(value="Returns the profile configuration for the profile with the given id.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<ProfileConfiguration> getProfileConfiguration(@PathVariable(value="id") ProfileId profileId, @AuthorizedContext AuthorizationContext authContext) {
        return Responses.okOrNotFound(this._peopleService.getProfileConfiguration(profileId, authContext));
    }
}

