/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.notifications.controller;

import de.justsoftware.mobile.api.notifications.model.NotificationsCount;
import de.justsoftware.mobile.api.notifications.service.NotificationsApiGatewayService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(value={"/mobile/api/v1/notifications"})
@Api(tags={"Notifications"})
public class NotificationsController {
    private final NotificationsApiGatewayService _apiGatewayService;

    @Autowired
    public NotificationsController(NotificationsApiGatewayService apiGatewayService) {
        this._apiGatewayService = apiGatewayService;
    }

    @GetMapping(path={"/count"}, produces={"application/json"})
    @ApiOperation(value="Returns the number of open and archived notifications.", authorizations={@Authorization(value="oauth2")})
    @Nonnull
    public ResponseEntity<NotificationsCount> getNotificationsCount() {
        return this._apiGatewayService.notificationsCount();
    }
}

