/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.legacy.service;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.freiheit.toro.common.shared.server.util.DateUtil;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import de.justsoftware.mobile.api.legacy.model.Entity;
import de.justsoftware.mobile.api.legacy.model.EntityAttribute;
import de.justsoftware.mobile.api.legacy.model.EntityAttributeType;
import de.justsoftware.mobile.api.legacy.model.EntityEventData;
import de.justsoftware.mobile.api.legacy.model.EntityHtmlContent;
import de.justsoftware.mobile.api.legacy.model.EntityWiki;
import de.justsoftware.mobile.api.legacy.model.EventAttendanceStatus;
import de.justsoftware.mobile.api.people.model.Profile;
import de.justsoftware.mobile.api.people.service.PeopleMapper;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.shared.i18n.EntityTranslationUtil;
import de.justsoftware.onx.common.shared.model.ComponentModel;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.TimeZone;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.common.shared.model.attributes.DynamicEntityAttributesMessages;
import de.justsoftware.onx.common.shared.model.attributes.PersonSuggestInput;
import de.justsoftware.onx.common.shared.model.attributes.SelectOptionMessage;
import de.justsoftware.onx.common.shared.model.attributes.SelectionInput;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.EntityDynamicAttributeClientModel;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.Identifiable;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.like.business.LikeService;
import de.justsoftware.onx.like.shared.model.SubscriptionState;
import de.justsoftware.onx.like.shared.model.SubscriptionStatus;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiClientModel;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.raweditor.shared.model.RawEditorVersion;
import de.justsoftware.onx.raweditor.shared.model.db.DBRawEditorVersion;
import de.justsoftware.onx.searchnew.shared.model.EntitySearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.FederatedSearchResultEntry;
import de.justsoftware.onx.searchnew.shared.model.SearchResult;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditor;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="MobileApiLegacyMapper")
@ParametersAreNonnullByDefault
public class LegacyMapper {
    private static final ImmutableList<StaticComponentType> RAW_EDITORS = ImmutableList.of((Object)StaticComponentType.RAW_EDITOR1, (Object)StaticComponentType.RAW_EDITOR2, (Object)StaticComponentType.RAW_EDITOR3, (Object)StaticComponentType.RAW_EDITOR4);
    private final EntityMemberService _entityMemberService;
    private final EntityConfigService _entityConfigService;
    private final ProfileTeaserService _profileTeaserService;
    private final LikeService _likeService;
    private final I18nService _i18nService;
    private final PeopleMapper _peopleMapper;

    @Autowired
    public LegacyMapper(EntityMemberService entityMemberService, EntityConfigService entityConfigService, ProfileTeaserService profileTeaserService, LikeService likeService, I18nService i18nService, PeopleMapper peopleMapper) {
        this._entityMemberService = entityMemberService;
        this._entityConfigService = entityConfigService;
        this._profileTeaserService = profileTeaserService;
        this._likeService = likeService;
        this._i18nService = i18nService;
        this._peopleMapper = peopleMapper;
    }

    @Nonnull
    public ImmutableList<Entity> toEntities(SearchResult<FederatedSearchResultEntry> searchResult, AuthorizationContext authContext) {
        ImmutableSet resultEntities = (ImmutableSet)searchResult.getResults().stream().filter(EntitySearchResultBadgeModel.class::isInstance).map(result -> (EntitySearchResultBadgeModel)result).collect(ImmutableSet.toImmutableSet());
        ImmutableSet entityIds = (ImmutableSet)resultEntities.stream().map(Identifiable::getId).collect(ImmutableSet.toImmutableSet());
        ImmutableMap subscriptions = this._likeService.getExplicitSubscriptionStatus((Iterable)entityIds, (AuthorizationCheckContextWithUserId)authContext);
        return (ImmutableList)resultEntities.stream().map(entityInfo -> this.toEntity((EntityInfo)entityInfo, (SubscriptionStatus)subscriptions.get(entityInfo.getId()), authContext)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public de.justsoftware.mobile.api.legacy.model.EntityDetails toEntityDetails(EntityDetails legacyEntityDetails, AuthorizationContext authContext) {
        EntityId id = legacyEntityDetails.getId();
        ImmutableMap subscriptions = this._likeService.getExplicitSubscriptionStatus((Iterable)ImmutableSet.of((Object)id), (AuthorizationCheckContextWithUserId)authContext);
        boolean hasFeed = legacyEntityDetails.getComponents().containsKey((Object)StaticComponentType.WORKSTREAM);
        ImmutableList<EntityAttribute<?>> attributes = this.getEntityAttributes(legacyEntityDetails, authContext);
        EntityWiki wiki = LegacyMapper.getEntityWiki(legacyEntityDetails);
        EntityHtmlContent htmlContent = LegacyMapper.getEntityHtmlContent(legacyEntityDetails);
        return new de.justsoftware.mobile.api.legacy.model.EntityDetails(this.toEntity((EntityInfo)legacyEntityDetails, (SubscriptionStatus)subscriptions.get((Object)id), authContext), hasFeed, attributes, wiki, htmlContent);
    }

    @Nonnull
    public de.justsoftware.mobile.api.legacy.model.EntityDetails toFallbackEntityDetails(EntityInfo legacyEntityInfo, AuthorizationContext authContext) {
        return new de.justsoftware.mobile.api.legacy.model.EntityDetails(this.toEntity(legacyEntityInfo, null, authContext));
    }

    @Nonnull
    public de.justsoftware.mobile.api.legacy.model.EntityType toEntityType(EntityType legacyEntityType) {
        return new de.justsoftware.mobile.api.legacy.model.EntityType(legacyEntityType.getName());
    }

    @Nonnull
    public EntityType toLegacyEntityType(de.justsoftware.mobile.api.legacy.model.EntityType entityType) {
        return EntityType.valueOf((String)entityType.getName());
    }

    @Nonnull
    private ImmutableList<EntityAttribute<?>> getEntityAttributes(EntityDetails legacyEntityDetails, AuthorizationContext authContext) {
        ImmutableMap attributeConfigs = Maps.uniqueIndex((Iterable)this._entityConfigService.getDynamicAttributesForType(legacyEntityDetails.getType()), (Function)DynamicAttributeConfig.GET_NAME);
        return (ImmutableList)legacyEntityDetails.getDBEntity().getDynamicAttributes().stream().map(legacyAttribute -> this.toEntityAttribute((EntityDynamicAttributeClientModel)legacyAttribute, (DynamicAttributeConfig)attributeConfigs.get((Object)legacyAttribute.getAttributeId().getId()), legacyEntityDetails.getType(), authContext)).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    @CheckForNull
    private EntityAttribute<?> toEntityAttribute(EntityDynamicAttributeClientModel legacyAttribute, @Nullable DynamicAttributeConfig config, EntityType legacyEntityType, AuthorizationContext authContext) {
        if (config == null) {
            return null;
        }
        DynamicAttributeId attributeId = legacyAttribute.getAttributeId();
        ImmutableList legacyValues = legacyAttribute.getValues();
        DynamicEntityAttributesMessages labelTranslations = (DynamicEntityAttributesMessages)this._i18nService.createProxy(DynamicEntityAttributesMessages.class, EntityTranslationUtil.getEntityTypeAttributesKeyPart((EntityType)legacyEntityType, (DynamicAttributeId)attributeId), authContext.getLocale());
        String label = labelTranslations.name(attributeId);
        boolean translateValues = LegacyMapper.shouldTranslateValues(config);
        EntityAttributeType attributeType = LegacyMapper.getAttributeType(config);
        ImmutableList<?> values = this.getEntityValues((ImmutableList<String>)legacyValues, attributeId, attributeType, legacyEntityType, translateValues, authContext);
        return new EntityAttribute(attributeId.getId(), label, values, attributeType);
    }

    @Nonnull
    private ImmutableList<?> getEntityValues(ImmutableList<String> legacyValues, DynamicAttributeId attributeId, EntityAttributeType attributeType, EntityType legacyEntityType, boolean translateValues, AuthorizationContext authContext) {
        if (attributeType != EntityAttributeType.PROFILE) {
            return translateValues ? this.toTranslatedValues(legacyValues, attributeId, legacyEntityType, authContext) : legacyValues;
        }
        return this.toProfileValues(legacyValues, authContext);
    }

    @Nonnull
    private ImmutableList<Profile> toProfileValues(ImmutableList<String> legacyValues, AuthorizationContext authContext) {
        ImmutableSet personIds = (ImmutableSet)legacyValues.stream().map(PersonId::parse).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        ImmutableMap personTeasers = this._profileTeaserService.getPersonTeaserForUserWithFullNames((Set)personIds, (AuthorizationCheckContextWithLocale)authContext);
        return (ImmutableList)personIds.stream().map(arg_0 -> ((ImmutableMap)personTeasers).get(arg_0)).filter(Objects::nonNull).map(this._peopleMapper::toProfile).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private ImmutableList<String> toTranslatedValues(ImmutableList<String> legacyValues, DynamicAttributeId attributeId, EntityType legacyEntityType, AuthorizationContext authContext) {
        return (ImmutableList)legacyValues.stream().map(value -> ((SelectOptionMessage)this._i18nService.createProxy(SelectOptionMessage.class, EntityTranslationUtil.getDynamicOptionTranslationKey((EntityType)legacyEntityType, (DynamicAttributeId)attributeId, (String)value), authContext.getLocale())).name(value)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private static EntityAttributeType getAttributeType(DynamicAttributeConfig config) {
        return config.getInput() instanceof PersonSuggestInput ? EntityAttributeType.PROFILE : EntityAttributeType.HTML;
    }

    private static boolean shouldTranslateValues(DynamicAttributeConfig config) {
        return config.getInput() instanceof SelectionInput;
    }

    @Nonnull
    private Entity toEntity(EntityInfo legacyEntityInfo, @Nullable SubscriptionStatus subscriptionStatus, AuthorizationContext authContext) {
        SubscriptionState state = subscriptionStatus != null ? subscriptionStatus.getState() : SubscriptionState.UNSUBSCRIBED;
        boolean notificationsEnabled = state.isSubscribed() && !state.isBlockMail();
        EntityId legacyEntityId = (EntityId)legacyEntityInfo.getId();
        EntityMemberWithPerson memberInfo = (EntityMemberWithPerson)this._entityMemberService.getEntityMembersMappedByEntityId(legacyEntityId).get((Object)authContext.getUserId());
        ImmutableSet memberRoles = memberInfo != null ? memberInfo.getRoles() : ImmutableSet.of();
        boolean isMember = EntityMemberRoles.isMember((Set)memberRoles);
        boolean hasInvitation = EntityMemberRoles.hasInvitation((Set)memberRoles);
        return new Entity(legacyEntityId, legacyEntityInfo.getName(), this.toEntityType((EntityType)legacyEntityInfo.getType()), state.isSubscribed(), notificationsEnabled, authContext.may((ItemId)legacyEntityId, (Action)StaticEntityAction.ENTITY_JOIN), authContext.may((ItemId)legacyEntityId, (Action)StaticEntityAction.ENTITY_LEAVE), isMember, hasInvitation, this.getEventData(legacyEntityInfo, (ImmutableSet<EntityMemberRole>)memberRoles, authContext));
    }

    @Nonnull
    private EventAttendanceStatus toEventAttendanceStatus(ImmutableSet<EntityMemberRole> roles) {
        if (EntityMemberRoles.isAttendingEvent(roles)) {
            return EventAttendanceStatus.ATTENDING;
        }
        if (EntityMemberRoles.isNotAttendingEvent(roles)) {
            return EventAttendanceStatus.NOT_ATTENDING;
        }
        if (EntityMemberRoles.isMaybeAttendingEvent(roles)) {
            return EventAttendanceStatus.MAYBE_ATTENDING;
        }
        return EventAttendanceStatus.NONE;
    }

    @CheckForNull
    private EntityEventData getEventData(EntityInfo legacyEntityInfo, ImmutableSet<EntityMemberRole> roles, AuthorizationContext authContext) {
        Date startAt = DateUtil.normalizeDateWithoutTimezone((DateWithoutTimezone)legacyEntityInfo.getStartAt(), (TimeZone)legacyEntityInfo.getTimeZone());
        Date endAt = DateUtil.normalizeDateWithoutTimezone((DateWithoutTimezone)legacyEntityInfo.getEndAt(), (TimeZone)legacyEntityInfo.getTimeZone());
        EventAttendanceStatus attendanceStatus = this.toEventAttendanceStatus(roles);
        boolean mayChangeAttendance = authContext.may((ItemId)legacyEntityInfo.getId(), ImmutableSet.of((Object)StaticEntityAction.EVENT_ATTEND, (Object)StaticEntityAction.EVENT_DONT_ATTEND, (Object)StaticEntityAction.EVENT_MAYBE_ATTEND)).size() > 0;
        return startAt == null || endAt == null ? null : new EntityEventData(startAt, endAt, legacyEntityInfo.getLocation(), mayChangeAttendance, attendanceStatus);
    }

    @CheckForNull
    private static EntityWiki getEntityWiki(EntityDetails legacyEntityDetails) {
        ImmutableList articles = new ImmutableList.Builder().addAll(LegacyMapper.getArticlesFromMultiWiki(legacyEntityDetails)).addAll(LegacyMapper.getArticlesFromWikiEditor(legacyEntityDetails)).build();
        return articles.isEmpty() ? null : new EntityWiki((ImmutableList<EntityWiki.Article>)articles);
    }

    @CheckForNull
    private static EntityHtmlContent getEntityHtmlContent(EntityDetails legacyEntityDetails) {
        ImmutableList items = (ImmutableList)RAW_EDITORS.stream().map(type -> (ComponentModel)legacyEntityDetails.getComponents().get(type)).filter(Objects::nonNull).map(rawEditorComponent -> (RawEditorVersion)rawEditorComponent.getModuleData()).filter(Objects::nonNull).map(DBRawEditorVersion::getText).collect(ImmutableList.toImmutableList());
        return items.isEmpty() ? null : new EntityHtmlContent((ImmutableList<String>)items);
    }

    @Nonnull
    private static ImmutableList<EntityWiki.Article> getArticlesFromMultiWiki(EntityDetails legacyEntityDetails) {
        ComponentModel multiWikiComponent = (ComponentModel)legacyEntityDetails.getComponents().get((Object)StaticComponentType.MULTI_WIKI);
        if (multiWikiComponent == null) {
            return ImmutableList.of();
        }
        MultiWikiClientModel multiWikiData = (MultiWikiClientModel)multiWikiComponent.getModuleData();
        if (multiWikiData == null) {
            return ImmutableList.of();
        }
        return (ImmutableList)multiWikiData.getSections().stream().map(section -> new EntityWiki.Article(section.getHeadline(), section.getText())).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private static ImmutableList<EntityWiki.Article> getArticlesFromWikiEditor(EntityDetails legacyEntityDetails) {
        ComponentModel wikiEditorComponent = (ComponentModel)legacyEntityDetails.getComponents().get((Object)StaticComponentType.WIKI_EDITOR);
        if (wikiEditorComponent == null) {
            return ImmutableList.of();
        }
        WikiEditor wikiEditorData = (WikiEditor)wikiEditorComponent.getModuleData();
        if (wikiEditorData == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)new EntityWiki.Article(wikiEditorData.getCurrentVersion().getText()));
    }
}

