/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.feed.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.mobile.api.feed.model.Post;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.shared.model.ItemId;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Feed {
    private final ItemId _id;
    private final ImmutableList<Post> _posts;
    private final FeedPermissions _allowed;

    public Feed(ItemId id, ImmutableList<Post> posts, ImmutableSet<Action> permissions) {
        this(id, posts, new FeedPermissions(permissions.contains((Object)StaticAction.WORKSTREAM_POST), permissions.contains((Object)StaticAction.WORKSTREAM_PIN)));
    }

    public Feed(ItemId id, ImmutableList<Post> posts, FeedPermissions allowed) {
        this._id = id;
        this._posts = posts;
        this._allowed = allowed;
    }

    @Nonnull
    public ItemId getId() {
        return this._id;
    }

    @Nonnull
    public ImmutableList<Post> getPosts() {
        return this._posts;
    }

    @Nonnull
    public FeedPermissions getAllowed() {
        return this._allowed;
    }

    static class FeedPermissions {
        private final boolean _create;
        private final boolean _pin;

        FeedPermissions(boolean create, boolean pin) {
            this._create = create;
            this._pin = pin;
        }

        public boolean isPin() {
            return this._pin;
        }

        public boolean isCreate() {
            return this._create;
        }
    }
}

