/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.NotLoggedInException;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.freiheit.toro.common.shared.model.ValidationException;
import de.justsoftware.mobile.api.common.model.ApiGatewayException;
import de.justsoftware.mobile.api.common.model.JustMobileError;
import de.justsoftware.mobile.api.people.model.ProfileValidationException;
import de.justsoftware.onx.validation.shared.model.JucoConstraintViolationException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice(basePackages={"de.justsoftware.mobile.api"})
@ParametersAreNonnullByDefault
public class JustMobileExceptionHandlingControllerAdvice {
    private static final Logger LOG = LoggerFactory.getLogger(JustMobileExceptionHandlingControllerAdvice.class);
    private final ObjectMapper _objectMapper;

    @Autowired
    public JustMobileExceptionHandlingControllerAdvice(ObjectMapper objectMapper) {
        this._objectMapper = objectMapper;
    }

    @ExceptionHandler(value={PermissionDeniedException.class, NotLoggedInException.class, BadCredentialsException.class})
    @Nonnull
    public ResponseEntity<JustMobileError> handleForbidden(Throwable t) {
        LOG.error("Permission denied", t);
        return this.createJustMobileError(t, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={AuthenticationException.class})
    @Nonnull
    public ResponseEntity<JustMobileError> handleUnauthorized(AuthenticationException t) {
        LOG.error("Authentication denied", (Throwable)t);
        return this.createJustMobileError((Throwable)t, HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @Nonnull
    public ResponseEntity<JustMobileError> handleHttpMessageNotReadable(Throwable t) {
        LOG.error("Invalid HTTP message", t);
        return this.createJustMobileError(t, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ServiceException.class, JucoConstraintViolationException.class, IllegalStateException.class, ValidationException.class})
    @Nonnull
    public ResponseEntity<JustMobileError> handleServiceExceptions(Throwable t) {
        LOG.error("Exception in service call", t);
        return this.createJustMobileError(t, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ProfileValidationException.class})
    @Nonnull
    public ResponseEntity<JustMobileError> handleProfileValidationError(Throwable t) {
        LOG.error("Profile validation error", t);
        return this.createJustMobileError(t, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={InvalidIdServiceException.class})
    @Nonnull
    public ResponseEntity<JustMobileError> handleNotFound(InvalidIdServiceException t) {
        LOG.error("Resource not found", (Throwable)t);
        return this.createJustMobileError((Throwable)t, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={ApiGatewayException.class})
    @Nonnull
    public ResponseEntity<JustMobileError> handleApiGatewayHttpError(ApiGatewayException t) {
        HttpStatus statusCode = t.getStatusCode();
        LOG.error("HTTP error " + statusCode + " in API gateway call", (Throwable)t);
        return this.createJustMobileError(t, statusCode);
    }

    @ExceptionHandler(value={Throwable.class})
    @Nonnull
    public ResponseEntity<JustMobileError> handleInternalServerError(Throwable t) {
        LOG.error("Some unexpected error happened: ", t);
        return this.createJustMobileError(t, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @Nonnull
    private ResponseEntity<JustMobileError> createJustMobileError(Throwable t, HttpStatus status) {
        JustMobileError error = new JustMobileError(this._objectMapper, t.getClass().getSimpleName() + ": " + t.getMessage());
        return new ResponseEntity((Object)error, status);
    }
}

