/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.api.app.service;

import de.justsoftware.mobile.api.common.model.ApiGatewayException;
import de.justsoftware.mobile.api.common.utils.Responses;
import de.justsoftware.onx.storage.business.StorageServerService;
import de.justsoftware.onx.thumbor.business.ThumborService;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@Service
@ParametersAreNonnullByDefault
public class AppIconApiGatewayService {
    private static final Logger LOG = LoggerFactory.getLogger(AppIconApiGatewayService.class);
    private final RestTemplate _restTemplate;
    private final StorageServerService _storageServerService;
    private final ThumborService _thumborService;

    @Autowired
    public AppIconApiGatewayService(StorageServerService storageServerService, ThumborService thumborService) {
        this._storageServerService = storageServerService;
        this._thumborService = thumborService;
        this._restTemplate = new RestTemplate();
    }

    @Nonnull
    public ResponseEntity<Resource> appIcon(String iconPath) {
        String url = this.absoluteAppIconUrl(iconPath);
        return this.sendGet(url);
    }

    @Nonnull
    private String absoluteAppIconUrl(String iconPath) {
        String absoluteIconUrl = this._storageServerService.absoluteInternalUrl(iconPath);
        if (!iconPath.toLowerCase(Locale.ENGLISH).endsWith(".svg")) {
            return absoluteIconUrl;
        }
        try {
            String thumborIconUrl = this._thumborService.getPngForSvgUrl(absoluteIconUrl, 240, 240);
            return thumborIconUrl != null ? thumborIconUrl : absoluteIconUrl;
        }
        catch (MalformedURLException e) {
            return absoluteIconUrl;
        }
    }

    @Nonnull
    private ResponseEntity<Resource> sendGet(String url) {
        try {
            URI uri = new URI(url);
            return AppIconApiGatewayService.wrapHttpErrors(() -> this._restTemplate.getForEntity(uri, Resource.class));
        }
        catch (URISyntaxException e) {
            LOG.error("Invalid URL for loading app icon: " + url, (Throwable)e);
            return Responses.internalServerError();
        }
    }

    @Nonnull
    private static <R> R wrapHttpErrors(Supplier<R> apiCall) {
        try {
            return apiCall.get();
        }
        catch (HttpStatusCodeException e) {
            throw new ApiGatewayException(e);
        }
    }
}

