/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.utils.ConfigUtils;
import org.apache.kafka.connect.mirror.ConfigPropertyFilter;
import org.apache.kafka.connect.mirror.DefaultConfigPropertyFilter;
import org.apache.kafka.connect.mirror.DefaultGroupFilter;
import org.apache.kafka.connect.mirror.DefaultTopicFilter;
import org.apache.kafka.connect.mirror.GroupFilter;
import org.apache.kafka.connect.mirror.MirrorClientConfig;
import org.apache.kafka.connect.mirror.MirrorUtils;
import org.apache.kafka.connect.mirror.ReplicationPolicy;
import org.apache.kafka.connect.mirror.TopicFilter;
import org.apache.kafka.connect.runtime.ConnectorConfig;

public class MirrorConnectorConfig
extends AbstractConfig {
    protected static final String ENABLED_SUFFIX = ".enabled";
    protected static final String INTERVAL_SECONDS_SUFFIX = ".interval.seconds";
    protected static final String REFRESH_TOPICS = "refresh.topics";
    protected static final String REFRESH_GROUPS = "refresh.groups";
    protected static final String SYNC_TOPIC_CONFIGS = "sync.topic.configs";
    protected static final String SYNC_TOPIC_ACLS = "sync.topic.acls";
    protected static final String EMIT_HEARTBEATS = "emit.heartbeats";
    protected static final String EMIT_CHECKPOINTS = "emit.checkpoints";
    protected static final String SYNC_GROUP_OFFSETS = "sync.group.offsets";
    public static final String ENABLED = "enabled";
    private static final String ENABLED_DOC = "Whether to replicate source->target.";
    public static final String SOURCE_CLUSTER_ALIAS = "source.cluster.alias";
    private static final String SOURCE_CLUSTER_ALIAS_DOC = "Alias of source cluster";
    public static final String TARGET_CLUSTER_ALIAS = "target.cluster.alias";
    public static final String TARGET_CLUSTER_ALIAS_DEFAULT = "target";
    private static final String TARGET_CLUSTER_ALIAS_DOC = "Alias of target cluster. Used in metrics reporting.";
    public static final String REPLICATION_POLICY_CLASS = "replication.policy.class";
    public static final Class<?> REPLICATION_POLICY_CLASS_DEFAULT = MirrorClientConfig.REPLICATION_POLICY_CLASS_DEFAULT;
    private static final String REPLICATION_POLICY_CLASS_DOC = "Class which defines the remote topic naming convention.";
    public static final String REPLICATION_POLICY_SEPARATOR = "replication.policy.separator";
    private static final String REPLICATION_POLICY_SEPARATOR_DOC = "Separator used in remote topic naming convention.";
    public static final String REPLICATION_POLICY_SEPARATOR_DEFAULT = ".";
    public static final String REPLICATION_FACTOR = "replication.factor";
    private static final String REPLICATION_FACTOR_DOC = "Replication factor for newly created remote topics.";
    public static final int REPLICATION_FACTOR_DEFAULT = 2;
    public static final String TOPICS = "topics";
    public static final String TOPICS_DEFAULT = ".*";
    private static final String TOPICS_DOC = "Topics to replicate. Supports comma-separated topic names and regexes.";
    public static final String TOPICS_EXCLUDE = "topics.exclude";
    public static final String TOPICS_EXCLUDE_ALIAS = "topics.blacklist";
    public static final String TOPICS_EXCLUDE_DEFAULT = ".*[\\-\\.]internal, .*\\.replica, __.*";
    private static final String TOPICS_EXCLUDE_DOC = "Excluded topics. Supports comma-separated topic names and regexes. Excludes take precedence over includes.";
    public static final String GROUPS = "groups";
    public static final String GROUPS_DEFAULT = ".*";
    private static final String GROUPS_DOC = "Consumer groups to replicate. Supports comma-separated group IDs and regexes.";
    public static final String GROUPS_EXCLUDE = "groups.exclude";
    public static final String GROUPS_EXCLUDE_ALIAS = "groups.blacklist";
    public static final String GROUPS_EXCLUDE_DEFAULT = "console-consumer-.*, connect-.*, __.*";
    private static final String GROUPS_EXCLUDE_DOC = "Exclude groups. Supports comma-separated group IDs and regexes. Excludes take precedence over includes.";
    public static final String CONFIG_PROPERTIES_EXCLUDE = "config.properties.exclude";
    public static final String CONFIG_PROPERTIES_EXCLUDE_ALIAS = "config.properties.blacklist";
    public static final String CONFIG_PROPERTIES_EXCLUDE_DEFAULT = "follower\\.replication\\.throttled\\.replicas, leader\\.replication\\.throttled\\.replicas, message\\.timestamp\\.difference\\.max\\.ms, message\\.timestamp\\.type, unclean\\.leader\\.election\\.enable, min\\.insync\\.replicas";
    private static final String CONFIG_PROPERTIES_EXCLUDE_DOC = "Topic config properties that should not be replicated. Supports comma-separated property names and regexes.";
    public static final String HEARTBEATS_TOPIC_REPLICATION_FACTOR = "heartbeats.topic.replication.factor";
    public static final String HEARTBEATS_TOPIC_REPLICATION_FACTOR_DOC = "Replication factor for heartbeats topic.";
    public static final short HEARTBEATS_TOPIC_REPLICATION_FACTOR_DEFAULT = 3;
    public static final String CHECKPOINTS_TOPIC_REPLICATION_FACTOR = "checkpoints.topic.replication.factor";
    public static final String CHECKPOINTS_TOPIC_REPLICATION_FACTOR_DOC = "Replication factor for checkpoints topic.";
    public static final short CHECKPOINTS_TOPIC_REPLICATION_FACTOR_DEFAULT = 3;
    public static final String OFFSET_SYNCS_TOPIC_REPLICATION_FACTOR = "offset-syncs.topic.replication.factor";
    public static final String OFFSET_SYNCS_TOPIC_REPLICATION_FACTOR_DOC = "Replication factor for offset-syncs topic.";
    public static final short OFFSET_SYNCS_TOPIC_REPLICATION_FACTOR_DEFAULT = 3;
    protected static final String TASK_TOPIC_PARTITIONS = "task.assigned.partitions";
    protected static final String TASK_CONSUMER_GROUPS = "task.assigned.groups";
    public static final String CONSUMER_POLL_TIMEOUT_MILLIS = "consumer.poll.timeout.ms";
    private static final String CONSUMER_POLL_TIMEOUT_MILLIS_DOC = "Timeout when polling source cluster.";
    public static final long CONSUMER_POLL_TIMEOUT_MILLIS_DEFAULT = 1000L;
    public static final String ADMIN_TASK_TIMEOUT_MILLIS = "admin.timeout.ms";
    private static final String ADMIN_TASK_TIMEOUT_MILLIS_DOC = "Timeout for administrative tasks, e.g. detecting new topics.";
    public static final long ADMIN_TASK_TIMEOUT_MILLIS_DEFAULT = 60000L;
    public static final String REFRESH_TOPICS_ENABLED = "refresh.topics.enabled";
    private static final String REFRESH_TOPICS_ENABLED_DOC = "Whether to periodically check for new topics and partitions.";
    public static final boolean REFRESH_TOPICS_ENABLED_DEFAULT = true;
    public static final String REFRESH_TOPICS_INTERVAL_SECONDS = "refresh.topics.interval.seconds";
    private static final String REFRESH_TOPICS_INTERVAL_SECONDS_DOC = "Frequency of topic refresh.";
    public static final long REFRESH_TOPICS_INTERVAL_SECONDS_DEFAULT = 600L;
    public static final String REFRESH_GROUPS_ENABLED = "refresh.groups.enabled";
    private static final String REFRESH_GROUPS_ENABLED_DOC = "Whether to periodically check for new consumer groups.";
    public static final boolean REFRESH_GROUPS_ENABLED_DEFAULT = true;
    public static final String REFRESH_GROUPS_INTERVAL_SECONDS = "refresh.groups.interval.seconds";
    private static final String REFRESH_GROUPS_INTERVAL_SECONDS_DOC = "Frequency of group refresh.";
    public static final long REFRESH_GROUPS_INTERVAL_SECONDS_DEFAULT = 600L;
    public static final String SYNC_TOPIC_CONFIGS_ENABLED = "sync.topic.configs.enabled";
    private static final String SYNC_TOPIC_CONFIGS_ENABLED_DOC = "Whether to periodically configure remote topics to match their corresponding upstream topics.";
    public static final boolean SYNC_TOPIC_CONFIGS_ENABLED_DEFAULT = true;
    public static final String SYNC_TOPIC_CONFIGS_INTERVAL_SECONDS = "sync.topic.configs.interval.seconds";
    private static final String SYNC_TOPIC_CONFIGS_INTERVAL_SECONDS_DOC = "Frequency of topic config sync.";
    public static final long SYNC_TOPIC_CONFIGS_INTERVAL_SECONDS_DEFAULT = 600L;
    public static final String SYNC_TOPIC_ACLS_ENABLED = "sync.topic.acls.enabled";
    private static final String SYNC_TOPIC_ACLS_ENABLED_DOC = "Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.";
    public static final boolean SYNC_TOPIC_ACLS_ENABLED_DEFAULT = true;
    public static final String SYNC_TOPIC_ACLS_INTERVAL_SECONDS = "sync.topic.acls.interval.seconds";
    private static final String SYNC_TOPIC_ACLS_INTERVAL_SECONDS_DOC = "Frequency of topic ACL sync.";
    public static final long SYNC_TOPIC_ACLS_INTERVAL_SECONDS_DEFAULT = 600L;
    public static final String EMIT_HEARTBEATS_ENABLED = "emit.heartbeats.enabled";
    private static final String EMIT_HEARTBEATS_ENABLED_DOC = "Whether to emit heartbeats to target cluster.";
    public static final boolean EMIT_HEARTBEATS_ENABLED_DEFAULT = true;
    public static final String EMIT_HEARTBEATS_INTERVAL_SECONDS = "emit.heartbeats.interval.seconds";
    private static final String EMIT_HEARTBEATS_INTERVAL_SECONDS_DOC = "Frequency of heartbeats.";
    public static final long EMIT_HEARTBEATS_INTERVAL_SECONDS_DEFAULT = 1L;
    public static final String EMIT_CHECKPOINTS_ENABLED = "emit.checkpoints.enabled";
    private static final String EMIT_CHECKPOINTS_ENABLED_DOC = "Whether to replicate consumer offsets to target cluster.";
    public static final boolean EMIT_CHECKPOINTS_ENABLED_DEFAULT = true;
    public static final String EMIT_CHECKPOINTS_INTERVAL_SECONDS = "emit.checkpoints.interval.seconds";
    private static final String EMIT_CHECKPOINTS_INTERVAL_SECONDS_DOC = "Frequency of checkpoints.";
    public static final long EMIT_CHECKPOINTS_INTERVAL_SECONDS_DEFAULT = 60L;
    public static final String SYNC_GROUP_OFFSETS_ENABLED = "sync.group.offsets.enabled";
    private static final String SYNC_GROUP_OFFSETS_ENABLED_DOC = "Whether to periodically write the translated offsets to __consumer_offsets topic in target cluster, as long as no active consumers in that group are connected to the target cluster";
    public static final boolean SYNC_GROUP_OFFSETS_ENABLED_DEFAULT = false;
    public static final String SYNC_GROUP_OFFSETS_INTERVAL_SECONDS = "sync.group.offsets.interval.seconds";
    private static final String SYNC_GROUP_OFFSETS_INTERVAL_SECONDS_DOC = "Frequency of consumer group offset sync.";
    public static final long SYNC_GROUP_OFFSETS_INTERVAL_SECONDS_DEFAULT = 60L;
    public static final String TOPIC_FILTER_CLASS = "topic.filter.class";
    private static final String TOPIC_FILTER_CLASS_DOC = "TopicFilter to use. Selects topics to replicate.";
    public static final Class<?> TOPIC_FILTER_CLASS_DEFAULT = DefaultTopicFilter.class;
    public static final String GROUP_FILTER_CLASS = "group.filter.class";
    private static final String GROUP_FILTER_CLASS_DOC = "GroupFilter to use. Selects consumer groups to replicate.";
    public static final Class<?> GROUP_FILTER_CLASS_DEFAULT = DefaultGroupFilter.class;
    public static final String CONFIG_PROPERTY_FILTER_CLASS = "config.property.filter.class";
    private static final String CONFIG_PROPERTY_FILTER_CLASS_DOC = "ConfigPropertyFilter to use. Selects topic config  properties to replicate.";
    public static final Class<?> CONFIG_PROPERTY_FILTER_CLASS_DEFAULT = DefaultConfigPropertyFilter.class;
    public static final String OFFSET_LAG_MAX = "offset.lag.max";
    private static final String OFFSET_LAG_MAX_DOC = "How out-of-sync a remote partition can be before it is resynced.";
    public static final long OFFSET_LAG_MAX_DEFAULT = 100L;
    protected static final String SOURCE_CLUSTER_PREFIX = "source.cluster.";
    protected static final String TARGET_CLUSTER_PREFIX = "target.cluster.";
    protected static final String SOURCE_PREFIX = "source.";
    protected static final String TARGET_PREFIX = "target.";
    protected static final String PRODUCER_CLIENT_PREFIX = "producer.";
    protected static final String CONSUMER_CLIENT_PREFIX = "consumer.";
    protected static final String ADMIN_CLIENT_PREFIX = "admin.";
    protected static final ConfigDef CONNECTOR_CONFIG_DEF = ConnectorConfig.configDef().define("enabled", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Whether to replicate source->target.").define("topics", ConfigDef.Type.LIST, (Object)".*", ConfigDef.Importance.HIGH, "Topics to replicate. Supports comma-separated topic names and regexes.").define("topics.exclude", ConfigDef.Type.LIST, (Object)".*[\\-\\.]internal, .*\\.replica, __.*", ConfigDef.Importance.HIGH, "Excluded topics. Supports comma-separated topic names and regexes. Excludes take precedence over includes.").define("topics.blacklist", ConfigDef.Type.LIST, null, ConfigDef.Importance.HIGH, "Deprecated. Use topics.exclude instead.").define("groups", ConfigDef.Type.LIST, (Object)".*", ConfigDef.Importance.HIGH, "Consumer groups to replicate. Supports comma-separated group IDs and regexes.").define("groups.exclude", ConfigDef.Type.LIST, (Object)"console-consumer-.*, connect-.*, __.*", ConfigDef.Importance.HIGH, "Exclude groups. Supports comma-separated group IDs and regexes. Excludes take precedence over includes.").define("groups.blacklist", ConfigDef.Type.LIST, null, ConfigDef.Importance.HIGH, "Deprecated. Use groups.exclude instead.").define("config.properties.exclude", ConfigDef.Type.LIST, (Object)"follower\\.replication\\.throttled\\.replicas, leader\\.replication\\.throttled\\.replicas, message\\.timestamp\\.difference\\.max\\.ms, message\\.timestamp\\.type, unclean\\.leader\\.election\\.enable, min\\.insync\\.replicas", ConfigDef.Importance.HIGH, "Topic config properties that should not be replicated. Supports comma-separated property names and regexes.").define("config.properties.blacklist", ConfigDef.Type.LIST, null, ConfigDef.Importance.HIGH, "Deprecated. Use config.properties.exclude instead.").define("topic.filter.class", ConfigDef.Type.CLASS, TOPIC_FILTER_CLASS_DEFAULT, ConfigDef.Importance.LOW, "TopicFilter to use. Selects topics to replicate.").define("group.filter.class", ConfigDef.Type.CLASS, GROUP_FILTER_CLASS_DEFAULT, ConfigDef.Importance.LOW, "GroupFilter to use. Selects consumer groups to replicate.").define("config.property.filter.class", ConfigDef.Type.CLASS, CONFIG_PROPERTY_FILTER_CLASS_DEFAULT, ConfigDef.Importance.LOW, "ConfigPropertyFilter to use. Selects topic config  properties to replicate.").define("source.cluster.alias", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "Alias of source cluster").define("target.cluster.alias", ConfigDef.Type.STRING, (Object)"target", ConfigDef.Importance.HIGH, "Alias of target cluster. Used in metrics reporting.").define("consumer.poll.timeout.ms", ConfigDef.Type.LONG, (Object)1000L, ConfigDef.Importance.LOW, "Timeout when polling source cluster.").define("admin.timeout.ms", ConfigDef.Type.LONG, (Object)60000L, ConfigDef.Importance.LOW, "Timeout for administrative tasks, e.g. detecting new topics.").define("refresh.topics.enabled", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Whether to periodically check for new topics and partitions.").define("refresh.topics.interval.seconds", ConfigDef.Type.LONG, (Object)600L, ConfigDef.Importance.LOW, "Frequency of topic refresh.").define("refresh.groups.enabled", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Whether to periodically check for new consumer groups.").define("refresh.groups.interval.seconds", ConfigDef.Type.LONG, (Object)600L, ConfigDef.Importance.LOW, "Frequency of group refresh.").define("sync.topic.configs.enabled", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Whether to periodically configure remote topics to match their corresponding upstream topics.").define("sync.topic.configs.interval.seconds", ConfigDef.Type.LONG, (Object)600L, ConfigDef.Importance.LOW, "Frequency of topic config sync.").define("sync.topic.acls.enabled", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Whether to periodically configure remote topic ACLs to match their corresponding upstream topics.").define("sync.topic.acls.interval.seconds", ConfigDef.Type.LONG, (Object)600L, ConfigDef.Importance.LOW, "Frequency of topic ACL sync.").define("emit.heartbeats.enabled", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Whether to emit heartbeats to target cluster.").define("emit.heartbeats.interval.seconds", ConfigDef.Type.LONG, (Object)1L, ConfigDef.Importance.LOW, "Frequency of heartbeats.").define("emit.checkpoints.enabled", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Whether to replicate consumer offsets to target cluster.").define("emit.checkpoints.interval.seconds", ConfigDef.Type.LONG, (Object)60L, ConfigDef.Importance.LOW, "Frequency of checkpoints.").define("sync.group.offsets.enabled", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Whether to periodically write the translated offsets to __consumer_offsets topic in target cluster, as long as no active consumers in that group are connected to the target cluster").define("sync.group.offsets.interval.seconds", ConfigDef.Type.LONG, (Object)60L, ConfigDef.Importance.LOW, "Frequency of consumer group offset sync.").define("replication.policy.class", ConfigDef.Type.CLASS, REPLICATION_POLICY_CLASS_DEFAULT, ConfigDef.Importance.LOW, "Class which defines the remote topic naming convention.").define("replication.policy.separator", ConfigDef.Type.STRING, (Object)".", ConfigDef.Importance.LOW, "Separator used in remote topic naming convention.").define("replication.factor", ConfigDef.Type.INT, (Object)2, ConfigDef.Importance.LOW, "Replication factor for newly created remote topics.").define("heartbeats.topic.replication.factor", ConfigDef.Type.SHORT, (Object)3, ConfigDef.Importance.LOW, "Replication factor for heartbeats topic.").define("checkpoints.topic.replication.factor", ConfigDef.Type.SHORT, (Object)3, ConfigDef.Importance.LOW, "Replication factor for checkpoints topic.").define("offset-syncs.topic.replication.factor", ConfigDef.Type.SHORT, (Object)3, ConfigDef.Importance.LOW, "Replication factor for offset-syncs topic.").define("offset.lag.max", ConfigDef.Type.LONG, (Object)100L, ConfigDef.Importance.LOW, "How out-of-sync a remote partition can be before it is resynced.").define("metric.reporters", ConfigDef.Type.LIST, null, ConfigDef.Importance.LOW, "A list of classes to use as metrics reporters. Implementing the <code>org.apache.kafka.common.metrics.MetricsReporter</code> interface allows plugging in classes that will be notified of new metric creation. The JmxReporter is always included to register JMX statistics.").define("security.protocol", ConfigDef.Type.STRING, (Object)"PLAINTEXT", ConfigDef.Importance.MEDIUM, CommonClientConfigs.SECURITY_PROTOCOL_DOC).withClientSslSupport().withClientSaslSupport();

    public MirrorConnectorConfig(Map<String, String> props) {
        this(CONNECTOR_CONFIG_DEF, ConfigUtils.translateDeprecatedConfigs(props, (String[][])new String[][]{{TOPICS_EXCLUDE, TOPICS_EXCLUDE_ALIAS}, {GROUPS_EXCLUDE, GROUPS_EXCLUDE_ALIAS}, {CONFIG_PROPERTIES_EXCLUDE, CONFIG_PROPERTIES_EXCLUDE_ALIAS}}));
    }

    protected MirrorConnectorConfig(ConfigDef configDef, Map<String, String> props) {
        super(configDef, props, true);
    }

    String connectorName() {
        return this.getString("name");
    }

    boolean enabled() {
        return this.getBoolean(ENABLED);
    }

    Duration consumerPollTimeout() {
        return Duration.ofMillis(this.getLong(CONSUMER_POLL_TIMEOUT_MILLIS));
    }

    Duration adminTimeout() {
        return Duration.ofMillis(this.getLong(ADMIN_TASK_TIMEOUT_MILLIS));
    }

    Map<String, Object> sourceProducerConfig() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(this.originalsWithPrefix(SOURCE_CLUSTER_PREFIX));
        props.keySet().retainAll(MirrorClientConfig.CLIENT_CONFIG_DEF.names());
        props.putAll(this.originalsWithPrefix(PRODUCER_CLIENT_PREFIX));
        props.putAll(this.originalsWithPrefix("source.producer."));
        return props;
    }

    Map<String, Object> sourceConsumerConfig() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(this.originalsWithPrefix(SOURCE_CLUSTER_PREFIX));
        props.keySet().retainAll(MirrorClientConfig.CLIENT_CONFIG_DEF.names());
        props.putAll(this.originalsWithPrefix(CONSUMER_CLIENT_PREFIX));
        props.putAll(this.originalsWithPrefix("source.consumer."));
        props.put("enable.auto.commit", "false");
        props.putIfAbsent("auto.offset.reset", "earliest");
        return props;
    }

    Map<String, String> taskConfigForTopicPartitions(List<TopicPartition> topicPartitions) {
        Map props = this.originalsStrings();
        String topicPartitionsString = topicPartitions.stream().map(MirrorUtils::encodeTopicPartition).collect(Collectors.joining(","));
        props.put(TASK_TOPIC_PARTITIONS, topicPartitionsString);
        return props;
    }

    Map<String, String> taskConfigForConsumerGroups(List<String> groups) {
        Map props = this.originalsStrings();
        props.put(TASK_CONSUMER_GROUPS, String.join((CharSequence)",", groups));
        return props;
    }

    Map<String, Object> targetAdminConfig() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(this.originalsWithPrefix(TARGET_CLUSTER_PREFIX));
        props.keySet().retainAll(MirrorClientConfig.CLIENT_CONFIG_DEF.names());
        props.putAll(this.originalsWithPrefix(ADMIN_CLIENT_PREFIX));
        props.putAll(this.originalsWithPrefix("target.admin."));
        return props;
    }

    Map<String, Object> sourceAdminConfig() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(this.originalsWithPrefix(SOURCE_CLUSTER_PREFIX));
        props.keySet().retainAll(MirrorClientConfig.CLIENT_CONFIG_DEF.names());
        props.putAll(this.originalsWithPrefix(ADMIN_CLIENT_PREFIX));
        props.putAll(this.originalsWithPrefix("source.admin."));
        return props;
    }

    List<MetricsReporter> metricsReporters() {
        List reporters = this.getConfiguredInstances("metric.reporters", MetricsReporter.class);
        JmxReporter jmxReporter = new JmxReporter();
        jmxReporter.configure(this.originals());
        reporters.add(jmxReporter);
        KafkaMetricsContext metricsContext = new KafkaMetricsContext("kafka.connect.mirror");
        for (MetricsReporter reporter : reporters) {
            reporter.contextChange((MetricsContext)metricsContext);
        }
        return reporters;
    }

    String sourceClusterAlias() {
        return this.getString(SOURCE_CLUSTER_ALIAS);
    }

    String targetClusterAlias() {
        return this.getString(TARGET_CLUSTER_ALIAS);
    }

    String offsetSyncsTopic() {
        return "mm2-offset-syncs." + this.targetClusterAlias() + ".internal";
    }

    String heartbeatsTopic() {
        return "heartbeats";
    }

    String targetHeartbeatsTopic() {
        return this.replicationPolicy().formatRemoteTopic(this.sourceClusterAlias(), this.heartbeatsTopic());
    }

    String checkpointsTopic() {
        return this.sourceClusterAlias() + ".checkpoints.internal";
    }

    long maxOffsetLag() {
        return this.getLong(OFFSET_LAG_MAX);
    }

    Duration emitHeartbeatsInterval() {
        if (this.getBoolean(EMIT_HEARTBEATS_ENABLED).booleanValue()) {
            return Duration.ofSeconds(this.getLong(EMIT_HEARTBEATS_INTERVAL_SECONDS));
        }
        return Duration.ofMillis(-1L);
    }

    Duration emitCheckpointsInterval() {
        if (this.getBoolean(EMIT_CHECKPOINTS_ENABLED).booleanValue()) {
            return Duration.ofSeconds(this.getLong(EMIT_CHECKPOINTS_INTERVAL_SECONDS));
        }
        return Duration.ofMillis(-1L);
    }

    Duration refreshTopicsInterval() {
        if (this.getBoolean(REFRESH_TOPICS_ENABLED).booleanValue()) {
            return Duration.ofSeconds(this.getLong(REFRESH_TOPICS_INTERVAL_SECONDS));
        }
        return Duration.ofMillis(-1L);
    }

    Duration refreshGroupsInterval() {
        if (this.getBoolean(REFRESH_GROUPS_ENABLED).booleanValue()) {
            return Duration.ofSeconds(this.getLong(REFRESH_GROUPS_INTERVAL_SECONDS));
        }
        return Duration.ofMillis(-1L);
    }

    Duration syncTopicConfigsInterval() {
        if (this.getBoolean(SYNC_TOPIC_CONFIGS_ENABLED).booleanValue()) {
            return Duration.ofSeconds(this.getLong(SYNC_TOPIC_CONFIGS_INTERVAL_SECONDS));
        }
        return Duration.ofMillis(-1L);
    }

    Duration syncTopicAclsInterval() {
        if (this.getBoolean(SYNC_TOPIC_ACLS_ENABLED).booleanValue()) {
            return Duration.ofSeconds(this.getLong(SYNC_TOPIC_ACLS_INTERVAL_SECONDS));
        }
        return Duration.ofMillis(-1L);
    }

    ReplicationPolicy replicationPolicy() {
        return (ReplicationPolicy)this.getConfiguredInstance(REPLICATION_POLICY_CLASS, ReplicationPolicy.class);
    }

    int replicationFactor() {
        return this.getInt(REPLICATION_FACTOR);
    }

    short heartbeatsTopicReplicationFactor() {
        return this.getShort(HEARTBEATS_TOPIC_REPLICATION_FACTOR);
    }

    short checkpointsTopicReplicationFactor() {
        return this.getShort(CHECKPOINTS_TOPIC_REPLICATION_FACTOR);
    }

    short offsetSyncsTopicReplicationFactor() {
        return this.getShort(OFFSET_SYNCS_TOPIC_REPLICATION_FACTOR);
    }

    TopicFilter topicFilter() {
        return (TopicFilter)this.getConfiguredInstance(TOPIC_FILTER_CLASS, TopicFilter.class);
    }

    GroupFilter groupFilter() {
        return (GroupFilter)this.getConfiguredInstance(GROUP_FILTER_CLASS, GroupFilter.class);
    }

    ConfigPropertyFilter configPropertyFilter() {
        return (ConfigPropertyFilter)this.getConfiguredInstance(CONFIG_PROPERTY_FILTER_CLASS, ConfigPropertyFilter.class);
    }

    Duration syncGroupOffsetsInterval() {
        if (this.getBoolean(SYNC_GROUP_OFFSETS_ENABLED).booleanValue()) {
            return Duration.ofSeconds(this.getLong(SYNC_GROUP_OFFSETS_INTERVAL_SECONDS));
        }
        return Duration.ofMillis(-1L);
    }
}

