/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableKTableAbstractJoin;
import org.apache.kafka.streams.kstream.internals.KTableKTableAbstractJoinValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KTableKTableInnerJoin<K, R, V1, V2>
extends KTableKTableAbstractJoin<K, R, V1, V2> {
    private static final Logger LOG = LoggerFactory.getLogger(KTableKTableInnerJoin.class);
    private final KeyValueMapper<K, V1, K> keyValueMapper = (key, value) -> key;

    KTableKTableInnerJoin(KTableImpl<K, ?, V1> table1, KTableImpl<K, ?, V2> table2, ValueJoiner<? super V1, ? super V2, ? extends R> joiner) {
        super(table1, table2, joiner);
    }

    @Override
    public Processor<K, Change<V1>> get() {
        return new KTableKTableJoinProcessor(this.valueGetterSupplier2.get());
    }

    @Override
    public KTableValueGetterSupplier<K, R> view() {
        return new KTableKTableInnerJoinValueGetterSupplier(this.valueGetterSupplier1, this.valueGetterSupplier2);
    }

    private class KTableKTableInnerJoinValueGetter
    implements KTableValueGetter<K, R> {
        private final KTableValueGetter<K, V1> valueGetter1;
        private final KTableValueGetter<K, V2> valueGetter2;

        KTableKTableInnerJoinValueGetter(KTableValueGetter<K, V1> valueGetter1, KTableValueGetter<K, V2> valueGetter2) {
            this.valueGetter1 = valueGetter1;
            this.valueGetter2 = valueGetter2;
        }

        @Override
        public void init(ProcessorContext context) {
            this.valueGetter1.init(context);
            this.valueGetter2.init(context);
        }

        @Override
        public ValueAndTimestamp<R> get(K key) {
            ValueAndTimestamp valueAndTimestamp1 = this.valueGetter1.get(key);
            Object value1 = ValueAndTimestamp.getValueOrNull(valueAndTimestamp1);
            if (value1 != null) {
                ValueAndTimestamp valueAndTimestamp2 = this.valueGetter2.get(KTableKTableInnerJoin.this.keyValueMapper.apply(key, value1));
                Object value2 = ValueAndTimestamp.getValueOrNull(valueAndTimestamp2);
                if (value2 != null) {
                    return ValueAndTimestamp.make(KTableKTableInnerJoin.this.joiner.apply(value1, value2), Math.max(valueAndTimestamp1.timestamp(), valueAndTimestamp2.timestamp()));
                }
                return null;
            }
            return null;
        }

        @Override
        public void close() {
            this.valueGetter1.close();
            this.valueGetter2.close();
        }
    }

    private class KTableKTableJoinProcessor
    extends AbstractProcessor<K, Change<V1>> {
        private final KTableValueGetter<K, V2> valueGetter;
        private StreamsMetricsImpl metrics;
        private Sensor droppedRecordsSensor;

        KTableKTableJoinProcessor(KTableValueGetter<K, V2> valueGetter) {
            this.valueGetter = valueGetter;
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.metrics = (StreamsMetricsImpl)context.metrics();
            this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensorOrSkippedRecordsSensor(Thread.currentThread().getName(), context.taskId().toString(), this.metrics);
            this.valueGetter.init(context);
        }

        @Override
        public void process(K key, Change<V1> change) {
            if (key == null) {
                LOG.warn("Skipping record due to null key. change=[{}] topic=[{}] partition=[{}] offset=[{}]", new Object[]{change, this.context().topic(), this.context().partition(), this.context().offset()});
                this.droppedRecordsSensor.record();
                return;
            }
            Object newValue = null;
            Object oldValue = null;
            ValueAndTimestamp valueAndTimestampRight = this.valueGetter.get(key);
            Object valueRight = ValueAndTimestamp.getValueOrNull(valueAndTimestampRight);
            if (valueRight == null) {
                return;
            }
            long resultTimestamp = Math.max(this.context().timestamp(), valueAndTimestampRight.timestamp());
            if (change.newValue != null) {
                newValue = KTableKTableInnerJoin.this.joiner.apply(change.newValue, valueRight);
            }
            if (KTableKTableInnerJoin.this.sendOldValues && change.oldValue != null) {
                oldValue = KTableKTableInnerJoin.this.joiner.apply(change.oldValue, valueRight);
            }
            this.context().forward(key, new Change<Object>(newValue, oldValue), To.all().withTimestamp(resultTimestamp));
        }

        @Override
        public void close() {
            this.valueGetter.close();
        }
    }

    private class KTableKTableInnerJoinValueGetterSupplier
    extends KTableKTableAbstractJoinValueGetterSupplier<K, R, V1, V2> {
        KTableKTableInnerJoinValueGetterSupplier(KTableValueGetterSupplier<K, V1> valueGetterSupplier1, KTableValueGetterSupplier<K, V2> valueGetterSupplier2) {
            super(valueGetterSupplier1, valueGetterSupplier2);
        }

        @Override
        public KTableValueGetter<K, R> get() {
            return new KTableKTableInnerJoinValueGetter(this.valueGetterSupplier1.get(), this.valueGetterSupplier2.get());
        }
    }
}

