/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.time.Duration;
import java.util.Objects;
import org.apache.kafka.streams.internals.ApiUtils;

public final class SessionWindows {
    private final long gapMs;
    private final long maintainDurationMs;
    private final long graceMs;

    private SessionWindows(long gapMs, long maintainDurationMs, long graceMs) {
        this.gapMs = gapMs;
        this.maintainDurationMs = maintainDurationMs;
        this.graceMs = graceMs;
    }

    @Deprecated
    public static SessionWindows with(long inactivityGapMs) {
        if (inactivityGapMs <= 0L) {
            throw new IllegalArgumentException("Gap time (inactivityGapMs) cannot be zero or negative.");
        }
        return new SessionWindows(inactivityGapMs, 86400000L, -1L);
    }

    public static SessionWindows with(Duration inactivityGap) {
        String msgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(inactivityGap, "inactivityGap");
        return SessionWindows.with(ApiUtils.validateMillisecondDuration(inactivityGap, msgPrefix));
    }

    @Deprecated
    public SessionWindows until(long durationMs) throws IllegalArgumentException {
        if (durationMs < this.gapMs) {
            throw new IllegalArgumentException("Window retention time (durationMs) cannot be smaller than window gap.");
        }
        return new SessionWindows(this.gapMs, durationMs, this.graceMs);
    }

    public SessionWindows grace(Duration afterWindowEnd) throws IllegalArgumentException {
        String msgPrefix = ApiUtils.prepareMillisCheckFailMsgPrefix(afterWindowEnd, "afterWindowEnd");
        long afterWindowEndMs = ApiUtils.validateMillisecondDuration(afterWindowEnd, msgPrefix);
        if (afterWindowEndMs < 0L) {
            throw new IllegalArgumentException("Grace period must not be negative.");
        }
        return new SessionWindows(this.gapMs, this.maintainDurationMs, afterWindowEndMs);
    }

    public long gracePeriodMs() {
        return this.graceMs != -1L ? this.graceMs : this.maintainMs() - this.inactivityGap();
    }

    public long inactivityGap() {
        return this.gapMs;
    }

    @Deprecated
    public long maintainMs() {
        return Math.max(this.maintainDurationMs, this.gapMs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionWindows that = (SessionWindows)o;
        return this.gapMs == that.gapMs && this.maintainDurationMs == that.maintainDurationMs && this.graceMs == that.graceMs;
    }

    public int hashCode() {
        return Objects.hash(this.gapMs, this.maintainDurationMs, this.graceMs);
    }

    public String toString() {
        return "SessionWindows{gapMs=" + this.gapMs + ", maintainDurationMs=" + this.maintainDurationMs + ", graceMs=" + this.graceMs + '}';
    }
}

