/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.timer;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.utils.timer.SystemTimer;
import kafka.utils.timer.Timer;
import kafka.utils.timer.TimerTask;
import kafka.utils.timer.TimerTaskEntry;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005q4A\u0001E\t\u00011!)q\u0004\u0001C\u0001A\u0019!1\u0005\u0001\u0003%\u0011!\u0001$A!b\u0001\n\u0003\n\u0004\u0002C\u001b\u0003\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011Y\u0012!\u0011!Q\u0001\n]B\u0001B\u000f\u0002\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0007\n\u0011\t\u0011)A\u0005\t\")qD\u0001C\u0001\u0019\"11K\u0001Q\u0001\nQCQA\u0017\u0002\u0005\u0002mCaA\u0005\u0001!B\u0013y\u0006\"\u00022\u0001\t\u0003Y\u0006\"\u00029\u0001\t\u0003Y\u0006\"B;\u0001\t\u0003Y\u0006\"\u0002>\u0001\t\u0003Y&!\u0003+j[\u0016\u0014H+Z:u\u0015\t\u00112#A\u0003uS6,'O\u0003\u0002\u0015+\u0005)Q\u000f^5mg*\ta#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001I\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011!\u0005A\u0007\u0002#\tAA+Z:u)\u0006\u001c8nE\u0002\u0003K5\u0002\"AJ\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\t1\fgn\u001a\u0006\u0002U\u0005!!.\u0019<b\u0013\tasE\u0001\u0004PE*,7\r\u001e\t\u0003E9J!aL\t\u0003\u0013QKW.\u001a:UCN\\\u0017a\u00023fY\u0006LXj]\u000b\u0002eA\u0011!dM\u0005\u0003im\u0011A\u0001T8oO\u0006AA-\u001a7bs6\u001b\b%\u0001\u0002jIB\u0011!\u0004O\u0005\u0003sm\u00111!\u00138u\u0003\u0015a\u0017\r^2i!\ta\u0014)D\u0001>\u0015\tqt(\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001Q\u0015\u0002\tU$\u0018\u000e\\\u0005\u0003\u0005v\u0012abQ8v]R$un\u001e8MCR\u001c\u0007.\u0001\u0004pkR\u0004X\u000f\u001e\t\u0004\u000b*;T\"\u0001$\u000b\u0005\u001dC\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\u0013n\t!bY8mY\u0016\u001cG/[8o\u0013\tYeIA\u0006BeJ\f\u0017PQ;gM\u0016\u0014H#B'P!F\u0013\u0006C\u0001(\u0003\u001b\u0005\u0001\u0001\"\u0002\u0019\t\u0001\u0004\u0011\u0004\"\u0002\u001c\t\u0001\u00049\u0004\"\u0002\u001e\t\u0001\u0004Y\u0004\"B\"\t\u0001\u0004!\u0015!C2p[BdW\r^3e!\t)\u0006,D\u0001W\u0015\t9V(\u0001\u0004bi>l\u0017nY\u0005\u00033Z\u0013Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017a\u0001:v]R\tA\f\u0005\u0002\u001b;&\u0011al\u0007\u0002\u0005+:LG\u000f\u0005\u0002#A&\u0011\u0011-\u0005\u0002\u0006)&lWM]\u0001\u0006g\u0016$X\u000f\u001d\u0015\u0003\u0019\u0011\u0004\"!\u001a8\u000e\u0003\u0019T!a\u001a5\u0002\u0007\u0005\u0004\u0018N\u0003\u0002jU\u00069!.\u001e9ji\u0016\u0014(BA6m\u0003\u0015QWO\\5u\u0015\u0005i\u0017aA8sO&\u0011qN\u001a\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$wn\u001e8)\u00055\u0011\bCA3t\u0013\t!hMA\u0005BMR,'/R1dQ\u00061B/Z:u\u00032\u0014X-\u00193z\u000bb\u0004\u0018N]3e)\u0006\u001c8\u000e\u000b\u0002\u000foB\u0011Q\r_\u0005\u0003s\u001a\u0014A\u0001V3ti\u0006\u0011B/Z:u)\u0006\u001c8.\u0012=qSJ\fG/[8oQ\tyq\u000f")
public class TimerTest {
    private Timer timer = null;

    @BeforeEach
    public void setup() {
        this.timer = new SystemTimer("test", 1L, 3, Time.SYSTEM.hiResClockMs());
    }

    @AfterEach
    public void teardown() {
        this.timer.shutdown();
    }

    @Test
    public void testAlreadyExpiredTask() {
        ArrayBuffer output = new ArrayBuffer();
        IndexedSeq latches = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(-5), 0).map((Function1 & Serializable)i -> TimerTest.$anonfun$testAlreadyExpiredTask$1(this, output, BoxesRunTime.unboxToInt((Object)i)));
        this.timer.advanceClock(0L);
        ((IterableOnceOps)latches.take(5)).foreach((Function1 & Serializable)latch -> {
            TimerTest.$anonfun$testAlreadyExpiredTask$2(latch);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-5, -4, -3, -2, -1})), (Object)output.toSet(), (String)"output of already expired tasks");
    }

    @Test
    public void testTaskExpiration() {
        ArrayBuffer output = new ArrayBuffer();
        ArrayBuffer tasks = new ArrayBuffer();
        ArrayBuffer ids = new ArrayBuffer();
        IndexedSeq latches = (IndexedSeq)((IterableOps)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)i -> TimerTest.$anonfun$testTaskExpiration$1(this, tasks, output, ids, BoxesRunTime.unboxToInt((Object)i))).$plus$plus((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(10), 100).map((Function1 & Serializable)i -> TimerTest.$anonfun$testTaskExpiration$2(this, tasks, output, ids, BoxesRunTime.unboxToInt((Object)i))))).$plus$plus((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(100), 500).map((Function1 & Serializable)i -> TimerTest.$anonfun$testTaskExpiration$3(this, tasks, output, ids, BoxesRunTime.unboxToInt((Object)i))));
        tasks.foreach((Function1 & Serializable)task -> {
            this.timer.add((TimerTask)task);
            return BoxedUnit.UNIT;
        });
        while (this.timer.advanceClock(2000L)) {
        }
        latches.foreach((Function1 & Serializable)latch -> {
            latch.await();
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)ids.sorted((Ordering)Ordering.Int$.MODULE$), (Object)output.toSeq(), (String)"output should match");
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ CountDownLatch $anonfun$testAlreadyExpiredTask$1(TimerTest $this, ArrayBuffer output$1, int i) {
        void var3_3;
        CountDownLatch latch = new CountDownLatch(1);
        $this.timer.add((TimerTask)new TestTask($this, i, i, latch, (ArrayBuffer<Object>)output$1));
        return var3_3;
    }

    public static final /* synthetic */ void $anonfun$testAlreadyExpiredTask$2(CountDownLatch latch) {
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)latch.await(3L, TimeUnit.SECONDS)), (String)"already expired tasks should run immediately");
    }

    public static final /* synthetic */ CountDownLatch $anonfun$testTaskExpiration$1(TimerTest $this, ArrayBuffer tasks$1, ArrayBuffer output$2, ArrayBuffer ids$1, int i) {
        CountDownLatch latch = new CountDownLatch(1);
        tasks$1.$plus$eq((Object)new TestTask($this, i, i, latch, (ArrayBuffer<Object>)output$2));
        ids$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
        return latch;
    }

    public static final /* synthetic */ CountDownLatch $anonfun$testTaskExpiration$2(TimerTest $this, ArrayBuffer tasks$1, ArrayBuffer output$2, ArrayBuffer ids$1, int i) {
        CountDownLatch latch = new CountDownLatch(2);
        tasks$1.$plus$eq((Object)new TestTask($this, i, i, latch, (ArrayBuffer<Object>)output$2));
        tasks$1.$plus$eq((Object)new TestTask($this, i, i, latch, (ArrayBuffer<Object>)output$2));
        ids$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
        ids$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
        return latch;
    }

    public static final /* synthetic */ CountDownLatch $anonfun$testTaskExpiration$3(TimerTest $this, ArrayBuffer tasks$1, ArrayBuffer output$2, ArrayBuffer ids$1, int i) {
        CountDownLatch latch = new CountDownLatch(1);
        tasks$1.$plus$eq((Object)new TestTask($this, i, i, latch, (ArrayBuffer<Object>)output$2));
        ids$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
        return latch;
    }

    private class TestTask
    implements TimerTask {
        private final long delayMs;
        private final int id;
        private final CountDownLatch latch;
        private final ArrayBuffer<Object> output;
        private final AtomicBoolean completed;
        private TimerTaskEntry kafka$utils$timer$TimerTask$$timerTaskEntry;
        public final /* synthetic */ TimerTest $outer;

        public void cancel() {
            TimerTask.cancel$((TimerTask)this);
        }

        public void setTimerTaskEntry(TimerTaskEntry entry) {
            TimerTask.setTimerTaskEntry$((TimerTask)this, (TimerTaskEntry)entry);
        }

        public TimerTaskEntry getTimerTaskEntry() {
            return TimerTask.getTimerTaskEntry$((TimerTask)this);
        }

        public TimerTaskEntry kafka$utils$timer$TimerTask$$timerTaskEntry() {
            return this.kafka$utils$timer$TimerTask$$timerTaskEntry;
        }

        public void kafka$utils$timer$TimerTask$$timerTaskEntry_$eq(TimerTaskEntry x$1) {
            this.kafka$utils$timer$TimerTask$$timerTaskEntry = x$1;
        }

        public long delayMs() {
            return this.delayMs;
        }

        public void run() {
            if (this.completed.compareAndSet(false, true)) {
                ArrayBuffer<Object> arrayBuffer = this.output;
                synchronized (arrayBuffer) {
                    ArrayBuffer cfr_ignored_0 = (ArrayBuffer)this.output.$plus$eq((Object)BoxesRunTime.boxToInteger((int)this.id));
                }
                this.latch.countDown();
            }
        }

        public /* synthetic */ TimerTest kafka$utils$timer$TimerTest$TestTask$$$outer() {
            return this.$outer;
        }

        public TestTask(TimerTest $outer, long delayMs, int id, CountDownLatch latch, ArrayBuffer<Object> output) {
            this.delayMs = delayMs;
            this.id = id;
            this.latch = latch;
            this.output = output;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.kafka$utils$timer$TimerTask$$timerTaskEntry_$eq(null);
            this.completed = new AtomicBoolean(false);
        }
    }
}

