/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import kafka.log.LogConfig$;
import kafka.message.ZStdCompressionCodec$;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.BaseRequestTest;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005Y4Aa\u0003\u0007\u0001#!)a\u0003\u0001C\u0001/!9\u0011\u0004\u0001b\u0001\n\u0003Q\u0002BB\u0019\u0001A\u0003%1\u0004C\u00033\u0001\u0011\u00051\u0007C\u0003F\u0001\u0011\u00051\u0007C\u0003H\u0001\u0011\u00051\u0007C\u0003J\u0001\u0011%!\nC\u0003_\u0001\u0011\u00051\u0007C\u0003a\u0001\u0011\u00051\u0007C\u0003c\u0001\u0011%1M\u0001\nQe>$WoY3SKF,Xm\u001d;UKN$(BA\u0007\u000f\u0003\u0019\u0019XM\u001d<fe*\tq\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0015\u001b\u0005a\u0011BA\u000b\r\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u0019!\t\u0019\u0002!A\u0007nKR\u0014\u0018nY:LKf\u001cV\r^\u000b\u00027A\u0019AdI\u0013\u000e\u0003uQ!AH\u0010\u0002\u000f5,H/\u00192mK*\u0011\u0001%I\u0001\u000bG>dG.Z2uS>t'\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011j\"aA*fiB\u0011aeL\u0007\u0002O)\u0011\u0001&K\u0001\u0005G>\u0014XM\u0003\u0002+W\u00059Q.\u001a;sS\u000e\u001c(B\u0001\u0017.\u0003\u0019I\u0018-\\7fe*\ta&A\u0002d_6L!\u0001M\u0014\u0003\u00155+GO]5d\u001d\u0006lW-\u0001\bnKR\u0014\u0018nY:LKf\u001cV\r\u001e\u0011\u00021Q,7\u000f^*j[BdW\r\u0015:pIV\u001cWMU3rk\u0016\u001cH\u000fF\u00015!\t)d'D\u0001\"\u0013\t9\u0014E\u0001\u0003V]&$\bF\u0001\u0003:!\tQ4)D\u0001<\u0015\taT(A\u0002ba&T!AP \u0002\u000f),\b/\u001b;fe*\u0011\u0001)Q\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0005\u0006\u0019qN]4\n\u0005\u0011[$\u0001\u0002+fgR\fq\u0004^3tiB\u0013x\u000eZ;dK^KG\u000f[%om\u0006d\u0017\u000e\u001a+j[\u0016\u001cH/Y7qQ\t)\u0011(A\fuKN$\bK]8ek\u000e,Gk\u001c(p]J+\u0007\u000f\\5dC\"\u0012a!O\u0001&GJ,\u0017\r^3U_BL7-\u00118e\r&tG\rU1si&$\u0018n\u001c8XSRDG*Z1eKJ$\"aS)\u0011\tUbeJT\u0005\u0003\u001b\u0006\u0012a\u0001V;qY\u0016\u0014\u0004CA\u001bP\u0013\t\u0001\u0016EA\u0002J]RDQAU\u0004A\u0002M\u000bQ\u0001^8qS\u000e\u0004\"\u0001V.\u000f\u0005UK\u0006C\u0001,\"\u001b\u00059&B\u0001-\u0011\u0003\u0019a$o\\8u}%\u0011!,I\u0001\u0007!J,G-\u001a4\n\u0005qk&AB*ue&twM\u0003\u0002[C\u0005aB/Z:u\u0007>\u0014(/\u001e9u\u0019j$\u0004K]8ek\u000e,'+Z9vKN$\bF\u0001\u0005:\u0003Y!Xm\u001d;['R#\u0005K]8ek\u000e,'+Z9vKN$\bFA\u0005:\u0003I\u0019XM\u001c3Qe>$WoY3SKF,Xm\u001d;\u0015\u0007\u0011|\u0017\u000f\u0005\u0002f[6\taM\u0003\u0002hQ\u0006A!/Z9vKN$8O\u0003\u0002jU\u000611m\\7n_:T!aD6\u000b\u00051\f\u0015AB1qC\u000eDW-\u0003\u0002oM\ny\u0001K]8ek\u000e,'+Z:q_:\u001cX\rC\u0003q\u0015\u0001\u0007a*\u0001\u0005mK\u0006$WM]%e\u0011\u0015\u0011(\u00021\u0001t\u0003\u001d\u0011X-];fgR\u0004\"!\u001a;\n\u0005U4'A\u0004)s_\u0012,8-\u001a*fcV,7\u000f\u001e")
public class ProduceRequestTest
extends BaseRequestTest {
    private final Set<MetricName> metricsKeySet = CollectionConverters$.MODULE$.SetHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala();

    public Set<MetricName> metricsKeySet() {
        return this.metricsKeySet;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSimpleProduceRequest() {
        void withRecords_records;
        void withRecords_timestampType;
        void var3_3;
        void var2_2;
        void withRecords_records2;
        void withRecords_timestampType2;
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int partition = tuple2._1$mcI$sp();
        int leader = tuple2._2$mcI$sp();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var4_5 = null;
        simpleRecordArray = null;
        this.sendAndCheck$1(MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType2, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records2), 0L, (int)var2_2, (int)var3_3);
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key1".getBytes(), "value1".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key2".getBytes(), "value2".getBytes())};
        CompressionType withRecords_compressionType2 = CompressionType.GZIP;
        byte withRecords_magic2 = 2;
        TimestampType timestampType2 = TimestampType.CREATE_TIME;
        long withRecords_initialOffset2 = 0L;
        timestampType2 = null;
        Object var6_10 = null;
        simpleRecordArray2 = null;
        this.sendAndCheck$1(MemoryRecords.withRecords((byte)withRecords_magic2, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType2, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), 1L, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testProduceWithInvalidTimestamp() {
        void var10_11;
        void var9_10;
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), "1000");
        int leader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), topicConfig).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        MemoryRecords records = ProduceRequestTest.createRecords$1((byte)2, System.currentTimeMillis() - 1001L, CompressionType.GZIP);
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceRequestData forCurrentMagic_data = new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)records)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null);
        Object var11_7 = null;
        ProduceResponse produceResponse = this.sendProduceRequest(leader, (ProduceRequest)ProduceRequest.forMagic((byte)2, (ProduceRequestData)forCurrentMagic_data).build());
        Tuple2 tuple2 = (Tuple2)CollectionConverters$.MODULE$.MapHasAsScala(produceResponse.responses()).asScala().head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple2._2();
        Assertions.assertEquals((Object)topicPartition, (Object)var9_10);
        Assertions.assertEquals((Object)Errors.INVALID_TIMESTAMP, (Object)var10_11.error);
        Assertions.assertEquals((int)3, (int)var10_11.recordErrors.size());
        Assertions.assertEquals((int)0, (int)((ProduceResponse.RecordError)var10_11.recordErrors.get((int)0)).batchIndex);
        Assertions.assertEquals((int)1, (int)((ProduceResponse.RecordError)var10_11.recordErrors.get((int)1)).batchIndex);
        Assertions.assertEquals((int)2, (int)((ProduceResponse.RecordError)var10_11.recordErrors.get((int)2)).batchIndex);
        CollectionConverters$.MODULE$.ListHasAsScala(var10_11.recordErrors).asScala().foreach((Function1 & Serializable)recordError -> {
            ProduceRequestTest.$anonfun$testProduceWithInvalidTimestamp$1(recordError);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)"One or more records have been rejected due to invalid timestamp", (Object)var10_11.errorMessage);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testProduceToNonReplica() {
        MemoryRecords memoryRecords;
        MemoryRecords memoryRecords2;
        void withRecords_records;
        void withRecords_timestampType;
        MemoryRecords memoryRecords3;
        String topic = "topic";
        int partition = 0;
        int leader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), new Properties()).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        Option nonReplicaOpt = this.servers().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testProduceToNonReplica$1(leader, x$4)));
        Assertions.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaServer)nonReplicaOpt.get()).config().brokerId();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("key".getBytes(), "value".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        MemoryRecords memoryRecords4 = memoryRecords3 = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        timestampType = null;
        memoryRecords3 = null;
        MemoryRecords memoryRecords5 = memoryRecords2 = memoryRecords4;
        memoryRecords2 = null;
        MemoryRecords memoryRecords6 = memoryRecords = memoryRecords5;
        Object var10_7 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords6;
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceRequestData forCurrentMagic_data = new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)records)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null);
        Object var13_16 = null;
        ProduceRequest produceRequest = (ProduceRequest)ProduceRequest.forMagic((byte)2, (ProduceRequestData)forCurrentMagic_data).build();
        ProduceResponse produceResponse = this.sendProduceRequest(nonReplicaId, produceRequest);
        Assertions.assertEquals((int)1, (int)produceResponse.responses().size());
        Assertions.assertEquals((Object)Errors.NOT_LEADER_OR_FOLLOWER, (Object)((ProduceResponse.PartitionResponse)((Tuple2)CollectionConverters$.MODULE$.MapHasAsScala((Map)produceResponse.responses()).asScala().head())._2()).error);
    }

    private Tuple2<Object, Object> createTopicAndFindPartitionWithLeader(String topic) {
        return (Tuple2)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 3, 2, (Seq<KafkaServer>)this.servers(), new Properties()).collectFirst((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    int partition = x1._1$mcI$sp();
                    int leader = x1._2$mcI$sp();
                    if (leader != -1) {
                        object = new Tuple2.mcII.sp(partition, leader);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                boolean bl = x1 != null && x1._2$mcI$sp() != -1;
                return bl;
            }
        }).getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(28).append("No leader elected for topic ").append(topic).toString());
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCorruptLz4ProduceRequest() {
        void var11_20;
        void var10_19;
        void var3_3;
        void var2_2;
        MemoryRecords memoryRecords;
        MemoryRecords memoryRecords2;
        void withRecords_records;
        void withRecords_timestampType;
        MemoryRecords memoryRecords3;
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int partition = tuple2._1$mcI$sp();
        int leader = tuple2._2$mcI$sp();
        int timestamp = 1000000;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(Int$.MODULE$.int2long(timestamp), "key".getBytes(), "value".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.LZ4;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        MemoryRecords memoryRecords4 = memoryRecords3 = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        timestampType = null;
        memoryRecords3 = null;
        MemoryRecords memoryRecords5 = memoryRecords2 = memoryRecords4;
        memoryRecords2 = null;
        MemoryRecords memoryRecords6 = memoryRecords = memoryRecords5;
        Object var12_6 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords memoryRecords7 = memoryRecords6;
        int lz4ChecksumOffset = 6;
        memoryRecords7.buffer().array()[61 + lz4ChecksumOffset] = 0;
        TopicPartition topicPartition = new TopicPartition("topic", (int)var2_2);
        ProduceRequestData forCurrentMagic_data = new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)memoryRecords7)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null);
        Object var15_16 = null;
        ProduceResponse produceResponse = this.sendProduceRequest((int)var3_3, (ProduceRequest)ProduceRequest.forMagic((byte)2, (ProduceRequestData)forCurrentMagic_data).build());
        Assertions.assertEquals((int)1, (int)produceResponse.responses().size());
        Tuple2 tuple22 = (Tuple2)CollectionConverters$.MODULE$.MapHasAsScala(produceResponse.responses()).asScala().head();
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        TopicPartition tp = (TopicPartition)tuple22._1();
        ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple22._2();
        Assertions.assertEquals((Object)topicPartition, (Object)var10_19);
        Assertions.assertEquals((Object)Errors.CORRUPT_MESSAGE, (Object)var11_20.error);
        Assertions.assertEquals((long)-1L, (long)var11_20.baseOffset);
        Assertions.assertEquals((long)-1L, (long)var11_20.logAppendTime);
        Assertions.assertEquals((int)this.metricsKeySet().count((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testCorruptLz4ProduceRequest$1(x$7))), (int)1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMessageCrcRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZSTDProduceRequest() {
        void var15_23;
        void var14_22;
        void var11_19;
        void var10_18;
        MemoryRecords memoryRecords;
        MemoryRecords memoryRecords2;
        void withRecords_records;
        void withRecords_timestampType;
        MemoryRecords memoryRecords3;
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.CompressionTypeProp(), ZStdCompressionCodec$.MODULE$.name());
        int leader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), topicConfig).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())};
        CompressionType withRecords_compressionType = CompressionType.ZSTD;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        MemoryRecords memoryRecords4 = memoryRecords3 = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        timestampType = null;
        memoryRecords3 = null;
        MemoryRecords memoryRecords5 = memoryRecords2 = memoryRecords4;
        memoryRecords2 = null;
        MemoryRecords memoryRecords6 = memoryRecords = memoryRecords5;
        Object var16_6 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords memoryRecords7 = memoryRecords6;
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceRequestData partitionRecords = new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("topic").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(partition).setRecords((BaseRecords)memoryRecords7)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null);
        ProduceResponse res1 = this.sendProduceRequest(leader, (ProduceRequest)new ProduceRequest.Builder(7, 7, partitionRecords).build());
        Tuple2 tuple2 = (Tuple2)CollectionConverters$.MODULE$.MapHasAsScala(res1.responses()).asScala().head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition tp1 = (TopicPartition)tuple2._1();
        ProduceResponse.PartitionResponse partitionResponse1 = (ProduceResponse.PartitionResponse)tuple2._2();
        Assertions.assertEquals((Object)topicPartition, (Object)var10_18);
        Assertions.assertEquals((Object)Errors.NONE, (Object)var11_19.error);
        Assertions.assertEquals((long)0L, (long)var11_19.baseOffset);
        Assertions.assertEquals((long)-1L, (long)var11_19.logAppendTime);
        ProduceResponse res2 = this.sendProduceRequest(leader, new ProduceRequest.Builder(3, 3, partitionRecords).buildUnsafe((short)3));
        Tuple2 tuple22 = (Tuple2)CollectionConverters$.MODULE$.MapHasAsScala(res2.responses()).asScala().head();
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        TopicPartition tp2 = (TopicPartition)tuple22._1();
        ProduceResponse.PartitionResponse partitionResponse2 = (ProduceResponse.PartitionResponse)tuple22._2();
        Assertions.assertEquals((Object)topicPartition, (Object)var14_22);
        Assertions.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)var15_23.error);
    }

    private ProduceResponse sendProduceRequest(int leaderId, ProduceRequest request) {
        return (ProduceResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    /*
     * WARNING - void declaration
     */
    private final ProduceResponse.PartitionResponse sendAndCheck$1(MemoryRecords memoryRecords, long expectedOffset, int partition$1, int leader$1) {
        void var10_10;
        void var9_9;
        TopicPartition topicPartition = new TopicPartition("topic", partition$1);
        ProduceRequestData forCurrentMagic_data = new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null);
        Object var11_6 = null;
        ProduceResponse produceResponse = this.sendProduceRequest(leader$1, (ProduceRequest)ProduceRequest.forMagic((byte)2, (ProduceRequestData)forCurrentMagic_data).build());
        Assertions.assertEquals((int)1, (int)produceResponse.responses().size());
        Tuple2 tuple2 = (Tuple2)CollectionConverters$.MODULE$.MapHasAsScala(produceResponse.responses()).asScala().head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)tuple2._2();
        Assertions.assertEquals((Object)topicPartition, (Object)var9_9);
        Assertions.assertEquals((Object)Errors.NONE, (Object)var10_10.error);
        Assertions.assertEquals((long)expectedOffset, (long)var10_10.baseOffset);
        Assertions.assertEquals((long)-1L, (long)var10_10.logAppendTime);
        Assertions.assertTrue((boolean)var10_10.recordErrors.isEmpty());
        return var10_10;
    }

    private static final MemoryRecords createRecords$1(byte magicValue, long timestamp, CompressionType codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    public static final /* synthetic */ void $anonfun$testProduceWithInvalidTimestamp$1(ProduceResponse.RecordError recordError) {
        Assertions.assertNotNull((Object)recordError.message);
    }

    public static final /* synthetic */ boolean $anonfun$testProduceToNonReplica$1(int leader$2, KafkaServer x$4) {
        return x$4.config().brokerId() != leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$testCorruptLz4ProduceRequest$1(MetricName x$7) {
        return x$7.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMessageCrcRecordsPerSec()));
    }
}

