/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeoutException;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.FinalizedFeatureCache;
import kafka.server.FinalizedFeatureChangeListener;
import kafka.server.FinalizedFeaturesAndEpoch;
import kafka.zk.FeatureZNode;
import kafka.zk.FeatureZNodeStatus;
import kafka.zk.ZkVersion$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.FinalizedVersionRange;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005]3A\u0001D\u0007\u0001%!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0005=!)!\u0005\u0001C\u0005G!)q\u0005\u0001C\u0005Q!)\u0011\b\u0001C\u0001u!)1\n\u0001C\u0001u!)Q\n\u0001C\u0001u!)q\n\u0001C\u0001u!)\u0011\u000b\u0001C\u0001u!)1\u000b\u0001C\u0001u!)Q\u000b\u0001C\u0001u\t\u0011c)\u001b8bY&TX\r\u001a$fCR,(/Z\"iC:<W\rT5ti\u0016tWM\u001d+fgRT!AD\b\u0002\rM,'O^3s\u0015\u0005\u0001\u0012!B6bM.\f7\u0001A\n\u0003\u0001M\u0001\"\u0001F\f\u000e\u0003UQ!AF\b\u0002\u0005i\\\u0017B\u0001\r\u0016\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011!D\u0001\u0015GJ,\u0017\r^3Ce>\\WM\u001d$fCR,(/Z:\u0015\u0003}\u0001\"\u0001\b\u0011\n\u0005\u0005j!A\u0004\"s_.,'OR3biV\u0014Xm]\u0001\u0018GJ,\u0017\r^3GS:\fG.\u001b>fI\u001a+\u0017\r^;sKN$\u0012\u0001\n\t\u00039\u0015J!AJ\u0007\u00033\u0019Kg.\u00197ju\u0016$g)Z1ukJ,7/\u00118e\u000bB|7\r[\u0001\u000fGJ,\u0017\r^3MSN$XM\\3s)\rIC&\r\t\u00039)J!aK\u0007\u0003=\u0019Kg.\u00197ju\u0016$g)Z1ukJ,7\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014\b\"B\u0017\u0005\u0001\u0004q\u0013!B2bG\",\u0007C\u0001\u000f0\u0013\t\u0001TBA\u000bGS:\fG.\u001b>fI\u001a+\u0017\r^;sK\u000e\u000b7\r[3\t\u000bI\"\u0001\u0019A\u001a\u0002)\u0015D\b/Z2uK\u0012\u001c\u0015m\u00195f\u0007>tG/\u001a8u!\r!t\u0007J\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t1q\n\u001d;j_:\fQ\u0005^3ti&s\u0017\u000e^*vG\u000e,7o]!oI:{G/\u001b4jG\u0006$\u0018n\u001c8Tk\u000e\u001cWm]:\u0015\u0003m\u0002\"\u0001\u000e\u001f\n\u0005u*$\u0001B+oSRD#!B \u0011\u0005\u0001KU\"A!\u000b\u0005\t\u001b\u0015aA1qS*\u0011A)R\u0001\bUV\u0004\u0018\u000e^3s\u0015\t1u)A\u0003kk:LGOC\u0001I\u0003\ry'oZ\u0005\u0003\u0015\u0006\u0013A\u0001V3ti\u0006aC/Z:u\r\u0016\fG/\u001e:f5:{G-\u001a#fY\u0016$XMT8uS\u001aL7-\u0019;j_:\u0004&o\\2fgNLgn\u001a\u0015\u0003\r}\nq\u0006^3ti\u001a+\u0017\r^;sKjsu\u000eZ3ESN\f'\r\\5oO:{G/\u001b4jG\u0006$\u0018n\u001c8Qe>\u001cWm]:j]\u001eD#aB \u0002[Q,7\u000f^\"bG\",W\u000b\u001d3bi\u0016<\u0016-\u001b;GC&d7OR8s+:\u0014X-Y2iC\ndWMV3sg&|g\u000e\u000b\u0002\t\u007f\u0005QC/Z:u\u0013:LGOR1jYV\u0014X\rR;f)>4U-\u0019;ve\u0016LenY8na\u0006$\u0018NY5mSRL\bFA\u0005@\u0003\r\"Xm\u001d;J]&$h)Y5mkJ,G)^3U_&sg/\u00197jI^\u000b\u0017\u000e\u001e+j[\u0016D#AC \u0002eQ,7\u000f\u001e(pi&4\u0017nY1uS>tg)Y5mkJ,G)^3U_\u001a+\u0017\r^;sK&s7m\\7qCRL'-\u001b7jifD#aC ")
public class FinalizedFeatureChangeListenerTest
extends ZooKeeperTestHarness {
    /*
     * WARNING - void declaration
     */
    private BrokerFeatures createBrokerFeatures() {
        void var2_2;
        scala.collection.immutable.Map supportedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)new SupportedVersionRange(1, 4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_2"), (Object)new SupportedVersionRange(1, 3))}));
        BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault();
        brokerFeatures.setSupportedFeatures(Features.supportedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)supportedFeaturesMap).asJava()));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private FinalizedFeaturesAndEpoch createFinalizedFeatures() {
        void var4_4;
        scala.collection.immutable.Map finalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)new FinalizedVersionRange(2, 3))}));
        Features finalizedFeatures = Features.finalizedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)finalizedFeaturesMap).asJava());
        this.zkClient().createFeatureZNode(new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, finalizedFeatures));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion("/feature");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assertions.assertNotEquals((int)n, (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var4_4.isEmpty());
        return new FinalizedFeaturesAndEpoch(finalizedFeatures, (long)n);
    }

    /*
     * WARNING - void declaration
     */
    private FinalizedFeatureChangeListener createListener(FinalizedFeatureCache cache, Option<FinalizedFeaturesAndEpoch> expectedCacheContent) {
        void var3_3;
        FinalizedFeatureChangeListener listener = new FinalizedFeatureChangeListener(cache, this.zkClient());
        Assertions.assertFalse((boolean)listener.isListenerInitiated());
        Assertions.assertTrue((boolean)cache.isEmpty());
        listener.initOrThrow(15000L);
        Assertions.assertTrue((boolean)listener.isListenerInitiated());
        if (expectedCacheContent.isDefined()) {
            Option mayBeNewCacheContent = cache.get();
            Assertions.assertFalse((boolean)mayBeNewCacheContent.isEmpty());
            FinalizedFeaturesAndEpoch newCacheContent = (FinalizedFeaturesAndEpoch)mayBeNewCacheContent.get();
            Assertions.assertEquals((Object)((FinalizedFeaturesAndEpoch)expectedCacheContent.get()).features(), (Object)newCacheContent.features());
            Assertions.assertEquals((long)((FinalizedFeaturesAndEpoch)expectedCacheContent.get()).epoch(), (long)newCacheContent.epoch());
        } else {
            Assertions.assertTrue((boolean)cache.get().isEmpty());
        }
        return var3_3;
    }

    @Test
    public void testInitSuccessAndNotificationSuccess() {
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        FinalizedFeatureCache cache = new FinalizedFeatureCache(brokerFeatures);
        FinalizedFeatureChangeListener listener = this.createListener(cache, (Option<FinalizedFeaturesAndEpoch>)new Some((Object)initialFinalizedFeatures));
        this.updateAndCheckCache$1(Features.finalizedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)new FinalizedVersionRange(2, 4))}))).asJava()), initialFinalizedFeatures, cache, listener);
        this.updateAndCheckCache$1(Features.finalizedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)new FinalizedVersionRange(2, 4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_2"), (Object)new FinalizedVersionRange(1, 3))}))).asJava()), initialFinalizedFeatures, cache, listener);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFeatureZNodeDeleteNotificationProcessing() {
        void var6_6;
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        FinalizedFeatureCache cache = new FinalizedFeatureCache(brokerFeatures);
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        FinalizedFeatureChangeListener listener = this.createListener(cache, (Option<FinalizedFeaturesAndEpoch>)new Some((Object)initialFinalizedFeatures));
        this.zkClient().deleteFeatureZNode();
        Tuple2 tuple2 = this.zkClient().getDataAndVersion("/feature");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeDeletedBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assertions.assertEquals((int)n, (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertTrue((boolean)var6_6.isEmpty());
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!cache.isEmpty()) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Timed out waiting for FinalizedFeatureCache to become empty");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Assertions.assertTrue((boolean)listener.isListenerInitiated());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFeatureZNodeDisablingNotificationProcessing() {
        void var7_7;
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        FinalizedFeatureCache cache = new FinalizedFeatureCache(brokerFeatures);
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        scala.collection.immutable.Map updatedFinalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        Features updatedFinalizedFeatures = Features.finalizedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)updatedFinalizedFeaturesMap).asJava());
        this.zkClient().updateFeatureZNode(new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Disabled$.MODULE$, updatedFinalizedFeatures));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion("/feature");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeNewBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assertions.assertNotEquals((int)n, (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var7_7.isEmpty());
        Assertions.assertTrue(((long)n > initialFinalizedFeatures.epoch() ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)cache.get().isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCacheUpdateWaitFailsForUnreachableVersion() {
        void var7_7;
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        FinalizedFeatureCache cache = new FinalizedFeatureCache(this.createBrokerFeatures());
        FinalizedFeatureChangeListener listener = this.createListener(cache, (Option<FinalizedFeaturesAndEpoch>)new Some((Object)initialFinalizedFeatures));
        Assertions.assertThrows(TimeoutException.class, () -> cache.waitUntilEpochOrThrow(initialFinalizedFeatures.epoch() + 1L, 15000L));
        scala.collection.immutable.Map updatedFinalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        Features updatedFinalizedFeatures = Features.finalizedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)updatedFinalizedFeaturesMap).asJava());
        this.zkClient().updateFeatureZNode(new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Disabled$.MODULE$, updatedFinalizedFeatures));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion("/feature");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeNewBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assertions.assertNotEquals((int)n, (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var7_7.isEmpty());
        Assertions.assertTrue(((long)n > initialFinalizedFeatures.epoch() ? 1 : 0) != 0);
        Assertions.assertThrows(TimeoutException.class, () -> cache.waitUntilEpochOrThrow((long)n, 15000L));
        Assertions.assertTrue((boolean)cache.get().isEmpty());
        Assertions.assertTrue((boolean)listener.isListenerInitiated());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInitFailureDueToFeatureIncompatibility() {
        void var6_6;
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        FinalizedFeatureCache cache = new FinalizedFeatureCache(brokerFeatures);
        scala.collection.immutable.Map incompatibleFinalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)new FinalizedVersionRange(2, 5))}));
        Features incompatibleFinalizedFeatures = Features.finalizedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)incompatibleFinalizedFeaturesMap).asJava());
        this.zkClient().createFeatureZNode(new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, incompatibleFinalizedFeatures));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion("/feature");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assertions.assertNotEquals((int)n, (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var6_6.isEmpty());
        CountDownLatch exitLatch = new CountDownLatch(1);
        Exit.setExitProcedure((x$7, x$8) -> exitLatch.countDown());
        try {
            FinalizedFeatureChangeListener listener = new FinalizedFeatureChangeListener(cache, this.zkClient());
            Assertions.assertFalse((boolean)listener.isListenerInitiated());
            Assertions.assertTrue((boolean)cache.isEmpty());
            Assertions.assertThrows(TimeoutException.class, () -> listener.initOrThrow(5000L));
            exitLatch.await();
            Assertions.assertFalse((boolean)listener.isListenerInitiated());
            Assertions.assertTrue((boolean)listener.isListenerDead());
            Assertions.assertTrue((boolean)cache.isEmpty());
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void testInitFailureDueToInvalidWaitTime() {
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        FinalizedFeatureCache cache = new FinalizedFeatureCache(brokerFeatures);
        FinalizedFeatureChangeListener listener = new FinalizedFeatureChangeListener(cache, this.zkClient());
        Assertions.assertThrows(IllegalArgumentException.class, () -> listener.initOrThrow(0L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> listener.initOrThrow(-1L));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNotificationFailureDueToFeatureIncompatibility() {
        void var9_9;
        BrokerFeatures brokerFeatures = this.createBrokerFeatures();
        FinalizedFeatureCache cache = new FinalizedFeatureCache(brokerFeatures);
        FinalizedFeaturesAndEpoch initialFinalizedFeatures = this.createFinalizedFeatures();
        FinalizedFeatureChangeListener listener = this.createListener(cache, (Option<FinalizedFeaturesAndEpoch>)new Some((Object)initialFinalizedFeatures));
        CountDownLatch exitLatch = new CountDownLatch(1);
        Exit.setExitProcedure((x$9, x$10) -> exitLatch.countDown());
        scala.collection.immutable.Map incompatibleFinalizedFeaturesMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"feature_1"), (Object)new FinalizedVersionRange(((SupportedVersionRange)brokerFeatures.supportedFeatures().get("feature_1")).min(), (short)(((SupportedVersionRange)brokerFeatures.supportedFeatures().get("feature_1")).max() + 1)))}));
        Features incompatibleFinalizedFeatures = Features.finalizedFeatures((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)incompatibleFinalizedFeaturesMap).asJava());
        this.zkClient().updateFeatureZNode(new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, incompatibleFinalizedFeatures));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion("/feature");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeIncompatibleBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assertions.assertNotEquals((int)n, (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var9_9.isEmpty());
        try {
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!FinalizedFeatureChangeListenerTest.$anonfun$testNotificationFailureDueToFeatureIncompatibility$2(exitLatch, listener, cache, initialFinalizedFeatures)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)"Timed out waiting for listener death and FinalizedFeatureCache to be updated");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateAndCheckCache$1(Features finalizedFeatures, FinalizedFeaturesAndEpoch initialFinalizedFeatures$1, FinalizedFeatureCache cache$1, FinalizedFeatureChangeListener listener$1) {
        void var6_6;
        this.zkClient().updateFeatureZNode(new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, finalizedFeatures));
        Tuple2 tuple2 = this.zkClient().getDataAndVersion("/feature");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeNewBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        Assertions.assertNotEquals((int)n, (int)ZkVersion$.MODULE$.UnknownVersion());
        Assertions.assertFalse((boolean)var6_6.isEmpty());
        Assertions.assertTrue(((long)n > initialFinalizedFeatures$1.epoch() ? 1 : 0) != 0);
        cache$1.waitUntilEpochOrThrow((long)n, 15000L);
        Assertions.assertEquals((Object)new FinalizedFeaturesAndEpoch(finalizedFeatures, (long)n), (Object)cache$1.get().get());
        Assertions.assertTrue((boolean)listener$1.isListenerInitiated());
    }

    public static final /* synthetic */ boolean $anonfun$testFeatureZNodeDeleteNotificationProcessing$1(FinalizedFeatureCache cache$2) {
        return cache$2.isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testFeatureZNodeDeleteNotificationProcessing$2() {
        return "Timed out waiting for FinalizedFeatureCache to become empty";
    }

    public static final /* synthetic */ boolean $anonfun$testNotificationFailureDueToFeatureIncompatibility$2(CountDownLatch exitLatch$2, FinalizedFeatureChangeListener listener$4, FinalizedFeatureCache cache$4, FinalizedFeaturesAndEpoch initialFinalizedFeatures$3) {
        return exitLatch$2.getCount() == 0L && !listener$4.isListenerInitiated() && listener$4.isListenerDead() && ((FinalizedFeaturesAndEpoch)cache$4.get().get()).equals((Object)initialFinalizedFeatures$3);
    }

    public static final /* synthetic */ String $anonfun$testNotificationFailureDueToFeatureIncompatibility$3() {
        return "Timed out waiting for listener death and FinalizedFeatureCache to be updated";
    }
}

