/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.log.LogConfig$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Md\u0001B\u000b\u0017\u0001mAQ\u0001\t\u0001\u0005\u0002\u0005BQa\t\u0001\u0005B\u0011Bqa\u000b\u0001A\u0002\u0013%A\u0006C\u0004@\u0001\u0001\u0007I\u0011\u0002!\t\r\u0019\u0003\u0001\u0015)\u0003.\u0011\u001d9\u0005A1A\u0005\n!Ca!\u0015\u0001!\u0002\u0013I\u0005b\u0002*\u0001\u0005\u0004%Ia\u0015\u0005\u00075\u0002\u0001\u000b\u0011\u0002+\t\u000fm\u0003!\u0019!C\u00059\"1Q\r\u0001Q\u0001\nuCQA\u001a\u0001\u0005\n\u001dDQA\u001b\u0001\u0005\n-DQA\u001c\u0001\u0005B=DQa\u001f\u0001\u0005B=Dq!!\u0001\u0001\t#\n\u0019\u0001\u0003\u0004\u0002\u0016\u0001!Ia\u001c\u0005\b\u0003/\u0001A\u0011BA\r\u0011\u0019\t\t\u0005\u0001C\u0001_\"9\u00111\n\u0001\u0005\n\u00055#\u0001\u0007$fi\u000eD'+Z9vKN$X*\u0019=CsR,7\u000fV3ti*\u0011q\u0003G\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003e\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00019A\u0011QDH\u0007\u0002-%\u0011qD\u0006\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012A\t\t\u0003;\u0001\t1B\u0019:pW\u0016\u00148i\\;oiV\tQ\u0005\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsEA\u0002J]R\f\u0001\u0002\u001d:pIV\u001cWM]\u000b\u0002[A!afN\u001d:\u001b\u0005y#BA\u00161\u0015\t\t$'A\u0004dY&,g\u000e^:\u000b\u0005e\u0019$B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001eL!\u0001O\u0018\u0003\u001b-\u000bgm[1Qe>$WoY3s!\r1#\bP\u0005\u0003w\u001d\u0012Q!\u0011:sCf\u0004\"AJ\u001f\n\u0005y:#\u0001\u0002\"zi\u0016\fA\u0002\u001d:pIV\u001cWM]0%KF$\"!\u0011#\u0011\u0005\u0019\u0012\u0015BA\"(\u0005\u0011)f.\u001b;\t\u000f\u0015#\u0011\u0011!a\u0001[\u0005\u0019\u0001\u0010J\u0019\u0002\u0013A\u0014x\u000eZ;dKJ\u0004\u0013!\u0003;fgR$v\u000e]5d+\u0005I\u0005C\u0001&P\u001b\u0005Y%B\u0001'N\u0003\u0011a\u0017M\\4\u000b\u00039\u000bAA[1wC&\u0011\u0001k\u0013\u0002\u0007'R\u0014\u0018N\\4\u0002\u0015Q,7\u000f\u001e+pa&\u001c\u0007%\u0001\nuKN$Hk\u001c9jGB\u000b'\u000f^5uS>tW#\u0001+\u0011\u0005UCV\"\u0001,\u000b\u0005]\u0013\u0014AB2p[6|g.\u0003\u0002Z-\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0005;fgR$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013\u0001C7fgN\fw-Z:\u0016\u0003u\u00032AX2:\u001b\u0005y&B\u00011b\u0003%IW.\\;uC\ndWM\u0003\u0002cO\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0011|&AC%oI\u0016DX\rZ*fc\u0006IQ.Z:tC\u001e,7\u000fI\u0001\u000f[VdG/\u001b\"zi\u0016\f%O]1z)\tI\u0004\u000eC\u0003j\u0019\u0001\u0007Q%\u0001\u0004mK:<G\u000f[\u0001\r_:,')\u001f;f\u0003J\u0014\u0018-\u001f\u000b\u0003s1DQ!\\\u0007A\u0002q\nQA^1mk\u0016\fQa]3u+B$\u0012!\u0011\u0015\u0003\u001dE\u0004\"A]=\u000e\u0003MT!\u0001^;\u0002\u0007\u0005\u0004\u0018N\u0003\u0002wo\u00069!.\u001e9ji\u0016\u0014(B\u0001=6\u0003\u0015QWO\\5u\u0013\tQ8O\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003\u001fu\u0004\"A\u001d@\n\u0005}\u001c(!C!gi\u0016\u0014X)Y2i\u0003]\u0011'o\\6feB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7\u000fF\u0002B\u0003\u000bAq!a\u0002\u0011\u0001\u0004\tI!\u0001\u0006qe>\u0004XM\u001d;jKN\u0004B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001fi\u0015\u0001B;uS2LA!a\u0005\u0002\u000e\tQ\u0001K]8qKJ$\u0018.Z:\u0002\u0019\r\u0014X-\u0019;f)>\u0004\u0018nY:\u0002!M,g\u000e\u001a$fi\u000eD'+Z9vKN$HCBA\u000e\u0003g\t9\u0004\u0005\u0004\u0002\u001e\u0005\r\u0012qE\u0007\u0003\u0003?Q1!!\tW\u0003!\u0011X-];fgR\u001c\u0018\u0002BA\u0013\u0003?\u0011QBR3uG\"\u0014Vm\u001d9p]N,\u0007\u0003BA\u0015\u0003_i!!a\u000b\u000b\u0007\u00055b+\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003c\tYCA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\u0007\u0003k\u0011\u0002\u0019A\u0013\u0002\u00111,\u0017\rZ3s\u0013\u0012Dq!!\u000f\u0013\u0001\u0004\tY$A\u0004sKF,Xm\u001d;\u0011\t\u0005u\u0011QH\u0005\u0005\u0003\u007f\tyB\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0001\u000euKN$8i\u001c8tk6,W*\u001e7uSBdWMU3d_J$7\u000fK\u0002\u0014\u0003\u000b\u00022A]A$\u0013\r\tIe\u001d\u0002\u0005)\u0016\u001cH/A\tfqB,7\r\u001e(fqR\u0014VmY8sIN$R!QA(\u0003SBq!!\u0015\u0015\u0001\u0004\t\u0019&\u0001\u0005fqB,7\r^3e!\u0015\t)&!\u001a:\u001d\u0011\t9&!\u0019\u000f\t\u0005e\u0013qL\u0007\u0003\u00037R1!!\u0018\u001b\u0003\u0019a$o\\8u}%\t\u0001&C\u0002\u0002d\u001d\nq\u0001]1dW\u0006<W-C\u0002e\u0003OR1!a\u0019(\u0011\u001d\tY\u0007\u0006a\u0001\u0003[\n1BZ3uG\"|eMZ:fiB\u0019a%a\u001c\n\u0007\u0005EtE\u0001\u0003M_:<\u0007")
public class FetchRequestMaxBytesTest
extends BaseRequestTest {
    private KafkaProducer<byte[], byte[]> producer = null;
    private final String testTopic;
    private final TopicPartition testTopicPartition = new TopicPartition(this.testTopic(), 0);
    private final IndexedSeq<byte[]> messages = (IndexedSeq)package$.MODULE$.IndexedSeq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new byte[][]{this.multiByteArray(1), this.multiByteArray(500), this.multiByteArray(1040), this.multiByteArray(500), this.multiByteArray(50)}));

    @Override
    public int brokerCount() {
        return 1;
    }

    private KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    private void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    private String testTopic() {
        return this.testTopic;
    }

    private TopicPartition testTopicPartition() {
        return this.testTopicPartition;
    }

    private IndexedSeq<byte[]> messages() {
        return this.messages;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] multiByteArray(int length) {
        void var2_2;
        byte[] array = new byte[length];
        ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.byteArrayOps(array)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            array$1[i] = (byte)(i % 5);
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] oneByteArray(byte value) {
        void var2_2;
        byte[] array = new byte[]{value};
        return var2_2;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), SecurityProtocol.PLAINTEXT), -1, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false));
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.producer() != null) {
            this.producer().close();
        }
        super.tearDown();
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        super.brokerPropertyOverrides(properties);
        properties.put(KafkaConfig$.MODULE$.FetchMaxBytes(), "1024");
    }

    private void createTopics() {
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), Integer.toString(1));
        this.createTopic(this.testTopic(), 1, 1, topicConfig);
        this.messages().indices().foreach((Function1 & Serializable)i -> FetchRequestMaxBytesTest.$anonfun$createTopics$1(this, BoxesRunTime.unboxToInt((Object)i)));
    }

    private FetchResponse<MemoryRecords> sendFetchRequest(int leaderId, FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    @Test
    public void testConsumeMultipleRecords() {
        this.createTopics();
        this.expectNextRecords((IndexedSeq<byte[]>)((IndexedSeq)package$.MODULE$.IndexedSeq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new byte[][]{(byte[])this.messages().apply(0), (byte[])this.messages().apply(1)}))), 0L);
        this.expectNextRecords((IndexedSeq<byte[]>)((IndexedSeq)package$.MODULE$.IndexedSeq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new byte[][]{(byte[])this.messages().apply(2)}))), 2L);
        this.expectNextRecords((IndexedSeq<byte[]>)((IndexedSeq)package$.MODULE$.IndexedSeq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new byte[][]{(byte[])this.messages().apply(3), (byte[])this.messages().apply(4)}))), 3L);
    }

    private void expectNextRecords(IndexedSeq<byte[]> expected, long fetchOffset) {
        Iterable records = ((AbstractRecords)((FetchResponse.PartitionData)this.sendFetchRequest(0, FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.testTopicPartition()), (Object)new FetchRequest.PartitionData(fetchOffset, 0L, Integer.MAX_VALUE, Optional.empty()))}))).asJava()).build((short)3)).responseData().get(this.testTopicPartition())).records()).records();
        Assertions.assertNotNull((Object)records);
        List recordsList = CollectionConverters$.MODULE$.IterableHasAsScala(records).asScala().toList();
        Assertions.assertEquals((int)expected.size(), (int)recordsList.size());
        ((List)recordsList.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            FetchRequestMaxBytesTest.$anonfun$expectNextRecords$1(expected, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ RecordMetadata $anonfun$createTopics$1(FetchRequestMaxBytesTest $this, int i) {
        Object var5_3;
        byte oneByteArray_value = (byte)i;
        byte[] oneByteArray_array = new byte[]{oneByteArray_value};
        void v0 = var5_3;
        var5_3 = null;
        ProducerRecord record = new ProducerRecord($this.testTopic(), Predef$.MODULE$.int2Integer(0), (Object)v0, $this.messages().apply(i));
        Future future = $this.producer().send(record);
        $this.producer().flush();
        return (RecordMetadata)future.get();
    }

    public static final /* synthetic */ void $anonfun$expectNextRecords$1(IndexedSeq expected$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            Record record = (Record)x0$1._1();
            int i = x0$1._2$mcI$sp();
            ByteBuffer buffer = record.value().duplicate();
            byte[] array = new byte[buffer.remaining()];
            buffer.get(array);
            Assertions.assertArrayEquals((byte[])((byte[])expected$1.apply(i)), (byte[])array, (String)new StringBuilder(37).append("expectNextRecords unexpected element ").append(i).toString());
            return;
        }
        throw new MatchError(null);
    }

    public FetchRequestMaxBytesTest() {
        this.testTopic = "testTopic";
    }
}

