/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005-a\u0001\u0002\u0007\u000e\u0001IAQa\u0006\u0001\u0005\u0002aAQA\u0007\u0001\u0005\u0002mAQa\f\u0001\u0005\nABQA\u0010\u0001\u0005\n}BQ!\u0011\u0001\u0005\u0002mAQa\u0011\u0001\u0005\n\u0011CQ\u0001\u0018\u0001\u0005\nuCQ!\u001a\u0001\u0005\u0002mAQa\u001a\u0001\u0005\n!DQa\u001b\u0001\u0005\n1Dq!\u001f\u0001\u0012\u0002\u0013%!PA\fEK2,G/\u001a+pa&\u001c7OU3rk\u0016\u001cH\u000fV3ti*\u0011abD\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003A\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001'A\u0011A#F\u0007\u0002\u001b%\u0011a#\u0004\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012!\u0007\t\u0003)\u0001\tA\u0004^3tiZ\u000bG.\u001b3EK2,G/\u001a+pa&\u001c'+Z9vKN$8\u000fF\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0011)f.\u001b;)\u0005\t\u0019\u0003C\u0001\u0013.\u001b\u0005)#B\u0001\u0014(\u0003\r\t\u0007/\u001b\u0006\u0003Q%\nqA[;qSR,'O\u0003\u0002+W\u0005)!.\u001e8ji*\tA&A\u0002pe\u001eL!AL\u0013\u0003\tQ+7\u000f^\u0001!m\u0006d\u0017\u000eZ1uKZ\u000bG.\u001b3EK2,G/\u001a+pa&\u001c'+Z9vKN$8\u000f\u0006\u0002\u001dc!)!g\u0001a\u0001g\u00059!/Z9vKN$\bC\u0001\u001b=\u001b\u0005)$B\u0001\u001c8\u0003!\u0011X-];fgR\u001c(B\u0001\u001d:\u0003\u0019\u0019w.\\7p]*\u0011\u0001C\u000f\u0006\u0003w-\na!\u00199bG\",\u0017BA\u001f6\u0005M!U\r\\3uKR{\u0007/[2t%\u0016\fX/Z:u\u0003\u001d2\u0018\r\\5eCR,g+\u00197jI\u0012+G.\u001a;f)>\u0004\u0018n\u0019*fcV,7\u000f^:XSRD\u0017\nZ:\u0015\u0005q\u0001\u0005\"\u0002\u001a\u0005\u0001\u0004\u0019\u0014\u0001\b;fgR,%O]8s\t\u0016dW\r^3U_BL7MU3rk\u0016\u001cHo\u001d\u0015\u0003\u000b\r\n\u0001E^1mS\u0012\fG/Z#se>\u0014H)\u001a7fi\u0016$v\u000e]5d%\u0016\fX/Z:ugR\u0019A$\u0012$\t\u000bI2\u0001\u0019A\u001a\t\u000b\u001d3\u0001\u0019\u0001%\u0002!\u0015D\b/Z2uK\u0012\u0014Vm\u001d9p]N,\u0007\u0003B%Q'Zs!A\u0013(\u0011\u0005-sR\"\u0001'\u000b\u00055\u000b\u0012A\u0002\u001fs_>$h(\u0003\u0002P=\u00051\u0001K]3eK\u001aL!!\u0015*\u0003\u00075\u000b\u0007O\u0003\u0002P=A\u0011\u0011\nV\u0005\u0003+J\u0013aa\u0015;sS:<\u0007CA,[\u001b\u0005A&BA-8\u0003!\u0001(o\u001c;pG>d\u0017BA.Y\u0005\u0019)%O]8sg\u00069c/\u00197jI\u0006$X-\u0012:s_J$U\r\\3uKR{\u0007/[2SKF,Xm\u001d;t/&$\b.\u00133t)\rabl\u0018\u0005\u0006e\u001d\u0001\ra\r\u0005\u0006\u000f\u001e\u0001\r\u0001\u0019\t\u0005\u0013B\u000bg\u000b\u0005\u0002cG6\tq'\u0003\u0002eo\t!Q+^5e\u0003E!Xm\u001d;O_R\u001cuN\u001c;s_2dWM\u001d\u0015\u0003\u0011\r\naC^1mS\u0012\fG/\u001a+pa&\u001c\u0017j\u001d#fY\u0016$X\r\u001a\u000b\u00039%DQA[\u0005A\u0002M\u000bQ\u0001^8qS\u000e\fqc]3oI\u0012+G.\u001a;f)>\u0004\u0018nY:SKF,Xm\u001d;\u0015\u00075\u0004\u0018\u000f\u0005\u00025]&\u0011q.\u000e\u0002\u0015\t\u0016dW\r^3U_BL7m\u001d*fgB|gn]3\t\u000bIR\u0001\u0019A\u001a\t\u000fIT\u0001\u0013!a\u0001g\u0006a1o\\2lKR\u001cVM\u001d<feB\u0011Ao^\u0007\u0002k*\u0011aoD\u0001\b]\u0016$xo\u001c:l\u0013\tAXO\u0001\u0007T_\u000e\\W\r^*feZ,'/A\u0011tK:$G)\u001a7fi\u0016$v\u000e]5dgJ+\u0017/^3ti\u0012\"WMZ1vYR$#'F\u0001|U\t\u0019HpK\u0001~!\rq\u0018qA\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0006y\t!\"\u00198o_R\fG/[8o\u0013\r\tIa \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class DeleteTopicsRequestTest
extends BaseRequestTest {
    @Test
    public void testValidDeleteTopicRequests() {
        int timeout = 10000;
        this.createTopic("topic-1", 1, 1, this.createTopic$default$4());
        this.validateValidDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList("topic-1")).setTimeoutMs(timeout)).build());
        this.createTopic("topic-3", 5, 2, this.createTopic$default$4());
        this.createTopic("topic-4", 1, 2, this.createTopic$default$4());
        this.validateValidDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList("topic-3", "topic-4")).setTimeoutMs(timeout)).build());
        this.createTopic("topic-7", 3, 2, this.createTopic$default$4());
        this.createTopic("topic-6", 1, 2, this.createTopic$default$4());
        Map<String, Uuid> ids = this.getTopicIds();
        this.validateValidDeleteTopicRequestsWithIds((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopics(Arrays.asList(new DeleteTopicsRequestData.DeleteTopicState().setTopicId((Uuid)ids.apply((Object)"topic-7")), new DeleteTopicsRequestData.DeleteTopicState().setTopicId((Uuid)ids.apply((Object)"topic-6")))).setTimeoutMs(timeout)).build());
    }

    private void validateValidDeleteTopicRequests(DeleteTopicsRequest request) {
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.controllerSocketServer());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.MapHasAsScala(response.errorCounts()).asScala().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$validateValidDeleteTopicRequests$1(x$1))).isEmpty(), (String)new StringBuilder(33).append("There should be no errors, found ").append(CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response.data().responses()).asScala()).toString());
        request.data().topicNames().forEach(topic -> this.validateTopicIsDeleted((String)topic));
    }

    private void validateValidDeleteTopicRequestsWithIds(DeleteTopicsRequest request) {
        DeleteTopicsResponse response2 = this.sendDeleteTopicsRequest(request, this.controllerSocketServer());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.MapHasAsScala(response2.errorCounts()).asScala().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$validateValidDeleteTopicRequestsWithIds$1(x$2))).isEmpty(), (String)new StringBuilder(33).append("There should be no errors, found ").append(CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)response2.data().responses()).asScala()).toString());
        response2.data().responses().forEach(response -> this.validateTopicIsDeleted(response.name()));
    }

    @Test
    public void testErrorDeleteTopicRequests() {
        int timeout = 30000;
        String timeoutTopic = "invalid-timeout";
        this.validateErrorDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList("invalid-topic")).setTimeoutMs(timeout)).build(), (Map<String, Errors>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalid-topic"), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION)}))));
        this.createTopic("partial-topic-1", 1, 1, this.createTopic$default$4());
        this.validateErrorDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList("partial-topic-1", "partial-invalid-topic")).setTimeoutMs(timeout)).build(), (Map<String, Errors>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-topic-1"), (Object)Errors.NONE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-invalid-topic"), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION)}))));
        this.createTopic("topic-id-1", 1, 1, this.createTopic$default$4());
        Uuid validId = (Uuid)this.getTopicIds().apply((Object)"topic-id-1");
        Uuid invalidId = Uuid.randomUuid();
        this.validateErrorDeleteTopicRequestsWithIds((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopics(Arrays.asList(new DeleteTopicsRequestData.DeleteTopicState().setTopicId(invalidId), new DeleteTopicsRequestData.DeleteTopicState().setTopicId(validId))).setTimeoutMs(timeout)).build(), (Map<Uuid, Errors>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)invalidId), (Object)Errors.UNKNOWN_TOPIC_ID), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)validId), (Object)Errors.NONE)}))));
        this.createTopic(timeoutTopic, 5, 2, this.createTopic$default$4());
        this.validateErrorDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList(timeoutTopic)).setTimeoutMs(0)).build(), (Map<String, Errors>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)timeoutTopic), (Object)Errors.REQUEST_TIMED_OUT)}))));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicsRequestTest.$anonfun$testErrorDeleteTopicRequests$1(this, timeoutTopic)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)DeleteTopicsRequestTest.$anonfun$testErrorDeleteTopicRequests$2(timeoutTopic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        this.validateTopicIsDeleted(timeoutTopic);
    }

    private void validateErrorDeleteTopicRequests(DeleteTopicsRequest request, Map<String, Errors> expectedResponse) {
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.controllerSocketServer());
        DeleteTopicsResponseData.DeletableTopicResultCollection errors = response.data().responses();
        int errorCount = BoxesRunTime.unboxToInt((Object)CollectionConverters$.MODULE$.MapHasAsScala(response.errorCounts()).asScala().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x$3, x$4) -> BoxesRunTime.boxToInteger((int)DeleteTopicsRequestTest.$anonfun$validateErrorDeleteTopicRequests$1(BoxesRunTime.unboxToInt((Object)x$3), x$4))));
        Assertions.assertEquals((int)expectedResponse.size(), (int)errorCount, (String)"The response size should match");
        expectedResponse.foreach((Function1 & Serializable)x0$1 -> {
            DeleteTopicsRequestTest.$anonfun$validateErrorDeleteTopicRequests$2(this, expectedResponse, errors, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void validateErrorDeleteTopicRequestsWithIds(DeleteTopicsRequest request, Map<Uuid, Errors> expectedResponse) {
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.controllerSocketServer());
        DeleteTopicsResponseData.DeletableTopicResultCollection responses = response.data().responses();
        Map errors = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)responses).asScala().map((Function1 & Serializable)result -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)result.topicId()), (Object)BoxesRunTime.boxToShort((short)result.errorCode())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map names = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)responses).asScala().map((Function1 & Serializable)result -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)result.topicId()), (Object)result.name()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        int errorCount = BoxesRunTime.unboxToInt((Object)CollectionConverters$.MODULE$.MapHasAsScala(response.errorCounts()).asScala().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x$5, x$6) -> BoxesRunTime.boxToInteger((int)DeleteTopicsRequestTest.$anonfun$validateErrorDeleteTopicRequestsWithIds$3(BoxesRunTime.unboxToInt((Object)x$5), x$6))));
        Assertions.assertEquals((int)expectedResponse.size(), (int)errorCount, (String)"The response size should match");
        expectedResponse.foreach((Function1 & Serializable)x0$1 -> {
            DeleteTopicsRequestTest.$anonfun$validateErrorDeleteTopicRequestsWithIds$4(this, expectedResponse, errors, names, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testNotController() {
        DeleteTopicsRequest request = (DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Collections.singletonList("not-controller")).setTimeoutMs(1000)).build();
        short error = this.sendDeleteTopicsRequest(request, this.notControllerSocketServer()).data().responses().find("not-controller").errorCode();
        Assertions.assertEquals((short)Errors.NOT_CONTROLLER.code(), (short)error, (String)"Expected controller error when routed incorrectly");
    }

    private void validateTopicIsDeleted(String topic) {
        Iterable metadata = CollectionConverters$.MODULE$.CollectionHasAsScala(((MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).asJava(), true).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))).topicMetadata()).asScala();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicsRequestTest.$anonfun$validateTopicIsDeleted$1(metadata, topic)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)DeleteTopicsRequestTest.$anonfun$validateTopicIsDeleted$3(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    private DeleteTopicsResponse sendDeleteTopicsRequest(DeleteTopicsRequest request, SocketServer socketServer) {
        return (DeleteTopicsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DeleteTopicsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private SocketServer sendDeleteTopicsRequest$default$2() {
        return this.controllerSocketServer();
    }

    public static final /* synthetic */ boolean $anonfun$validateValidDeleteTopicRequests$1(Tuple2 x$1) {
        Object object = x$1._1();
        Errors errors = Errors.NONE;
        return object == null ? errors != null : !object.equals(errors);
    }

    public static final /* synthetic */ boolean $anonfun$validateValidDeleteTopicRequestsWithIds$1(Tuple2 x$2) {
        Object object = x$2._1();
        Errors errors = Errors.NONE;
        return object == null ? errors != null : !object.equals(errors);
    }

    public static final /* synthetic */ boolean $anonfun$testErrorDeleteTopicRequests$1(DeleteTopicsRequestTest $this, String timeoutTopic$1) {
        return !((KafkaServer)$this.servers().head()).metadataCache().contains(timeoutTopic$1);
    }

    public static final /* synthetic */ String $anonfun$testErrorDeleteTopicRequests$2(String timeoutTopic$1) {
        return new StringBuilder(23).append("Topic ").append(timeoutTopic$1).append(" is never deleted").toString();
    }

    public static final /* synthetic */ int $anonfun$validateErrorDeleteTopicRequests$1(int x$3, Tuple2 x$4) {
        return x$3 + Predef$.MODULE$.Integer2int((Integer)x$4._2());
    }

    public static final /* synthetic */ void $anonfun$validateErrorDeleteTopicRequests$2(DeleteTopicsRequestTest $this, Map expectedResponse$1, DeleteTopicsResponseData.DeletableTopicResultCollection errors$1, Tuple2 x0$1) {
        block7: {
            block4: {
                String topic;
                block6: {
                    Errors errors;
                    Errors errors2;
                    block5: {
                        if (x0$1 == null) break block4;
                        topic = (String)x0$1._1();
                        Errors expectedError = (Errors)x0$1._2();
                        Assertions.assertEquals((short)((Errors)expectedResponse$1.apply((Object)topic)).code(), (short)errors$1.find(topic).errorCode(), (String)"The response error should match");
                        errors2 = expectedError;
                        errors = Errors.NONE;
                        if (errors2 != null) break block5;
                        if (errors != null) {
                            return;
                        }
                        break block6;
                    }
                    if (!errors2.equals(errors)) break block7;
                }
                $this.validateTopicIsDeleted(topic);
                return;
            }
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ int $anonfun$validateErrorDeleteTopicRequestsWithIds$3(int x$5, Tuple2 x$6) {
        return x$5 + Predef$.MODULE$.Integer2int((Integer)x$6._2());
    }

    public static final /* synthetic */ void $anonfun$validateErrorDeleteTopicRequestsWithIds$4(DeleteTopicsRequestTest $this, Map expectedResponse$2, Map errors$2, Map names$1, Tuple2 x0$1) {
        block7: {
            block4: {
                Uuid topic;
                block6: {
                    Errors errors;
                    Errors errors2;
                    block5: {
                        if (x0$1 == null) break block4;
                        topic = (Uuid)x0$1._1();
                        Errors expectedError = (Errors)x0$1._2();
                        Assertions.assertEquals((short)((Errors)expectedResponse$2.apply((Object)topic)).code(), (short)BoxesRunTime.unboxToShort((Object)errors$2.apply((Object)topic)), (String)"The response error should match");
                        errors2 = expectedError;
                        errors = Errors.NONE;
                        if (errors2 != null) break block5;
                        if (errors != null) {
                            return;
                        }
                        break block6;
                    }
                    if (!errors2.equals(errors)) break block7;
                }
                $this.validateTopicIsDeleted((String)names$1.apply((Object)topic));
                return;
            }
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicIsDeleted$2(String topic$1, MetadataResponse.TopicMetadata p) {
        if (p.topic().equals(topic$1)) {
            Errors errors = p.error();
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicIsDeleted$1(Iterable metadata$1, String topic$1) {
        return !metadata$1.exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$validateTopicIsDeleted$2(topic$1, p)));
    }

    public static final /* synthetic */ String $anonfun$validateTopicIsDeleted$3(String topic$1) {
        return new StringBuilder(27).append("The topic ").append(topic$1).append(" should not exist").toString();
    }
}

