/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.token.delegation;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import kafka.network.RequestChannel;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry$;
import kafka.security.authorizer.AuthorizerUtils$;
import kafka.server.CreateTokenResult;
import kafka.server.Defaults$;
import kafka.server.DelegationTokenManager;
import kafka.server.DelegationTokenManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t}c\u0001\u0002\u0017.\u0001YBQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013\u0005!\t\u0003\u0004Q\u0001\u0001\u0006Ia\u0011\u0005\b#\u0002\u0011\r\u0011\"\u0001S\u0011\u0019Q\u0006\u0001)A\u0005'\"91\f\u0001b\u0001\n\u0003a\u0006BB4\u0001A\u0003%Q\fC\u0004i\u0001\t\u0007I\u0011A5\t\rY\u0004\u0001\u0015!\u0003k\u0011\u001d9\bA1A\u0005\u0002aDq!a\u0001\u0001A\u0003%\u0011\u0010C\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0001\u0002\b!A\u0011\u0011\u0003\u0001!\u0002\u0013\tI\u0001C\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0001\u0002\b!A\u0011Q\u0003\u0001!\u0002\u0013\tI\u0001C\u0005\u0002\u0018\u0001\u0001\r\u0011\"\u0001\u0002\u001a!I\u00111\u0006\u0001A\u0002\u0013\u0005\u0011Q\u0006\u0005\t\u0003s\u0001\u0001\u0015)\u0003\u0002\u001c!I\u00111\b\u0001A\u0002\u0013\u0005\u0011Q\b\u0005\n\u0003\u0017\u0002\u0001\u0019!C\u0001\u0003\u001bB\u0001\"!\u0015\u0001A\u0003&\u0011q\b\u0005\f\u0003'\u0002\u0001\u0019!a\u0001\n\u0003\t)\u0006C\u0006\u0002^\u0001\u0001\r\u00111A\u0005\u0002\u0005}\u0003bCA2\u0001\u0001\u0007\t\u0011)Q\u0005\u0003/B\u0011\"!\u001a\u0001\u0001\u0004%\t!a\u001a\t\u0013\u0005U\u0004\u00011A\u0005\u0002\u0005]\u0004\u0002CA>\u0001\u0001\u0006K!!\u001b\t\u0013\u0005u\u0004\u00011A\u0005\u0002\u0005\u001d\u0001\"CA@\u0001\u0001\u0007I\u0011AAA\u0011!\t)\t\u0001Q!\n\u0005%\u0001bBAD\u0001\u0011\u0005\u0013\u0011\u0012\u0005\b\u0003C\u0003A\u0011IAE\u0011\u001d\tY\u000b\u0001C\u0001\u0003\u0013Cq!!.\u0001\t\u0003\tI\tC\u0004\u0002:\u0002!\t!!#\t\u000f\u0005u\u0006\u0001\"\u0001\u0002\n\"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005%\u0005bBAc\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003\u0013\u0004A\u0011BAf\u0011\u001d\u00119\u0003\u0001C\u0001\u0003\u0013CqAa\u000b\u0001\t\u0013\u0011i\u0003C\u0004\u00034\u0001!IA!\u000e\t\u000f\tu\u0002\u0001\"\u0003\u0003@\tQB)\u001a7fO\u0006$\u0018n\u001c8U_.,g.T1oC\u001e,'\u000fV3ti*\u0011afL\u0001\u000bI\u0016dWmZ1uS>t'B\u0001\u00192\u0003\u0015!xn[3o\u0015\t\u00114'\u0001\u0005tK\u000e,(/\u001b;z\u0015\u0005!\u0014!B6bM.\f7\u0001A\n\u0003\u0001]\u0002\"\u0001O\u001e\u000e\u0003eR!AO\u001a\u0002\u0005i\\\u0017B\u0001\u001f:\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012a\u0010\t\u0003\u0001\u0002i\u0011!L\u0001\u0005i&lW-F\u0001D!\t!e*D\u0001F\u0015\t1u)A\u0003vi&d7O\u0003\u0002I\u0013\u000611m\\7n_:T!\u0001\u000e&\u000b\u0005-c\u0015AB1qC\u000eDWMC\u0001N\u0003\ry'oZ\u0005\u0003\u001f\u0016\u0013\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0006_^tWM]\u000b\u0002'B\u0011A\u000bW\u0007\u0002+*\u0011akV\u0001\u0005CV$\bN\u0003\u00023\u000f&\u0011\u0011,\u0016\u0002\u000f\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0003\u0019ywO\\3sA\u00059!/\u001a8fo\u0016\u0014X#A/\u0011\u0007y+7+D\u0001`\u0015\t\u0001\u0017-A\u0005j[6,H/\u00192mK*\u0011!mY\u0001\u000bG>dG.Z2uS>t'\"\u00013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019|&\u0001\u0002'jgR\f\u0001B]3oK^,'\u000fI\u0001\u000ei>\\WM\\'b]\u0006<WM]:\u0016\u0003)\u00042a\u001b8q\u001b\u0005a'BA7b\u0003\u001diW\u000f^1cY\u0016L!a\u001c7\u0003\r\t+hMZ3s!\t\tH/D\u0001s\u0015\t\u00198'\u0001\u0004tKJ4XM]\u0005\u0003kJ\u0014a\u0003R3mK\u001e\fG/[8o)>\\WM\\'b]\u0006<WM]\u0001\u000fi>\\WM\\'b]\u0006<WM]:!\u0003%\u0019Xm\u0019:fi.+\u00170F\u0001z!\tQx0D\u0001|\u0015\taX0\u0001\u0003mC:<'\"\u0001@\u0002\t)\fg/Y\u0005\u0004\u0003\u0003Y(AB*ue&tw-\u0001\u0006tK\u000e\u0014X\r^&fs\u0002\nA#\\1y\u0019&4W\rV5nK6\u001bH)\u001a4bk2$XCAA\u0005!\u0011\tY!!\u0004\u000e\u0003\rL1!a\u0004d\u0005\u0011auN\\4\u0002+5\f\u0007\u0010T5gKRKW.Z't\t\u00164\u0017-\u001e7uA\u0005\u0011\"/\u001a8foRKW.Z't\t\u00164\u0017-\u001e7u\u0003M\u0011XM\\3x)&lW-T:EK\u001a\fW\u000f\u001c;!\u0003)!xn[3o\u0007\u0006\u001c\u0007.Z\u000b\u0003\u00037\u0001B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#A\u0005j]R,'O\\1mg*\u0019a&!\n\u000b\u0005A:\u0016\u0002BA\u0015\u0003?\u0011A\u0003R3mK\u001e\fG/[8o)>\\WM\\\"bG\",\u0017A\u0004;pW\u0016t7)Y2iK~#S-\u001d\u000b\u0005\u0003_\t)\u0004\u0005\u0003\u0002\f\u0005E\u0012bAA\u001aG\n!QK\\5u\u0011%\t9$EA\u0001\u0002\u0004\tY\"A\u0002yIE\n1\u0002^8lK:\u001c\u0015m\u00195fA\u0005)\u0001O]8qgV\u0011\u0011q\b\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011QI?\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0013\n\u0019E\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0011\u0002\u001d:paN|F%Z9\u0015\t\u0005=\u0012q\n\u0005\n\u0003o!\u0012\u0011!a\u0001\u0003\u007f\ta\u0001\u001d:paN\u0004\u0013!E2sK\u0006$X\rV8lK:\u0014Vm];miV\u0011\u0011q\u000b\t\u0004c\u0006e\u0013bAA.e\n\t2I]3bi\u0016$vn[3o%\u0016\u001cX\u000f\u001c;\u0002+\r\u0014X-\u0019;f)>\\WM\u001c*fgVdGo\u0018\u0013fcR!\u0011qFA1\u0011%\t9dFA\u0001\u0002\u0004\t9&\u0001\nde\u0016\fG/\u001a+pW\u0016t'+Z:vYR\u0004\u0013!B3se>\u0014XCAA5!\u0011\tY'!\u001d\u000e\u0005\u00055$bAA8\u000f\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0002t\u00055$AB#se>\u00148/A\u0005feJ|'o\u0018\u0013fcR!\u0011qFA=\u0011%\t9DGA\u0001\u0002\u0004\tI'\u0001\u0004feJ|'\u000fI\u0001\u0010Kb\u0004\u0018N]=US6,7\u000b^1na\u0006\u0019R\r\u001f9jef$\u0016.\\3Ti\u0006l\u0007o\u0018\u0013fcR!\u0011qFAB\u0011%\t9$HA\u0001\u0002\u0004\tI!\u0001\tfqBL'/\u001f+j[\u0016\u001cF/Y7qA\u0005)1/\u001a;VaR\u0011\u0011q\u0006\u0015\u0004?\u00055\u0005\u0003BAH\u0003;k!!!%\u000b\t\u0005M\u0015QS\u0001\u0004CBL'\u0002BAL\u00033\u000bqA[;qSR,'OC\u0002\u0002\u001c2\u000bQA[;oSRLA!a(\u0002\u0012\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3\u0001IAS!\u0011\ty)a*\n\t\u0005%\u0016\u0011\u0013\u0002\n\u0003\u001a$XM]#bG\"\fA\u0006^3tiR{7.\u001a8SKF,Xm\u001d;t/&$\b\u000eR3mK\u001e\fG/[8o)>\\WM\u001c#jg\u0006\u0014G.\u001a3)\u0007\u0005\ny\u000b\u0005\u0003\u0002\u0010\u0006E\u0016\u0002BAZ\u0003#\u0013A\u0001V3ti\u0006yA/Z:u\u0007J,\u0017\r^3U_.,g\u000eK\u0002#\u0003_\u000ba\u0002^3tiJ+g.Z<U_.,g\u000eK\u0002$\u0003_\u000bq\u0002^3ti\u0016C\b/\u001b:f)>\\WM\u001c\u0015\u0004I\u0005=\u0016a\u0005;fgR\u0014V-\\8wKR{7.\u001a8I[\u0006\u001c\u0007fA\u0013\u00020\u0006\tB/Z:u\t\u0016\u001c8M]5cKR{7.\u001a8)\u0007\u0019\ny+A\u0005hKR$vn[3ogRa\u0011QZAv\u0003_\fyP!\b\u0003\"A1\u0011qZAp\u0003GtA!!5\u0002\\:!\u00111[Am\u001b\t\t)NC\u0002\u0002XV\na\u0001\u0010:p_Rt\u0014\"\u00013\n\u0007\u0005u7-A\u0004qC\u000e\\\u0017mZ3\n\u0007\u0019\f\tOC\u0002\u0002^\u000e\u0004B!!:\u0002h6\u0011\u00111E\u0005\u0005\u0003S\f\u0019CA\bEK2,w-\u0019;j_:$vn[3o\u0011\u0019\tio\na\u0001a\u0006aAo\\6f]6\u000bg.Y4fe\"9\u0011\u0011_\u0014A\u0002\u0005M\u0018!D1dY\u0006+H\u000f[8sSj,'\u000f\u0005\u0003\u0002v\u0006mXBAA|\u0015\r\tI0M\u0001\u000bCV$\bn\u001c:ju\u0016\u0014\u0018\u0002BA\u007f\u0003o\u0014Q\"Q2m\u0003V$\bn\u001c:ju\u0016\u0014\bb\u0002B\u0001O\u0001\u0007!1A\u0001\fQ>\u001cHoU3tg&|g\u000e\u0005\u0003\u0003\u0006\t]a\u0002\u0002B\u0004\u0005#qAA!\u0003\u0003\u000e9!\u00111\u001bB\u0006\u0013\u0005!\u0014b\u0001B\bg\u00059a.\u001a;x_J\\\u0017\u0002\u0002B\n\u0005+\taBU3rk\u0016\u001cHo\u00115b]:,GNC\u0002\u0003\u0010MJAA!\u0007\u0003\u001c\t91+Z:tS>t'\u0002\u0002B\n\u0005+AaAa\b(\u0001\u0004\u0019\u0016\u0001\u0005:fcV,7\u000f\u001e)sS:\u001c\u0017\u000e]1m\u0011\u001d\u0011\u0019c\na\u0001\u0005K\tqB]3rk\u0016\u001cH/\u001a3Po:,'o\u001d\t\u0006\u0003\u001f\fynU\u0001\u0018i\u0016\u001cH\u000fU3sS>$\u0017n\u0019+pW\u0016tW\t\u001f9jefD3\u0001KAX\u0003e\u0019'/Z1uKR{7.\u001a8SKN,H\u000e^\"bY2\u0014\u0015mY6\u0015\t\u0005=\"q\u0006\u0005\b\u0005cI\u0003\u0019AA,\u0003\r\u0011X\r^\u0001\u0016e\u0016tWm\u001e*fgB|gn]3DC2d'-Y2l)\u0019\tyCa\u000e\u0003:!9!\u0011\u0007\u0016A\u0002\u0005%\u0004b\u0002B\u001eU\u0001\u0007\u0011\u0011B\u0001\ni&lWm\u0015;b[B\fAd\u0019:fCR,G)\u001a7fO\u0006$\u0018n\u001c8U_.,g.T1oC\u001e,'\u000fF\u0005q\u0005\u0003\u0012YE!\u0014\u0003V!9!1I\u0016A\u0002\t\u0015\u0013AB2p]\u001aLw\rE\u0002r\u0005\u000fJ1A!\u0013s\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000f\u0005]1\u00061\u0001\u0002\u001c!1\u0011i\u000ba\u0001\u0005\u001f\u00022\u0001\u0012B)\u0013\r\u0011\u0019&\u0012\u0002\u0005)&lW\rC\u0004\u0003X-\u0002\rA!\u0017\u0002\u0011i\\7\t\\5f]R\u00042\u0001\u000fB.\u0013\r\u0011i&\u000f\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;")
public class DelegationTokenManagerTest
extends ZooKeeperTestHarness {
    private final MockTime time = new MockTime();
    private final KafkaPrincipal owner = SecurityUtils.parseKafkaPrincipal((String)"User:owner");
    private final List<KafkaPrincipal> renewer = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{SecurityUtils.parseKafkaPrincipal((String)"User:renewer1")}));
    private final Buffer<DelegationTokenManager> tokenManagers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final String secretKey;
    private final long maxLifeTimeMsDefault = Defaults$.MODULE$.DelegationTokenMaxLifeTimeMsDefault();
    private final long renewTimeMsDefault = Defaults$.MODULE$.DelegationTokenExpiryTimeMsDefault();
    private DelegationTokenCache tokenCache = null;
    private Properties props = null;
    private CreateTokenResult createTokenResult;
    private Errors error = Errors.NONE;
    private long expiryTimeStamp = 0L;

    public MockTime time() {
        return this.time;
    }

    public KafkaPrincipal owner() {
        return this.owner;
    }

    public List<KafkaPrincipal> renewer() {
        return this.renewer;
    }

    public Buffer<DelegationTokenManager> tokenManagers() {
        return this.tokenManagers;
    }

    public String secretKey() {
        return this.secretKey;
    }

    public long maxLifeTimeMsDefault() {
        return this.maxLifeTimeMsDefault;
    }

    public long renewTimeMsDefault() {
        return this.renewTimeMsDefault;
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public void tokenCache_$eq(DelegationTokenCache x$1) {
        this.tokenCache = x$1;
    }

    public Properties props() {
        return this.props;
    }

    public void props_$eq(Properties x$1) {
        this.props = x$1;
    }

    public CreateTokenResult createTokenResult() {
        return this.createTokenResult;
    }

    public void createTokenResult_$eq(CreateTokenResult x$1) {
        this.createTokenResult = x$1;
    }

    public Errors error() {
        return this.error;
    }

    public void error_$eq(Errors x$1) {
        this.error = x$1;
    }

    public long expiryTimeStamp() {
        return this.expiryTimeStamp;
    }

    public void expiryTimeStamp_$eq(long x$1) {
        this.expiryTimeStamp = x$1;
    }

    @Override
    @BeforeEach
    public void setUp() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        super.setUp();
        String x$2 = this.zkConnect();
        boolean bl = true;
        boolean bl2 = true;
        int n = TestUtils$.MODULE$.RandomPort();
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$7 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$8 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$9 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n4 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$17 = none$8;
        int n5 = 1;
        int n6 = 1;
        short s = 1;
        this.props_$eq(TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, n, (Option<SecurityProtocol>)x$7, (Option<File>)x$8, (Option<Properties>)x$9, bl3, bl4, n2, bl5, n3, bl6, n4, (Option<String>)x$17, n5, true, n6, s));
        this.props().put(KafkaConfig$.MODULE$.SaslEnabledMechanismsProp(), CollectionConverters$.MODULE$.CollectionHasAsScala(ScramMechanism.mechanismNames()).asScala().mkString(","));
        this.props().put(KafkaConfig$.MODULE$.DelegationTokenSecretKeyProp(), this.secretKey());
        this.tokenCache_$eq(new DelegationTokenCache(ScramMechanism.mechanismNames()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.tokenManagers().foreach((Function1 & Serializable)x$2 -> {
            x$2.shutdown();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    @Test
    public void testTokenRequestsWithDelegationTokenDisabled() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)this.createTokenResult().error());
        Predef$.MODULE$.assert(Predef$.MODULE$.wrapByteArray((byte[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Byte())).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray(this.createTokenResult().hmac())));
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap("test".getBytes()), 1000000L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)this.error());
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap("test".getBytes()), 1000000L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Errors.DELEGATION_TOKEN_AUTH_DISABLED, (Object)this.error());
    }

    @Test
    public void testCreateToken() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        long issueTime = this.time().milliseconds();
        String tokenId = this.createTokenResult().tokenId();
        byte[] password = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.secretKey());
        Assertions.assertEquals((Object)new CreateTokenResult(issueTime, issueTime + this.renewTimeMsDefault(), issueTime + this.maxLifeTimeMsDefault(), tokenId, password, Errors.NONE), (Object)this.createTokenResult());
        Option token = tokenManager.getToken(tokenId);
        Assertions.assertFalse((boolean)token.isEmpty());
        Assertions.assertTrue((boolean)Predef$.MODULE$.wrapByteArray(password).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray(((DelegationToken)token.get()).hmac())));
    }

    @Test
    public void testRenewToken() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        long issueTime = this.time().milliseconds();
        long maxLifeTime = issueTime + this.maxLifeTimeMsDefault();
        String tokenId = this.createTokenResult().tokenId();
        byte[] password = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.secretKey());
        Assertions.assertEquals((Object)new CreateTokenResult(issueTime, issueTime + this.renewTimeMsDefault(), maxLifeTime, tokenId, password, Errors.NONE), (Object)this.createTokenResult());
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap("test".getBytes()), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)this.error());
        KafkaPrincipal unknownOwner = SecurityUtils.parseKafkaPrincipal((String)"User:Unknown");
        tokenManager.renewToken(unknownOwner, ByteBuffer.wrap(password), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)this.error());
        this.time().sleep(86400000L);
        long expectedExpiryStamp = this.time().milliseconds() + this.renewTimeMsDefault();
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)expectedExpiryStamp, (long)this.expiryTimeStamp());
        Assertions.assertEquals((Object)Errors.NONE, (Object)this.error());
        this.time().sleep(86400000L);
        expectedExpiryStamp = this.time().milliseconds() + 3600000L;
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), 3600000L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)expectedExpiryStamp, (long)this.expiryTimeStamp());
        Assertions.assertEquals((Object)Errors.NONE, (Object)this.error());
        this.time().sleep(3600000L);
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), 691200000L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)maxLifeTime, (long)this.expiryTimeStamp());
        Assertions.assertEquals((Object)Errors.NONE, (Object)this.error());
        this.time().sleep(691200000L);
        tokenManager.renewToken(this.owner(), ByteBuffer.wrap(password), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Errors.DELEGATION_TOKEN_EXPIRED, (Object)this.error());
    }

    @Test
    public void testExpireToken() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        long issueTime = this.time().milliseconds();
        String tokenId = this.createTokenResult().tokenId();
        byte[] password = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.secretKey());
        Assertions.assertEquals((Object)new CreateTokenResult(issueTime, issueTime + this.renewTimeMsDefault(), issueTime + this.maxLifeTimeMsDefault(), tokenId, password, Errors.NONE), (Object)this.createTokenResult());
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap("test".getBytes()), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Errors.DELEGATION_TOKEN_NOT_FOUND, (Object)this.error());
        KafkaPrincipal unknownOwner = SecurityUtils.parseKafkaPrincipal((String)"User:Unknown");
        tokenManager.expireToken(unknownOwner, ByteBuffer.wrap(password), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Errors.DELEGATION_TOKEN_OWNER_MISMATCH, (Object)this.error());
        this.time().sleep(86400000L);
        long expectedExpiryStamp = this.time().milliseconds() + 0x6DDD00L;
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap(password), 0x6DDD00L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)expectedExpiryStamp, (long)this.expiryTimeStamp());
        this.time().sleep(3600000L);
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap(password), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(tokenManager.getToken(tokenId).isEmpty());
        Assertions.assertEquals((Object)Errors.NONE, (Object)this.error());
        Assertions.assertEquals((long)this.time().milliseconds(), (long)this.expiryTimeStamp());
    }

    @Test
    public void testRemoveTokenHmac() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), -1L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        long issueTime = this.time().milliseconds();
        String tokenId = this.createTokenResult().tokenId();
        byte[] password = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.secretKey());
        Assertions.assertEquals((Object)new CreateTokenResult(issueTime, issueTime + this.renewTimeMsDefault(), issueTime + this.maxLifeTimeMsDefault(), tokenId, password, Errors.NONE), (Object)this.createTokenResult());
        tokenManager.expireToken(this.owner(), ByteBuffer.wrap(password), -1L, (Function2 & Serializable)(ret, timeStamp) -> {
            this.renewResponseCallback(ret, BoxesRunTime.unboxToLong((Object)timeStamp));
            return BoxedUnit.UNIT;
        });
        String encodedHmac = Base64.getEncoder().encodeToString(password);
        Assertions.assertNull((Object)tokenManager.tokenCache().tokenIdForHmac(encodedHmac));
        Predef$.MODULE$.assert(tokenManager.getToken(tokenId).isEmpty());
    }

    @Test
    public void testDescribeToken() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        KafkaPrincipal owner1 = SecurityUtils.parseKafkaPrincipal((String)"User:owner1");
        KafkaPrincipal owner2 = SecurityUtils.parseKafkaPrincipal((String)"User:owner2");
        KafkaPrincipal owner3 = SecurityUtils.parseKafkaPrincipal((String)"User:owner3");
        KafkaPrincipal owner4 = SecurityUtils.parseKafkaPrincipal((String)"User:owner4");
        KafkaPrincipal renewer1 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer1");
        KafkaPrincipal renewer2 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer2");
        KafkaPrincipal renewer3 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer3");
        KafkaPrincipal renewer4 = SecurityUtils.parseKafkaPrincipal((String)"User:renewer4");
        AclAuthorizer aclAuthorizer = new AclAuthorizer();
        aclAuthorizer.configure(config.originals());
        RequestChannel.Session hostSession = new RequestChannel.Session(owner1, InetAddress.getByName("192.168.1.1"));
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(owner1, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer1, renewer2})), 3600000L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        tokenManager.createToken(owner2, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer3})), 3600000L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        String tokenId2 = this.createTokenResult().tokenId();
        tokenManager.createToken(owner3, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer4})), 0x6DDD00L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        String tokenId3 = this.createTokenResult().tokenId();
        tokenManager.createToken(owner4, (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{owner1, renewer4})), 0x6DDD00L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(tokenManager.getAllTokenInformation().size() == 4);
        List<DelegationToken> tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{SecurityUtils.parseKafkaPrincipal((String)"User:unknown")}))));
        Predef$.MODULE$.assert(tokens.size() == 0);
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        Predef$.MODULE$.assert(tokens.size() == 0);
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{owner1}))));
        Predef$.MODULE$.assert(tokens.size() == 2);
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, owner1, null);
        Predef$.MODULE$.assert(tokens.size() == 2);
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, SecurityUtils.parseKafkaPrincipal((String)"User:unknown"), null);
        Predef$.MODULE$.assert(tokens.size() == 0);
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{owner1, renewer4}))));
        Predef$.MODULE$.assert(tokens.size() == 2);
        DelegationTokenManagerTest.createAcl$1(new AclBinding(new ResourcePattern(ResourceType.DELEGATION_TOKEN, tokenId3, PatternType.LITERAL), new AccessControlEntry(owner1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW)), aclAuthorizer);
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, owner1, (List<KafkaPrincipal>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{owner1, renewer4}))));
        Predef$.MODULE$.assert(tokens.size() == 3);
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, renewer4, (List<KafkaPrincipal>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer4}))));
        Predef$.MODULE$.assert(tokens.size() == 2);
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, renewer2, (List<KafkaPrincipal>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer2, renewer3}))));
        Predef$.MODULE$.assert(tokens.size() == 1);
        hostSession = new RequestChannel.Session(renewer2, InetAddress.getByName("192.168.1.1"));
        DelegationTokenManagerTest.createAcl$1(new AclBinding(new ResourcePattern(ResourceType.DELEGATION_TOKEN, tokenId2, PatternType.LITERAL), new AccessControlEntry(renewer2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW)), aclAuthorizer);
        tokens = this.getTokens(tokenManager, aclAuthorizer, hostSession, renewer2, (List<KafkaPrincipal>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{renewer2, renewer3}))));
        Predef$.MODULE$.assert(tokens.size() == 2);
        aclAuthorizer.close();
    }

    private List<DelegationToken> getTokens(DelegationTokenManager tokenManager, AclAuthorizer aclAuthorizer, RequestChannel.Session hostSession, KafkaPrincipal requestPrincipal, List<KafkaPrincipal> requestedOwners) {
        if (requestedOwners != null && requestedOwners.isEmpty()) {
            return (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        }
        return tokenManager.getTokens((Function1 & Serializable)token -> BoxesRunTime.boxToBoolean((boolean)DelegationTokenManagerTest.eligible$1(token, requestPrincipal, requestedOwners, hostSession, aclAuthorizer)));
    }

    @Test
    public void testPeriodicTokenExpiry() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.props());
        DelegationTokenManager tokenManager = this.createDelegationTokenManager(config, this.tokenCache(), (Time)this.time(), this.zkClient());
        tokenManager.startup();
        tokenManager.createToken(this.owner(), this.renewer(), 3600000L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        tokenManager.createToken(this.owner(), this.renewer(), 3600000L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        tokenManager.createToken(this.owner(), this.renewer(), 0x6DDD00L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        tokenManager.createToken(this.owner(), this.renewer(), 0x6DDD00L, (Function1 & Serializable)ret -> {
            this.createTokenResultCallBack(ret);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(tokenManager.getAllTokenInformation().size() == 4);
        this.time().sleep(0x6DDD00L);
        tokenManager.expireTokens();
        Predef$.MODULE$.assert(tokenManager.getAllTokenInformation().size() == 2);
    }

    private void createTokenResultCallBack(CreateTokenResult ret) {
        this.createTokenResult_$eq(ret);
    }

    private void renewResponseCallback(Errors ret, long timeStamp) {
        this.error_$eq(ret);
        this.expiryTimeStamp_$eq(timeStamp);
    }

    private DelegationTokenManager createDelegationTokenManager(KafkaConfig config, DelegationTokenCache tokenCache, Time time, KafkaZkClient zkClient) {
        DelegationTokenManager tokenManager = new DelegationTokenManager(config, tokenCache, time, zkClient);
        this.tokenManagers().$plus$eq((Object)tokenManager);
        return tokenManager;
    }

    private static final void createAcl$1(AclBinding aclBinding, AclAuthorizer aclAuthorizer$1) {
        ((AclCreateResult)((CompletionStage)aclAuthorizer$1.createAcls(null, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding}))).asJava()).get(0)).toCompletableFuture().get()).exception().ifPresent(e -> {
            throw e;
        });
    }

    private static final boolean authorizeToken$1(String tokenId, RequestChannel.Session hostSession$1, AclAuthorizer aclAuthorizer$2) {
        AuthorizerUtils$.anon.1 var6_3;
        AuthorizerUtils$.anon.1 v0 = var6_3 = new /* Unavailable Anonymous Inner Class!! */;
        var6_3 = null;
        AuthorizerUtils$.anon.1 requestContext = v0;
        Action action = new Action(AclOperation.DESCRIBE, new ResourcePattern(ResourceType.DELEGATION_TOKEN, tokenId, PatternType.LITERAL), 1, true, true);
        Object object = CollectionConverters$.MODULE$.ListHasAsScala(aclAuthorizer$2.authorize((AuthorizableRequestContext)requestContext, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Action[]{action}))).asJava())).asScala().head();
        AuthorizationResult authorizationResult = AuthorizationResult.ALLOWED;
        return !(object != null ? !object.equals(authorizationResult) : authorizationResult != null);
    }

    private static final boolean eligible$1(TokenInformation token, KafkaPrincipal requestPrincipal$1, List requestedOwners$1, RequestChannel.Session hostSession$1, AclAuthorizer aclAuthorizer$2) {
        Option filterToken_owners = Option$.MODULE$.apply((Object)requestedOwners$1);
        boolean bl = !filterToken_owners.isEmpty() && !((List)filterToken_owners.get()).exists(arg_0 -> DelegationTokenManager$.$anonfun$filterToken$1$adapted((TokenInformation)token, arg_0)) ? false : (token.ownerOrRenewer(requestPrincipal$1) ? true : DelegationTokenManagerTest.authorizeToken$1(token.tokenId(), hostSession$1, aclAuthorizer$2));
        return bl;
    }

    public DelegationTokenManagerTest() {
        this.secretKey = "secretKey";
    }

    public static final /* synthetic */ Object $anonfun$getTokens$1$adapted(RequestChannel.Session hostSession$1, AclAuthorizer aclAuthorizer$2, String tokenId) {
        return BoxesRunTime.boxToBoolean((boolean)DelegationTokenManagerTest.authorizeToken$1(tokenId, hostSession$1, aclAuthorizer$2));
    }
}

