/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.AppendOrigin;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.server.Defaults$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.ReplicaManager;
import kafka.utils.MockScheduler;
import kafka.utils.Pool;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\rme\u0001B0a\u0001\u001dDQA\u001c\u0001\u0005\u0002=DqA\u001d\u0001C\u0002\u0013\u00051\u000f\u0003\u0004x\u0001\u0001\u0006I\u0001\u001e\u0005\bq\u0002\u0011\r\u0011\"\u0001t\u0011\u0019I\b\u0001)A\u0005i\"9!\u0010\u0001b\u0001\n\u0003\u0019\bBB>\u0001A\u0003%A\u000fC\u0004}\u0001\t\u0007I\u0011A?\t\u000f\u0005M\u0001\u0001)A\u0005}\"A\u0011Q\u0003\u0001C\u0002\u0013\u00051\u000fC\u0004\u0002\u0018\u0001\u0001\u000b\u0011\u0002;\t\u0013\u0005e\u0001A1A\u0005\u0002\u0005m\u0001\u0002CA\u001d\u0001\u0001\u0006I!!\b\t\u0013\u0005m\u0002A1A\u0005\u0002\u0005u\u0002\u0002CA&\u0001\u0001\u0006I!a\u0010\t\u0013\u00055\u0003A1A\u0005\u0002\u0005=\u0003\u0002CA.\u0001\u0001\u0006I!!\u0015\t\u0013\u0005u\u0003A1A\u0005\u0002\u0005}\u0003\u0002CA7\u0001\u0001\u0006I!!\u0019\t\u0013\u0005=\u0004A1A\u0005\u0002\u0005E\u0004\u0002CA@\u0001\u0001\u0006I!a\u001d\t\u0013\u0005\u0005\u0005A1A\u0005\u0002\u0005\r\u0005\u0002CAH\u0001\u0001\u0006I!!\"\t\u0013\u0005E\u0005A1A\u0005\u0002\u0005M\u0005\u0002CAN\u0001\u0001\u0006I!!&\t\u0013\u0005u\u0005A1A\u0005\u0002\u0005}\u0005\u0002CAT\u0001\u0001\u0006I!!)\t\u0013\u0005%\u0006A1A\u0005\u0002\u0005-\u0006\u0002CAb\u0001\u0001\u0006I!!,\t\u0013\u0005\u0015\u0007A1A\u0005\u0002\u0005-\u0006\u0002CAd\u0001\u0001\u0006I!!,\t\u0013\u0005%\u0007A1A\u0005\u0002\u0005-\u0007\u0002CAm\u0001\u0001\u0006I!!4\t\u0013\u0005m\u0007A1A\u0005\u0002\u0005-\u0007\u0002CAo\u0001\u0001\u0006I!!4\t\u0013\u0005}\u0007A1A\u0005\u0002\u0005\u0005\b\u0002CAy\u0001\u0001\u0006I!a9\t\u0013\u0005M\b\u00011A\u0005\u0002\u0005U\b\"CA\u007f\u0001\u0001\u0007I\u0011AA\u0000\u0011!\u0011Y\u0001\u0001Q!\n\u0005]\b\"\u0003B\u0007\u0001\u0001\u0007I\u0011AA{\u0011%\u0011y\u0001\u0001a\u0001\n\u0003\u0011\t\u0002\u0003\u0005\u0003\u0016\u0001\u0001\u000b\u0015BA|\u0011%\u00119\u0002\u0001a\u0001\n\u0003\u0011I\u0002C\u0005\u0003(\u0001\u0001\r\u0011\"\u0001\u0003*!A!Q\u0006\u0001!B\u0013\u0011Y\u0002C\u0004\u00030\u0001!\tA!\r\t\u000f\t%\u0003\u0001\"\u0001\u00032!9!1\u000b\u0001\u0005\u0002\tE\u0002b\u0002B/\u0001\u0011\u0005!\u0011\u0007\u0005\b\u0005C\u0002A\u0011\u0001B\u0019\u0011\u001d\u0011)\u0007\u0001C\u0001\u0005cAqA!\u001b\u0001\t\u0003\u0011\t\u0004C\u0004\u0003n\u0001!\tA!\r\t\u000f\tE\u0004\u0001\"\u0001\u00032!9!Q\u000f\u0001\u0005\u0002\tE\u0002b\u0002B=\u0001\u0011\u0005!\u0011\u0007\u0005\b\u0005{\u0002A\u0011\u0001B\u0019\u0011\u001d\u0011\t\t\u0001C\u0001\u0005cAqA!\"\u0001\t\u0003\u0011\t\u0004C\u0004\u0003\n\u0002!\tA!\r\t\u000f\t5\u0005\u0001\"\u0001\u00032!9!\u0011\u0013\u0001\u0005\u0002\tE\u0002b\u0002BK\u0001\u0011\u0005!\u0011\u0007\u0005\b\u00053\u0003A\u0011\u0001B\u0019\u0011\u001d\u0011i\n\u0001C\u0001\u0005cAqA!)\u0001\t\u0003\u0011\t\u0004C\u0004\u0003&\u0002!\tA!\r\t\u000f\t%\u0006\u0001\"\u0001\u00032!9!Q\u0016\u0001\u0005\u0002\tE\u0002b\u0002BY\u0001\u0011\u0005!\u0011\u0007\u0005\b\u0005k\u0003A\u0011\u0001B\u0019\u0011\u001d\u0011I\f\u0001C\u0001\u0005cAqA!0\u0001\t\u0003\u0011\t\u0004C\u0004\u0003B\u0002!\tA!\r\t\u000f\t\u0015\u0007\u0001\"\u0003\u0003H\"9!1\u001d\u0001\u0005\n\t\u0015\bb\u0002Bv\u0001\u0011%!Q\u001e\u0005\b\u0005_\u0004A\u0011\u0001B\u0019\u0011\u001d\u0011\u0019\u0010\u0001C\u0001\u0005cAqAa>\u0001\t\u0013\u0011I\u0010C\u0004\u0003\u0000\u0002!Ia!\u0001\t\u000f\r\u0015\u0001\u0001\"\u0003\u0004\b!91\u0011\u0003\u0001\u0005\n\rM\u0001bBB\u0016\u0001\u0011%1Q\u0006\u0005\b\u0007k\u0001A\u0011BB\u001c\u0011\u001d\u00199\u0005\u0001C\u0005\u0007\u0013Bqaa\u0014\u0001\t\u0013\u0019\t\u0006C\u0004\u0004V\u0001!Iaa\u0016\t\u0013\r\u0015\u0004!%A\u0005\n\r\u001d\u0004\"CB?\u0001E\u0005I\u0011BB@\u0011\u001d\u0019\u0019\t\u0001C\u0005\u0007\u000bCqa!%\u0001\t\u0013\u0019\u0019\nC\u0004\u0004\u0018\u0002!\tA!\r\u00037Q\u0013\u0018M\\:bGRLwN\\*uCR,W*\u00198bO\u0016\u0014H+Z:u\u0015\t\t'-A\u0006ue\u0006t7/Y2uS>t'BA2e\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u0003\u0015\fQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001QB\u0011\u0011\u000e\\\u0007\u0002U*\t1.A\u0003tG\u0006d\u0017-\u0003\u0002nU\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u00019\u0011\u0005E\u0004Q\"\u00011\u0002\u0017A\f'\u000f^5uS>t\u0017\nZ\u000b\u0002iB\u0011\u0011.^\u0005\u0003m*\u00141!\u00138u\u00031\u0001\u0018M\u001d;ji&|g.\u00133!\u00035qW/\u001c)beRLG/[8og\u0006qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0013\u0001\u0006;sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRl5/A\u000bue\u0006t7/Y2uS>tG+[7f_V$Xj\u001d\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\ta\u0010E\u0002\u0000\u0003\u001fi!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u0007G>lWn\u001c8\u000b\u0007\u0015\f9A\u0003\u0003\u0002\n\u0005-\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u000e\u0005\u0019qN]4\n\t\u0005E\u0011\u0011\u0001\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0003E\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000eI\u0001\u000bibt'+Z2pe\u0012\u001cXCAA\u000f!\u0019\ty\"!\u000b\u0002.5\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#A\u0004nkR\f'\r\\3\u000b\u0007\u0005\u001d\".\u0001\u0006d_2dWm\u0019;j_:LA!a\u000b\u0002\"\tY\u0011I\u001d:bs\n+hMZ3s!\u0011\ty#!\u000e\u000e\u0005\u0005E\"\u0002BA\u001a\u0003\u0003\taA]3d_J$\u0017\u0002BA\u001c\u0003c\u0011AbU5na2,'+Z2pe\u0012\f1\u0002\u001e=o%\u0016\u001cwN\u001d3tA\u0005!A/[7f+\t\ty\u0004\u0005\u0003\u0002B\u0005\u001dSBAA\"\u0015\u0011\t)%!\u0001\u0002\u000bU$\u0018\u000e\\:\n\t\u0005%\u00131\t\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005I1o\u00195fIVdWM]\u000b\u0003\u0003#\u0002B!a\u0015\u0002X5\u0011\u0011Q\u000b\u0006\u0004\u0003\u000b\"\u0017\u0002BA-\u0003+\u0012Q\"T8dWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sA\u0005A!p[\"mS\u0016tG/\u0006\u0002\u0002bA!\u00111MA5\u001b\t\t)GC\u0002\u0002h\u0011\f!A_6\n\t\u0005-\u0014Q\r\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002\u0013i\\7\t\\5f]R\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0003\u0003g\u0002B!!\u001e\u0002|5\u0011\u0011q\u000f\u0006\u0004\u0003s\"\u0017AB:feZ,'/\u0003\u0003\u0002~\u0005]$A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u00059Q.\u001a;sS\u000e\u001cXCAAC!\u0011\t9)a#\u000e\u0005\u0005%%\u0002BAA\u0003\u0003IA!!$\u0002\n\n9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\u0013QDhnQ8oM&<WCAAK!\r\t\u0018qS\u0005\u0004\u00033\u0003'!\u0005+sC:\u001c\u0018m\u0019;j_:\u001cuN\u001c4jO\u0006QA\u000f\u001f8D_:4\u0017n\u001a\u0011\u0002%Q\u0014\u0018M\\:bGRLwN\\'b]\u0006<WM]\u000b\u0003\u0003C\u00032!]AR\u0013\r\t)\u000b\u0019\u0002\u0018)J\fgn]1di&|gn\u0015;bi\u0016l\u0015M\\1hKJ\f1\u0003\u001e:b]N\f7\r^5p]6\u000bg.Y4fe\u0002\n\u0001\u0003\u001e:b]N\f7\r^5p]\u0006d\u0017\nZ\u0019\u0016\u0005\u00055\u0006\u0003BAX\u0003{sA!!-\u0002:B\u0019\u00111\u00176\u000e\u0005\u0005U&bAA\\M\u00061AH]8pizJ1!a/k\u0003\u0019\u0001&/\u001a3fM&!\u0011qXAa\u0005\u0019\u0019FO]5oO*\u0019\u00111\u00186\u0002#Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\f\u0004%\u0001\tue\u0006t7/Y2uS>t\u0017\r\\%ee\u0005\tBO]1og\u0006\u001cG/[8oC2LEM\r\u0011\u0002'QDh.T3tg\u0006<WmS3z\u0005f$Xm]\u0019\u0016\u0005\u00055\u0007#B5\u0002P\u0006M\u0017bAAiU\n)\u0011I\u001d:bsB\u0019\u0011.!6\n\u0007\u0005]'N\u0001\u0003CsR,\u0017\u0001\u0006;y]6+7o]1hK.+\u0017PQ=uKN\f\u0004%A\nuq:lUm]:bO\u0016\\U-\u001f\"zi\u0016\u001c('\u0001\u000buq:lUm]:bO\u0016\\U-\u001f\"zi\u0016\u001c(\u0007I\u0001\faJ|G-^2fe&#7/\u0006\u0002\u0002dBA\u0011Q]At\u0003[\u000bY/\u0004\u0002\u0002&%!\u0011\u0011^A\u0013\u0005\ri\u0015\r\u001d\t\u0004S\u00065\u0018bAAxU\n!Aj\u001c8h\u00031\u0001(o\u001c3vG\u0016\u0014\u0018\nZ:!\u00031!\bP\\'fi\u0006$\u0017\r^12+\t\t9\u0010E\u0002r\u0003sL1!a?a\u0005M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u0003A!\bP\\'fi\u0006$\u0017\r^12?\u0012*\u0017\u000f\u0006\u0003\u0003\u0002\t\u001d\u0001cA5\u0003\u0004%\u0019!Q\u00016\u0003\tUs\u0017\u000e\u001e\u0005\n\u0005\u00139\u0013\u0011!a\u0001\u0003o\f1\u0001\u001f\u00132\u00035!\bP\\'fi\u0006$\u0017\r^12A\u0005aA\u000f\u001f8NKR\fG-\u0019;be\u0005\u0001B\u000f\u001f8NKR\fG-\u0019;be}#S-\u001d\u000b\u0005\u0005\u0003\u0011\u0019\u0002C\u0005\u0003\n)\n\t\u00111\u0001\u0002x\u0006iA\u000f\u001f8NKR\fG-\u0019;be\u0001\nQ\"\u001a=qK\u000e$X\rZ#se>\u0014XC\u0001B\u000e!\u0011\u0011iBa\t\u000e\u0005\t}!\u0002\u0002B\u0011\u0003\u0003\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0005K\u0011yB\u0001\u0004FeJ|'o]\u0001\u0012Kb\u0004Xm\u0019;fI\u0016\u0013(o\u001c:`I\u0015\fH\u0003\u0002B\u0001\u0005WA\u0011B!\u0003.\u0003\u0003\u0005\rAa\u0007\u0002\u001d\u0015D\b/Z2uK\u0012,%O]8sA\u0005)1/\u001a;VaR\u0011!\u0011\u0001\u0015\u0004_\tU\u0002\u0003\u0002B\u001c\u0005\u000bj!A!\u000f\u000b\t\tm\"QH\u0001\u0004CBL'\u0002\u0002B \u0005\u0003\nqA[;qSR,'O\u0003\u0003\u0003D\u0005-\u0011!\u00026v]&$\u0018\u0002\u0002B$\u0005s\u0011!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007f\u0001\u0019\u0003NA!!q\u0007B(\u0013\u0011\u0011\tF!\u000f\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\b;fgR4\u0016\r\\5eCR,GK]1og\u0006\u001cG/[8o)&lWm\\;uQ\r\t$q\u000b\t\u0005\u0005o\u0011I&\u0003\u0003\u0003\\\te\"\u0001\u0002+fgR\fa\u0002^3ti\u0006#GmR3u!&$7\u000fK\u00023\u0005/\n1\u0003^3ti\u0012+G.\u001a;f!\u0006\u0014H/\u001b;j_:D3a\rB,\u0003i!Xm\u001d;EK2,G/\u001a'pC\u0012Lgn\u001a)beRLG/[8oQ\r!$qK\u0001*i\u0016\u001cH\u000fT8bI\u0006sGMU3n_Z,GK]1og\u0006\u001cG/[8og\u001a{'\u000fU1si&$\u0018n\u001c8)\u0007U\u00129&A\u0015uKN$8i\\7qY\u0016$X\r\u0016:b]NLG/[8o/\",g.\u00119qK:$7+^2dK\u0016$W\r\u001a\u0015\u0004m\t]\u0013\u0001\f;fgR\f\u0005\u000f]3oI\u001a\u000b\u0017\u000e\u001c+p\u0007>|'\u000fZ5oCR|'OT8u\u0003Z\f\u0017\u000e\\1cY\u0016,%O]8sQ\r9$qK\u0001$i\u0016\u001cH/\u00119qK:$g)Y5m)>tu\u000e^\"p_J$\u0017N\\1u_J,%O]8sQ\rA$qK\u0001(i\u0016\u001cH/\u00119qK:$g)Y5m)>\u001cun\u001c:eS:\fGo\u001c:M_\u0006$\u0017N\\4FeJ|'\u000fK\u0002:\u0005/\nA\u0004^3ti\u0006\u0003\b/\u001a8e\r\u0006LG\u000eV8V].twn\u001e8FeJ|'\u000fK\u0002;\u0005/\nQ\u0005^3tiB+g\u000eZ5oON#\u0018\r^3O_R\u0014Vm]3u\u001f:\u0014V\r\u001e:z\u0003B\u0004XM\u001c3)\u0007m\u00129&A\u0017uKN$\u0018\t\u001d9f]\u0012$&/\u00198tC\u000e$\u0018n\u001c8U_2{wm\u00165jY\u0016\u0004&o\u001c3vG\u0016\u0014h)\u001a8dK\u0012D3\u0001\u0010B,\u0003I\"Xm\u001d;BaB,g\u000e\u001a+sC:\u001c\u0018m\u0019;j_:$v\u000eT8h/\"LG.\u001a)f]\u0012LgnZ*uCR,7\t[1oO\u0016$\u0007fA\u001f\u0003X\u0005y4\u000f[8vY\u0012\u0014V\r^;s]:{GoQ8pe&$g.\u0019;pe\u0016\u0013(o\u001c:JMR\u0013\u0018M\\:bGRLwN\\%e!\u0006\u0014H/\u001b;j_:tu\u000e^(x]\u0016$\u0007f\u0001 \u0003X\u000514\u000f[8vY\u0012|e\u000e\\=D_:\u001c\u0018\u000eZ3s)J\fgn]1di&|gn]%o)\",wJ\\4pS:<7\u000b^1uKR{\u0017IY8si\"\u001aqHa\u0016\u0002qMDw.\u001e7e/JLG/\u001a+y]6\u000b'o[3sg\u001a{'\u000f\u0016:b]N\f7\r^5p]&s\u0007K]3qCJ,GmQ8n[&$8\u000b^1uK\"\u001a\u0001Ia\u0016\u0002oMDw.\u001e7e/JLG/\u001a+y]6\u000b'o[3sg\u001a{'\u000f\u0016:b]N\f7\r^5p]&s\u0007K]3qCJ,G-\u00112peR\u001cF/\u0019;fQ\r\t%qK\u00012g\"|W\u000f\u001c3SK6|g/Z\"p[BdW\r^3D_6l\u0017\u000e^#ya&\u0014X\r\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133tQ\r\u0011%qK\u00011g\"|W\u000f\u001c3SK6|g/Z\"p[BdW\r^3BE>\u0014H/\u0012=qSJ,G\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:)\u0007\r\u00139&\u0001\u0015tQ>,H\u000e\u001a*f[>4X-R7qif,\u0005\u0010]5sK\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY&#7\u000fK\u0002E\u0005/\nag\u001d5pk2$gj\u001c;SK6|g/Z#ya&\u0014X\r\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133t\u0013\u001adunZ!qa\u0016tGMR1jYND3!\u0012B,\u0003\u0019\u001a\bn\\;mI:{GOU3n_Z,wJ\\4pS:<GK]1og\u0006\u001cG/[8oC2LEm\u001d\u0015\u0004\r\n]\u0013aK:i_VdGMT8u%\u0016lwN^3Qe\u0016\u0004\u0018M]3BE>\u0014H\u000f\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:)\u0007\u001d\u00139&\u0001\u0017tQ>,H\u000e\u001a(piJ+Wn\u001c<f!J,\u0007/\u0019:f\u0007>lW.\u001b;Ue\u0006t7/Y2uS>t\u0017\r\\%eg\"\u001a\u0001Ja\u0016\u0002aQ,7\u000f\u001e+sC:\u001c\u0018m\u0019;j_:\fG.\u0012=qSJ\fG/[8o/&$\b\u000eV8p'6\fG\u000e\u001c\"bi\u000eD7+\u001b>fQ\rI%qK\u0001-i\u0016\u001cH\u000f\u0016:b]N\f7\r^5p]\u0006dW\t\u001f9je\u0006$\u0018n\u001c8XSRDwJ\u001a4mS:,Gj\\4ESJD3A\u0013B,\u0003=\"Xm\u001d;Ue\u0006t7/Y2uS>tW\t\u001f9je\u0006$\u0018n\u001c8TQ>,H\u000e\u001a*fgB,7\r\u001e\"bi\u000eD7+\u001b>fQ\rY%qK\u0001&G>dG.Z2u)J\fgn]1di&|g.\u00197JIN4%o\\7U_6\u00147\u000f^8oKN$BA!3\u0003PB1\u0011q\u0016Bf\u0003[KAA!4\u0002B\n\u00191+\u001a;\t\u000f\tEG\n1\u0001\u0003T\u0006y\u0011\r\u001d9f]\u0012,GMU3d_J$7\u000fE\u0004\u0002 \tUgPa6\n\t\u0005%\u0018\u0011\u0005\t\u0007\u0003?\u0011IN!8\n\t\tm\u0017\u0011\u0005\u0002\u0007\u0005V4g-\u001a:\u0011\t\u0005=\"q\\\u0005\u0005\u0005C\f\tDA\u0007NK6|'/\u001f*fG>\u0014Hm]\u0001\u001cY>\fG-\u0012=qSJ,G\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:\u0015\t\t%'q\u001d\u0005\u0007\u0005Sl\u0005\u0019\u0001;\u0002'9,X\u000e\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:\u0002;1L7\u000f^#ya&\u0014\u0018M\u00197f)J\fgn]1di&|g.\u00197JIN$\"A!3\u00027Q,7\u000f^*vG\u000e,7o\u001d4vYJ+\u0017.\\7jOJ\fG/[8oQ\ry%qK\u0001,i\u0016\u001cH\u000fT8bIR\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1XSRD7i\u001c:skB$X\r\u001a'pO\"\u001a\u0001Ka\u0016\u0002EY,'/\u001b4z\u001b\u0016$\u0018\rZ1uC\u0012{Wm]#ySN$\u0018I\u001c3JgV\u001b\u0018M\u00197f)\u0011\u0011\tAa?\t\u000f\tu\u0018\u000b1\u0001\u0002.\u0006yAO]1og\u0006\u001cG/[8oC2LE-A\rwKJLg-_'fi\u0006$\u0017\r^1E_\u0016\u001ch\u000e^#ySN$H\u0003\u0002B\u0001\u0007\u0007AqA!@S\u0001\u0004\ti+A\u0010fqB,7\r\u001e+sC:\u001c\u0018m\u0019;j_:\fG.\u00133FqBL'/\u0019;j_:$bA!\u0001\u0004\n\r5\u0001bBB\u0006'\u0002\u0007!1D\u0001\fCB\u0004XM\u001c3FeJ|'\u000fC\u0004\u0004\u0010M\u0003\rAa5\u0002\u001f\r\f\u0007\u000f^;sK\u0012\f\u0005\u000f]3oIN\fQ\u0004\\8bIR\u0013\u0018M\\:bGRLwN\\:G_J\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0005\u0003\u0019)\u0002C\u0004\u0004\u0018Q\u0003\ra!\u0007\u0002\u0019A\f'\u000f^5uS>t\u0017\nZ:\u0011\u000b\rm1Q\u0005;\u000f\t\ru1\u0011\u0005\b\u0005\u0003g\u001by\"C\u0001l\u0013\r\u0019\u0019C[\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u00199c!\u000b\u0003\u0007M+\u0017OC\u0002\u0004$)\fq\"\u001a=qK\u000e$Hj\\4D_:4\u0017n\u001a\u000b\u0007\u0005\u0003\u0019yc!\r\t\u000f\r]Q\u000b1\u0001\u0004\u001a!111G+A\u0002Q\fA\"\\1y\u0005\u0006$8\r[*ju\u0016\fAe]3ukB\fe\u000e\u001a*v]R\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012,\u0005\u0010]5sCRLwN\u001c\u000b\u0007\u0005\u0003\u0019Id!\u0010\t\u000f\rmb\u000b1\u0001\u0003\u001c\u0005)QM\u001d:pe\"91q\b,A\u0002\r\u0005\u0013\u0001\u0003;y]N#\u0018\r^3\u0011\u0007E\u001c\u0019%C\u0002\u0004F\u0001\u0014\u0001\u0003\u0016:b]N\f7\r^5p]N#\u0018\r^3\u0002IY,'/\u001b4z/JLG/Z:Uq:l\u0015M]6feNLe\u000e\u0015:fa\u0006\u0014Xm\u0015;bi\u0016$BA!\u0001\u0004L!91QJ,A\u0002\r\u0005\u0013!B:uCR,\u0017AD1tg\u0016\u0014HoQ1mY\n\f7m\u001b\u000b\u0005\u0005\u0003\u0019\u0019\u0006C\u0004\u0004<a\u0003\rAa\u0007\u0002'Q\u0014\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u0015\u0015\u0005]8\u0011LB.\u0007?\u001a\t\u0007C\u0004\u0003~f\u0003\r!!,\t\u000f\ru\u0013\f1\u0001\u0002l\u0006Q\u0001O]8ek\u000e,'/\u00133\t\u0013\r5\u0013\f%AA\u0002\r\u0005\u0003\u0002CB23B\u0005\t\u0019\u0001;\u0002\u0015QDh\u000eV5nK>,H/A\u000fue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019IG\u000b\u0003\u0004B\r-4FAB7!\u0011\u0019yg!\u001f\u000e\u0005\rE$\u0002BB:\u0007k\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r]$.\u0001\u0006b]:|G/\u0019;j_:LAaa\u001f\u0004r\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002;Q\u0014\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIQ*\"a!!+\u0007Q\u001cY'A\u0007qe\u0016\u0004\u0018M]3Uq:dun\u001a\u000b\t\u0005\u0003\u00199i!#\u0004\u000e\")A\u0010\u0018a\u0001}\"911\u0012/A\u0002\u0005-\u0018aC:uCJ$xJ\u001a4tKRDqaa$]\u0001\u0004\u0011i.A\u0004sK\u000e|'\u000fZ:\u00025A\u0014X\r]1sK\u001a{'\u000f\u0016=o\u001b\u0016\u001c8/Y4f\u0003B\u0004XM\u001c3\u0015\t\t\u00051Q\u0013\u0005\b\u0007wi\u0006\u0019\u0001B\u000e\u0003]!Xm\u001d;QCJ$\u0018\u000e^5p]2{\u0017\rZ'fiJL7\rK\u0002_\u0005/\u0002")
public class TransactionStateManagerTest {
    private final int partitionId;
    private final int numPartitions;
    private final int transactionTimeoutMs;
    private final TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionId());
    private final int coordinatorEpoch;
    private final ArrayBuffer<SimpleRecord> txnRecords = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final MockTime time = new MockTime();
    private final MockScheduler scheduler = new MockScheduler((Time)this.time());
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
    private final ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
    private final Metrics metrics;
    private final TransactionConfig txnConfig;
    private final TransactionStateManager transactionManager;
    private final String transactionalId1;
    private final String transactionalId2;
    private final byte[] txnMessageKeyBytes1;
    private final byte[] txnMessageKeyBytes2;
    private final Map<String, Object> producerIds;
    private TransactionMetadata txnMetadata1;
    private TransactionMetadata txnMetadata2;
    private Errors expectedError;

    public int partitionId() {
        return this.partitionId;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public ArrayBuffer<SimpleRecord> txnRecords() {
        return this.txnRecords;
    }

    public MockTime time() {
        return this.time;
    }

    public MockScheduler scheduler() {
        return this.scheduler;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public TransactionConfig txnConfig() {
        return this.txnConfig;
    }

    public TransactionStateManager transactionManager() {
        return this.transactionManager;
    }

    public String transactionalId1() {
        return this.transactionalId1;
    }

    public String transactionalId2() {
        return this.transactionalId2;
    }

    public byte[] txnMessageKeyBytes1() {
        return this.txnMessageKeyBytes1;
    }

    public byte[] txnMessageKeyBytes2() {
        return this.txnMessageKeyBytes2;
    }

    public Map<String, Object> producerIds() {
        return this.producerIds;
    }

    public TransactionMetadata txnMetadata1() {
        return this.txnMetadata1;
    }

    public void txnMetadata1_$eq(TransactionMetadata x$1) {
        this.txnMetadata1 = x$1;
    }

    public TransactionMetadata txnMetadata2() {
        return this.txnMetadata2;
    }

    public void txnMetadata2_$eq(TransactionMetadata x$1) {
        this.txnMetadata2 = x$1;
    }

    public Errors expectedError() {
        return this.expectedError;
    }

    public void expectedError_$eq(Errors x$1) {
        this.expectedError = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.transactionManager().startup((Function0)(JFunction0.mcI.sp & Serializable)() -> this.numPartitions(), false);
        Assertions.assertEquals((int)this.partitionId(), (int)this.transactionManager().partitionFor(this.transactionalId1()));
        Assertions.assertEquals((int)this.partitionId(), (int)this.transactionManager().partitionFor(this.transactionalId2()));
    }

    @AfterEach
    public void tearDown() {
        EasyMock.reset((Object[])new Object[]{this.zkClient(), this.replicaManager()});
        this.transactionManager().shutdown();
    }

    @Test
    public void testValidateTransactionTimeout() {
        Assertions.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(1));
        Assertions.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(-1));
        Assertions.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(0));
        Assertions.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs()));
        Assertions.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs() + 1));
    }

    @Test
    public void testAddGetPids() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1()));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata2())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata2()));
    }

    @Test
    public void testDeletePartition() {
        TransactionMetadata metadata1 = this.transactionMetadata("b", 5L, (TransactionState)Empty$.MODULE$, this.transactionTimeoutMs());
        TransactionMetadata metadata2 = this.transactionMetadata("a", 10L, (TransactionState)Empty$.MODULE$, this.transactionTimeoutMs());
        Assertions.assertEquals((int)0, (int)this.transactionManager().partitionFor(metadata1.transactionalId()));
        Assertions.assertEquals((int)1, (int)this.transactionManager().partitionFor(metadata2.transactionalId()));
        this.transactionManager().addLoadedTransactionsToCache(0, this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(metadata1);
        this.transactionManager().addLoadedTransactionsToCache(1, this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(metadata2);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata1.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata1.transactionalId()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata2.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata2.transactionalId()));
        this.transactionManager().removeTransactionsForTxnTopicPartition(0);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.cachedProducerEpoch$1(metadata1.transactionalId()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToShort((short)metadata2.producerEpoch())), (Object)this.cachedProducerEpoch$1(metadata2.transactionalId()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteLoadingPartition() {
        MemoryRecords memoryRecords;
        void withRecords_records;
        MemoryRecords memoryRecords2;
        long startOffset = 0L;
        long endOffset = 1L;
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        Log logMock = (Log)EasyMock.mock(Log.class);
        EasyMock.expect((Object)this.replicaManager().getLog(this.topicPartition())).andStubReturn((Object)new Some((Object)logMock));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (FetchIsolation)EasyMock.eq((Object)FetchLogEnd$.MODULE$), EasyMock.eq((boolean)true))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), (Records)fileRecordsMock, false, (Option)None$.MODULE$));
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(this.topicPartition())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit()))};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        MemoryRecords memoryRecords3 = memoryRecords2 = MemoryRecords.withRecords((byte)2, (long)startOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Object var22_7 = null;
        memoryRecords2 = null;
        MemoryRecords memoryRecords4 = memoryRecords = memoryRecords3;
        Object var17_6 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords4;
        CountDownLatch latch = new CountDownLatch(1);
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        Capture bufferCapture = EasyMock.newCapture();
        fileRecordsMock.readInto((ByteBuffer)EasyMock.capture((Capture)bufferCapture), EasyMock.anyInt());
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, latch, bufferCapture, records){
            private final CountDownLatch latch$1;
            private final Capture bufferCapture$1;
            private final MemoryRecords records$1;

            public void answer() {
                this.latch$1.await();
                ByteBuffer buffer = (ByteBuffer)this.bufferCapture$1.getValue();
                buffer.put(this.records$1.buffer().duplicate());
                buffer.flip();
            }
            {
                this.latch$1 = latch$1;
                this.bufferCapture$1 = bufferCapture$1;
                this.records$1 = records$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{logMock, fileRecordsMock, this.replicaManager()});
        int coordinatorEpoch = 0;
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(this.partitionId(), coordinatorEpoch);
        Thread loadingThread = new Thread(() -> this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), coordinatorEpoch, (Function4 & Serializable)(x$2, x$3, x$4, x$5) -> {
            TransactionStateManagerTest.$anonfun$testDeleteLoadingPartition$2(BoxesRunTime.unboxToInt((Object)x$2), x$3, x$4, x$5);
            return BoxedUnit.UNIT;
        }));
        loadingThread.start();
        long l = 15000L;
        long waitUntilTrue_pause = 10L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TransactionStateManagerTest.$anonfun$testDeleteLoadingPartition$3(this, partitionAndLeaderEpoch)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Timed out waiting for loading partition");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), waitUntilTrue_pause));
        }
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId());
        Assertions.assertFalse((boolean)this.transactionManager().loadingPartitions().contains((Object)partitionAndLeaderEpoch));
        latch.countDown();
        loadingThread.join();
        Assertions.assertEquals((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR), (Object)this.transactionManager().getTransactionState(this.txnMetadata1().transactionalId()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLoadAndRemoveTransactionsForPartition() {
        MemoryRecords memoryRecords;
        void withRecords_records;
        MemoryRecords memoryRecords2;
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata2().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic3", 0), new TopicPartition("topic3", 1), new TopicPartition("topic3", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)PrepareAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)CompleteAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Empty$.MODULE$);
        this.txnMetadata2().topicPartitions().clear();
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        long startOffset = 15L;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        MemoryRecords memoryRecords3 = memoryRecords2 = MemoryRecords.withRecords((byte)2, (long)startOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Object var9_4 = null;
        memoryRecords2 = null;
        MemoryRecords memoryRecords4 = memoryRecords = memoryRecords3;
        Object var6_3 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords4;
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$1(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)x$6 -> (Nothing$)Assertions.fail((String)new StringBuilder(44).append(this.transactionalId1()).append("'s transaction state is already in the cache").toString()));
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$3(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)x$7 -> (Nothing$)Assertions.fail((String)new StringBuilder(44).append(this.transactionalId2()).append("'s transaction state is already in the cache").toString()));
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable)(x$8, x$9, x$10, x$11) -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$5(BoxesRunTime.unboxToInt((Object)x$8), x$9, x$10, x$11);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable)err -> (Nothing$)Assertions.fail((String)new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state access returns error ").append(err).toString()), (Function1 & Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(50).append(this.transactionalId1()).append("'s transaction state was not loaded into the cache").toString())));
        CoordinatorEpochAndTxnMetadata cachedPidMetadata1 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable)err -> {
            throw new AssertionError((Object)new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state access returns error ").append(err).toString());
        }, (Function1 & Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(50).append(this.transactionalId1()).append("'s transaction state was not loaded into the cache").toString());
        }));
        CoordinatorEpochAndTxnMetadata cachedPidMetadata2 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable)err -> {
            throw new AssertionError((Object)new StringBuilder(42).append(this.transactionalId2()).append("'s transaction state access returns error ").append(err).toString());
        }, (Function1 & Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(50).append(this.transactionalId2()).append("'s transaction state was not loaded into the cache").toString());
        }));
        Assertions.assertEquals((Object)this.txnMetadata1(), (Object)cachedPidMetadata1.transactionMetadata());
        Assertions.assertEquals((Object)this.txnMetadata2(), (Object)cachedPidMetadata2.transactionMetadata());
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$15(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)x$12 -> (Nothing$)Assertions.fail((String)new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state is still in the cache").toString()));
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$17(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)x$13 -> (Nothing$)Assertions.fail((String)new StringBuilder(42).append(this.transactionalId2()).append("'s transaction state is still in the cache").toString()));
    }

    @Test
    public void testCompleteTransitionWhenAppendSucceeded() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NONE);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), this.coordinatorEpoch(), newMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToCoordinatorNotAvailableError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.REQUEST_TIMED_OUT);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToNotCoordinatorError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_LEADER_OR_FOLLOWER);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch() + 1, new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void testAppendFailToCoordinatorLoadingError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_LOAD_IN_PROGRESS);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadingPartition(this.partitionId(), this.coordinatorEpoch() + 1);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void testAppendFailToUnknownError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.UNKNOWN_SERVER_ERROR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.MESSAGE_TOO_LARGE);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.RECORD_LIST_TOO_LARGE);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testPendingStateNotResetOnRetryAppend() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testPendingStateNotResetOnRetryAppend$2(x$14)));
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assertions.assertEquals((Object)new Some((Object)Ongoing$.MODULE$), (Object)this.txnMetadata1().pendingState());
    }

    @Test
    public void testAppendTransactionToLogWhileProducerFenced() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), 0, new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().producerEpoch_$eq((short)(this.txnMetadata1().producerEpoch() + 1));
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, newMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void testAppendTransactionToLogWhilePendingStateChanged() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)None$.MODULE$));
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.INVALID_PRODUCER_EPOCH);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().pendingState_$eq((Option)None$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, newMetadata, (Function1 & Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5()));
    }

    @Test
    public void shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned() {
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable)err -> {
            TransactionStateManagerTest.$anonfun$shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned$1(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)x$15 -> (Nothing$)Assertions.fail((String)new StringBuilder(44).append(this.transactionalId1()).append("'s transaction state is already in the cache").toString()));
    }

    @Test
    public void shouldOnlyConsiderTransactionsInTheOngoingStateToAbort() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)None$.MODULE$)));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("ongoing", 0L, (TransactionState)Ongoing$.MODULE$, this.transactionTimeoutMs()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("not-expiring", 1L, (TransactionState)Ongoing$.MODULE$, 10000));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("prepare-commit", 2L, (TransactionState)PrepareCommit$.MODULE$, this.transactionTimeoutMs()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("prepare-abort", 3L, (TransactionState)PrepareAbort$.MODULE$, this.transactionTimeoutMs()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("complete-commit", 4L, (TransactionState)CompleteCommit$.MODULE$, this.transactionTimeoutMs()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionMetadata("complete-abort", 5L, (TransactionState)CompleteAbort$.MODULE$, this.transactionTimeoutMs()));
        this.time().sleep(2000L);
        Iterable expiring = this.transactionManager().timedOutTransactions();
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TransactionalIdAndProducerIdEpoch[]{new TransactionalIdAndProducerIdEpoch("ongoing", 0L, 0)})), (Object)expiring);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedCommitState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedAbortState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareAbort$.MODULE$);
    }

    @Test
    public void shouldRemoveCompleteCommitExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteCommit$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveCompleteAbortExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveEmptyExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Empty$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveExpiredTransactionalIdsIfLogAppendFails() {
        this.setupAndRunTransactionalIdExpiration(Errors.NOT_ENOUGH_REPLICAS, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveOngoingTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Ongoing$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareAbortTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareCommitTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareCommit$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void testTransactionalExpirationWithTooSmallBatchSize() {
        Range partitionIds = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        int maxBatchSize = 16;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(20);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)partitionIds, maxBatchSize);
        scala.collection.mutable.Map attemptedAppends = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.MESSAGE_TOO_LARGE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)attemptedAppends);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
        attemptedAppends.values().foreach((Function1 & Serializable)batches -> {
            batches.foreach((Function1 & Serializable)batch -> {
                TransactionStateManagerTest.$anonfun$testTransactionalExpirationWithTooSmallBatchSize$2(maxBatchSize$1, batch);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTransactionalExpirationWithOfflineLogDir() {
        void var9_9;
        void var8_8;
        int onlinePartitionId = 0;
        int offlinePartitionId = 1;
        Seq partitionIds = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{onlinePartitionId, offlinePartitionId}));
        int maxBatchSize = 512;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(20);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{onlinePartitionId}))), maxBatchSize);
        EasyMock.expect((Object)this.replicaManager().getLogConfig(new TopicPartition("__transaction_state", offlinePartitionId))).andStubReturn((Object)None$.MODULE$);
        scala.collection.mutable.Map appendedRecords = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.NONE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{onlinePartitionId})), (Object)appendedRecords.keySet().map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.partition())));
        Tuple2 tuple2 = allTransactionalIds.partition((Function1 & Serializable)transactionalId -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testTransactionalExpirationWithOfflineLogDir$2(this, onlinePartitionId, transactionalId)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set transactionalIdsForOnlinePartition = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set transactionalIdsForOfflinePartition = (scala.collection.immutable.Set)tuple2._2();
        scala.collection.immutable.Set<String> expiredTransactionalIds = this.collectTransactionalIdsFromTombstones((scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals((Object)var8_8, expiredTransactionalIds);
        Assertions.assertEquals((Object)var9_9, this.listExpirableTransactionalIds());
    }

    @Test
    public void testTransactionExpirationShouldRespectBatchSize() {
        Range partitionIds = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        int maxBatchSize = 512;
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        scala.collection.immutable.Set<String> allTransactionalIds = this.loadExpiredTransactionalIds(1000);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        this.expectLogConfig((Seq<Object>)partitionIds, maxBatchSize);
        scala.collection.mutable.Map appendedRecords = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(Errors.NONE, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        Assertions.assertEquals(allTransactionalIds, this.listExpirableTransactionalIds());
        this.transactionManager().removeExpiredTransactionalIds();
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.listExpirableTransactionalIds());
        Assertions.assertEquals((Object)partitionIds.toSet(), (Object)appendedRecords.keys().map((Function1 & Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18.partition())));
        appendedRecords.values().foreach((Function1 & Serializable)batches -> {
            TransactionStateManagerTest.$anonfun$testTransactionExpirationShouldRespectBatchSize$2(maxBatchSize, batches);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Set<String> expiredTransactionalIds = this.collectTransactionalIdsFromTombstones((scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        Assertions.assertEquals(allTransactionalIds, expiredTransactionalIds);
    }

    private scala.collection.immutable.Set<String> collectTransactionalIdsFromTombstones(scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>> appendedRecords) {
        scala.collection.mutable.Set expiredTransactionalIds = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        appendedRecords.values().foreach((Function1 & Serializable)batches -> {
            batches.foreach((Function1 & Serializable)records -> {
                TransactionStateManagerTest.$anonfun$collectTransactionalIdsFromTombstones$2($this, expiredTransactionalIds$1, records);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        return expiredTransactionalIds.toSet();
    }

    private scala.collection.immutable.Set<String> loadExpiredTransactionalIds(int numTransactionalIds) {
        scala.collection.mutable.Set allTransactionalIds = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), numTransactionalIds).foreach((Function1 & Serializable)i -> TransactionStateManagerTest.$anonfun$loadExpiredTransactionalIds$1(this, allTransactionalIds, BoxesRunTime.unboxToInt((Object)i)));
        return allTransactionalIds.toSet();
    }

    private scala.collection.immutable.Set<String> listExpirableTransactionalIds() {
        return ((IterableOnceOps)((Iterable)this.transactionManager().transactionMetadataCache().values().flatMap((Function1 & Serializable)x$20 -> (Iterable)x$20.metadataPerTransactionalId().values().map((Function1 & Serializable)x$21 -> x$21.transactionalId()))).filter((Function1 & Serializable)transactionalId -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$listExpirableTransactionalIds$3(this, transactionalId)))).toSet();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuccessfulReimmigration() {
        MemoryRecords memoryRecords;
        void withRecords_records;
        MemoryRecords memoryRecords2;
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        long startOffset = 0L;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        MemoryRecords memoryRecords3 = memoryRecords2 = MemoryRecords.withRecords((byte)2, (long)startOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Object var7_4 = null;
        memoryRecords2 = null;
        MemoryRecords memoryRecords4 = memoryRecords = memoryRecords3;
        Object var4_3 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords4;
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable)(x$22, x$23, x$24, x$25) -> {
            TransactionStateManagerTest.$anonfun$testSuccessfulReimmigration$1(BoxesRunTime.unboxToInt((Object)x$22), x$23, x$24, x$25);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 1, (Function4 & Serializable)(x$26, x$27, x$28, x$29) -> {
            TransactionStateManagerTest.$anonfun$testSuccessfulReimmigration$2(BoxesRunTime.unboxToInt((Object)x$26), x$27, x$28, x$29);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
        Assertions.assertTrue((boolean)this.transactionManager().transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).isDefined());
        Assertions.assertEquals((int)1, (int)((TxnMetadataCacheEntry)this.transactionManager().transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).get()).coordinatorEpoch());
    }

    @Test
    public void testLoadTransactionMetadataWithCorruptedLog() {
        long startOffset = 0L;
        long endOffset = 10L;
        Log logMock = (Log)EasyMock.mock(Log.class);
        EasyMock.expect((Object)this.replicaManager().getLog(this.topicPartition())).andStubReturn((Object)new Some((Object)logMock));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (FetchIsolation)EasyMock.eq((Object)FetchLogEnd$.MODULE$), EasyMock.eq((boolean)true))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), (Records)MemoryRecords.EMPTY, false, (Option)None$.MODULE$));
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(this.topicPartition())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        EasyMock.replay((Object[])new Object[]{logMock});
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable)(x$30, x$31, x$32, x$33) -> {
            TransactionStateManagerTest.$anonfun$testLoadTransactionMetadataWithCorruptedLog$1(BoxesRunTime.unboxToInt((Object)x$30), x$31, x$32, x$33);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        EasyMock.verify((Object[])new Object[]{logMock});
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
        Assertions.assertEquals((int)0, (int)this.transactionManager().loadingPartitions().size());
    }

    private void verifyMetadataDoesExistAndIsUsable(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"shouldn't have been any errors");
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)Assertions.fail((String)"metadata should have been removed");
                return;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            Assertions.assertTrue((boolean)((CoordinatorEpochAndTxnMetadata)((Some)option).value()).transactionMetadata().pendingState().isEmpty(), (String)"metadata shouldn't be in a pending state");
            return;
        }
        throw new MatchError((Object)either);
    }

    private void verifyMetadataDoesntExist(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"shouldn't have been any errors");
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            if ((Option)right.value() instanceof Some) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)Assertions.fail((String)"metadata should have been removed");
                return;
            }
        }
        if (bl && None$.MODULE$.equals(option = (Option)right.value())) {
            return;
        }
        throw new MatchError((Object)either);
    }

    private void expectTransactionalIdExpiration(Errors appendError, scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>> capturedAppends) {
        Capture recordsCapture = EasyMock.newCapture();
        Capture callbackCapture = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.eq((short)((short)-1)), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)EasyMock.capture((Capture)recordsCapture), (Function1)EasyMock.capture((Capture)callbackCapture), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer(() -> {
            TransactionStateManagerTest.$anonfun$expectTransactionalIdExpiration$1(callbackCapture, recordsCapture, capturedAppends, appendError);
            return BoxedUnit.UNIT;
        }).anyTimes();
    }

    private void loadTransactionsForPartitions(Seq<Object> partitionIds) {
        partitionIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)None$.MODULE$)));
    }

    private void expectLogConfig(Seq<Object> partitionIds, int maxBatchSize) {
        LogConfig logConfig = (LogConfig)EasyMock.mock(LogConfig.class);
        EasyMock.expect((Object)logConfig.maxMessageSize()).andStubReturn((Object)Predef$.MODULE$.int2Integer(maxBatchSize));
        partitionIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)partitionId -> EasyMock.expect((Object)this.replicaManager().getLogConfig(new TopicPartition("__transaction_state", partitionId))).andStubReturn((Object)new Some((Object)logConfig)));
        EasyMock.replay((Object[])new Object[]{logConfig});
    }

    /*
     * WARNING - void declaration
     */
    private void setupAndRunTransactionalIdExpiration(Errors error, TransactionState txnState) {
        Range partitionIds = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions());
        this.loadTransactionsForPartitions((Seq<Object>)partitionIds);
        this.expectLogConfig((Seq<Object>)partitionIds, kafka.log.Defaults$.MODULE$.MaxMessageSize());
        this.txnMetadata1().txnLastUpdateTimestamp_$eq(this.time().milliseconds() - (long)this.txnConfig().transactionalIdExpirationMs());
        this.txnMetadata1().state_$eq(txnState);
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata1());
        this.txnMetadata2().txnLastUpdateTimestamp_$eq(this.time().milliseconds());
        this.transactionManager().putTransactionStateIfNotExists(this.txnMetadata2());
        scala.collection.mutable.Map appendedRecords = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.expectTransactionalIdExpiration(error, (scala.collection.mutable.Map<TopicPartition, Buffer<MemoryRecords>>)appendedRecords);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.transactionManager().removeExpiredTransactionalIds();
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
        boolean bl = Empty$.MODULE$.equals(txnState) ? true : (CompleteCommit$.MODULE$.equals(txnState) ? true : CompleteAbort$.MODULE$.equals(txnState));
        boolean bl2 = bl;
        if (bl2) {
            MemoryRecords memoryRecords;
            MemoryRecords memoryRecords2;
            void withRecords_records;
            void withRecords_timestampType;
            MemoryRecords memoryRecords3;
            int partitionId = this.transactionManager().partitionFor(this.transactionalId1());
            TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
            SimpleRecord expectedTombstone = new SimpleRecord(this.time().milliseconds(), TransactionLog$.MODULE$.keyToBytes(this.transactionalId1()), null);
            SimpleRecord[] simpleRecordArray = new SimpleRecord[]{expectedTombstone};
            CompressionType withRecords_compressionType = TransactionLog$.MODULE$.EnforcedCompressionType();
            byte withRecords_magic = 2;
            TimestampType timestampType = TimestampType.CREATE_TIME;
            long withRecords_initialOffset = 0L;
            MemoryRecords memoryRecords4 = memoryRecords3 = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
            timestampType = null;
            memoryRecords3 = null;
            MemoryRecords memoryRecords5 = memoryRecords2 = memoryRecords4;
            memoryRecords2 = null;
            MemoryRecords memoryRecords6 = memoryRecords = memoryRecords5;
            Object var11_11 = null;
            simpleRecordArray = null;
            memoryRecords = null;
            MemoryRecords expectedRecords = memoryRecords6;
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition})), (Object)appendedRecords.keySet());
            Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MemoryRecords[]{expectedRecords})), (Object)((IterableOnceOps)appendedRecords.apply((Object)topicPartition)).toSeq());
            return;
        }
        Assertions.assertEquals((Object)scala.collection.Map$.MODULE$.empty(), (Object)appendedRecords);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyWritesTxnMarkersInPrepareState(TransactionState state) {
        MemoryRecords memoryRecords;
        void withRecords_records;
        MemoryRecords memoryRecords2;
        this.txnMetadata1().state_$eq(state);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        long startOffset = 0L;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        MemoryRecords memoryRecords3 = memoryRecords2 = MemoryRecords.withRecords((byte)2, (long)startOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Object var9_5 = null;
        memoryRecords2 = null;
        MemoryRecords memoryRecords4 = memoryRecords = memoryRecords3;
        Object var6_4 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords4;
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        ObjectRef txnId = ObjectRef.create(null);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable)(coordinatorEpoch, command, metadata, newMetadata) -> {
            TransactionStateManagerTest.rememberTxnMarkers$1(BoxesRunTime.unboxToInt((Object)coordinatorEpoch), command, metadata, newMetadata, txnId);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Assertions.assertEquals((Object)this.transactionalId1(), (Object)((String)txnId.elem));
    }

    private void assertCallback(Errors error) {
        Assertions.assertEquals((Object)this.expectedError(), (Object)error);
    }

    private TransactionMetadata transactionMetadata(String transactionalId, long producerId, TransactionState state, int txnTimeout) {
        return TransactionMetadata$.MODULE$.apply(transactionalId, producerId, (short)0, txnTimeout, state, this.time().milliseconds());
    }

    private TransactionState transactionMetadata$default$3() {
        return Empty$.MODULE$;
    }

    private int transactionMetadata$default$4() {
        return this.transactionTimeoutMs();
    }

    private void prepareTxnLog(TopicPartition topicPartition, long startOffset, MemoryRecords records) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Log logMock = (Log)EasyMock.mock(Log.class);
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        long endOffset = startOffset + (long)CollectionConverters$.MODULE$.IterableHasAsScala(records.records()).asScala().size();
        EasyMock.expect((Object)this.replicaManager().getLog(topicPartition)).andStubReturn((Object)new Some((Object)logMock));
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(topicPartition)).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (FetchIsolation)EasyMock.eq((Object)FetchLogEnd$.MODULE$), EasyMock.eq((boolean)true))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), (Records)fileRecordsMock, false, (Option)None$.MODULE$));
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        Capture bufferCapture = EasyMock.newCapture();
        fileRecordsMock.readInto((ByteBuffer)EasyMock.capture((Capture)bufferCapture), EasyMock.anyInt());
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, bufferCapture, records){
            private final Capture bufferCapture$2;
            private final MemoryRecords records$2;

            public void answer() {
                ByteBuffer buffer = (ByteBuffer)this.bufferCapture$2.getValue();
                buffer.put(this.records$2.buffer().duplicate());
                buffer.flip();
            }
            {
                this.bufferCapture$2 = bufferCapture$2;
                this.records$2 = records$2;
            }
        });
        EasyMock.replay((Object[])new Object[]{logMock, fileRecordsMock, this.replicaManager()});
    }

    private void prepareForTxnMessageAppend(Errors error) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Capture capturedArgument = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)capturedArgument), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer(() -> {
            TransactionStateManagerTest.$anonfun$prepareForTxnMessageAppend$1(this, capturedArgument, error);
            return BoxedUnit.UNIT;
        });
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionLoadMetric() {
        MemoryRecords memoryRecords;
        void withRecords_records;
        MemoryRecords memoryRecords2;
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        String mBeanName = "kafka.server:type=transaction-coordinator-metrics";
        JmxReporter reporter = new JmxReporter();
        KafkaMetricsContext metricsContext = new KafkaMetricsContext("kafka.server");
        reporter.contextChange((MetricsContext)metricsContext);
        this.metrics().addReporter((MetricsReporter)reporter);
        Assertions.assertTrue((boolean)server.isRegistered(new ObjectName(mBeanName)));
        Assertions.assertEquals((double)Double.NaN, (double)TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-max", server, mBeanName), (double)0.0);
        Assertions.assertEquals((double)Double.NaN, (double)TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-avg", server, mBeanName), (double)0.0);
        Assertions.assertTrue((boolean)reporter.containsMbean(mBeanName));
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 1), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        long startOffset = 15L;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        MemoryRecords memoryRecords3 = memoryRecords2 = MemoryRecords.withRecords((byte)2, (long)startOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Object var11_8 = null;
        memoryRecords2 = null;
        MemoryRecords memoryRecords4 = memoryRecords = memoryRecords3;
        Object var8_7 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords4;
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function4 & Serializable)(x$34, x$35, x$36, x$37) -> {
            TransactionStateManagerTest.$anonfun$testPartitionLoadMetric$1(BoxesRunTime.unboxToInt((Object)x$34), x$35, x$36, x$37);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Assertions.assertTrue((TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-max", server, mBeanName) >= 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((TransactionStateManagerTest.partitionLoadTime$1("partition-load-time-avg", server, mBeanName) >= 0.0 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ short $anonfun$testDeletePartition$1(CoordinatorEpochAndTxnMetadata x$1) {
        return x$1.transactionMetadata().producerEpoch();
    }

    private final Option cachedProducerEpoch$1(String transactionalId) {
        return this.transactionManager().getTransactionState(transactionalId).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToShort((short)TransactionStateManagerTest.$anonfun$testDeletePartition$1(x$1)));
    }

    public static final /* synthetic */ void $anonfun$testDeleteLoadingPartition$2(int x$2, TransactionResult x$3, TransactionMetadata x$4, TxnTransitMetadata x$5) {
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteLoadingPartition$3(TransactionStateManagerTest $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1) {
        return $this.transactionManager().loadingPartitions().contains((Object)partitionAndLeaderEpoch$1);
    }

    public static final /* synthetic */ String $anonfun$testDeleteLoadingPartition$4() {
        return "Timed out waiting for loading partition";
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$1(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$3(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$5(int x$8, TransactionResult x$9, TransactionMetadata x$10, TxnTransitMetadata x$11) {
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$15(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$17(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ boolean $anonfun$testPendingStateNotResetOnRetryAppend$2(Errors x$14) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned$1(Errors err) {
        Assertions.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testTransactionalExpirationWithTooSmallBatchSize$2(int maxBatchSize$1, MemoryRecords batch) {
        Assertions.assertTrue((batch.sizeInBytes() > maxBatchSize$1 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionalExpirationWithOfflineLogDir$2(TransactionStateManagerTest $this, int onlinePartitionId$1, String transactionalId) {
        return $this.transactionManager().partitionFor(transactionalId) == onlinePartitionId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionExpirationShouldRespectBatchSize$3(int maxBatchSize$2, MemoryRecords x$19) {
        return x$19.sizeInBytes() < maxBatchSize$2;
    }

    public static final /* synthetic */ void $anonfun$testTransactionExpirationShouldRespectBatchSize$2(int maxBatchSize$2, Buffer batches) {
        Assertions.assertTrue((batches.size() > 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)batches.forall((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testTransactionExpirationShouldRespectBatchSize$3(maxBatchSize$2, x$19))));
    }

    public static final /* synthetic */ void $anonfun$collectTransactionalIdsFromTombstones$2(TransactionStateManagerTest $this, scala.collection.mutable.Set expiredTransactionalIds$1, MemoryRecords records) {
        records.records().forEach(record -> {
            String transactionalId = TransactionLog$.MODULE$.readTxnRecordKey(record.key()).transactionalId();
            Assertions.assertNull((Object)record.value());
            expiredTransactionalIds$1.$plus$eq((Object)transactionalId);
            Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)$this.transactionManager().getTransactionState(transactionalId));
        });
    }

    public static final /* synthetic */ scala.collection.mutable.Set $anonfun$loadExpiredTransactionalIds$1(TransactionStateManagerTest $this, scala.collection.mutable.Set allTransactionalIds$1, int i) {
        String txnlId = new StringBuilder(3).append("id_").append(i).toString();
        TransactionMetadata txnMetadata = $this.transactionMetadata(txnlId, i, (TransactionState)Empty$.MODULE$, $this.transactionTimeoutMs());
        txnMetadata.txnLastUpdateTimestamp_$eq($this.time().milliseconds() - (long)$this.txnConfig().transactionalIdExpirationMs());
        $this.transactionManager().putTransactionStateIfNotExists(txnMetadata);
        return (scala.collection.mutable.Set)allTransactionalIds$1.$plus$eq((Object)txnlId);
    }

    public static final /* synthetic */ boolean $anonfun$listExpirableTransactionalIds$3(TransactionStateManagerTest $this, String transactionalId) {
        boolean bl;
        Option option;
        Either either = $this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Right && (option = (Option)((Right)either).value()) instanceof Some) {
            TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)option).value()).transactionMetadata();
            bl = $this.time().milliseconds() - txnMetadata.txnLastUpdateTimestamp() >= (long)$this.txnConfig().transactionalIdExpirationMs() && txnMetadata.state().isExpirationAllowed() && txnMetadata.pendingState().isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulReimmigration$1(int x$22, TransactionResult x$23, TransactionMetadata x$24, TxnTransitMetadata x$25) {
    }

    public static final /* synthetic */ void $anonfun$testSuccessfulReimmigration$2(int x$26, TransactionResult x$27, TransactionMetadata x$28, TxnTransitMetadata x$29) {
    }

    public static final /* synthetic */ void $anonfun$testLoadTransactionMetadataWithCorruptedLog$1(int x$30, TransactionResult x$31, TransactionMetadata x$32, TxnTransitMetadata x$33) {
    }

    public static final /* synthetic */ void $anonfun$expectTransactionalIdExpiration$1(Capture callbackCapture$1, Capture recordsCapture$1, scala.collection.mutable.Map capturedAppends$1, Errors appendError$1) {
        ((Function1)callbackCapture$1.getValue()).apply((Object)((MapOps)recordsCapture$1.getValue()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            MemoryRecords records = (MemoryRecords)x0$1._2();
            ((Buffer)capturedAppends$1.getOrElse((Object)topicPartition, (Function0 & Serializable)() -> {
                void var2_2;
                Buffer batches = (Buffer)Buffer$.MODULE$.empty();
                capturedAppends$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)batches));
                return var2_2;
            })).$plus$eq((Object)records);
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new ProduceResponse.PartitionResponse(appendError$1, 0L, -1L, 0L));
            return tuple2;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private static final void rememberTxnMarkers$1(int coordinatorEpoch, TransactionResult command, TransactionMetadata metadata, TxnTransitMetadata newMetadata, ObjectRef txnId$1) {
        txnId$1.elem = metadata.transactionalId();
    }

    public static final /* synthetic */ void $anonfun$prepareForTxnMessageAppend$1(TransactionStateManagerTest $this, Capture capturedArgument$1, Errors error$1) {
        ((Function1)capturedArgument$1.getValue()).apply(scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("__transaction_state", $this.partitionId())), (Object)new ProduceResponse.PartitionResponse(error$1, 0L, -1L, 0L))})));
    }

    private static final double partitionLoadTime$1(String attribute, MBeanServer server$1, String mBeanName$1) {
        return BoxesRunTime.unboxToDouble((Object)server$1.getAttribute(new ObjectName(mBeanName$1), attribute));
    }

    public static final /* synthetic */ void $anonfun$testPartitionLoadMetric$1(int x$34, TransactionResult x$35, TransactionMetadata x$36, TxnTransitMetadata x$37) {
    }

    public TransactionStateManagerTest() {
        this.partitionId = 0;
        this.numPartitions = 2;
        this.transactionTimeoutMs = 1000;
        this.coordinatorEpoch = 10;
        EasyMock.expect((Object)this.zkClient().getTopicPartitionCount("__transaction_state")).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.numPartitions()))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.metrics = new Metrics();
        this.txnConfig = new TransactionConfig(TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs(), TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs(), TransactionLog$.MODULE$.DefaultNumPartitions(), TransactionLog$.MODULE$.DefaultReplicationFactor(), TransactionLog$.MODULE$.DefaultSegmentBytes(), TransactionLog$.MODULE$.DefaultLoadBufferSize(), TransactionLog$.MODULE$.DefaultMinInSyncReplicas(), TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs(), TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs(), Defaults$.MODULE$.RequestTimeoutMs());
        this.transactionManager = new TransactionStateManager(0, (Scheduler)this.scheduler(), this.replicaManager(), this.txnConfig(), (Time)this.time(), this.metrics());
        this.transactionalId1 = "one";
        this.transactionalId2 = "two";
        this.txnMessageKeyBytes1 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId1());
        this.txnMessageKeyBytes2 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId2());
        this.producerIds = (Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId1()), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId2()), (Object)BoxesRunTime.boxToLong((long)2L))}));
        this.txnMetadata1 = this.transactionMetadata(this.transactionalId1(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId1())), (TransactionState)Empty$.MODULE$, this.transactionTimeoutMs());
        this.txnMetadata2 = this.transactionMetadata(this.transactionalId2(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId2())), (TransactionState)Empty$.MODULE$, this.transactionTimeoutMs());
        this.expectedError = Errors.NONE;
    }
}

